/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.cui.validators;

import javax.swing.JComboBox;
import javax.swing.JComponent;
import utils.swing.cui.validators.Validator;

public class ComboBoxValidator
extends Validator {
    private int[] setOfValidIndices = null;
    private Object[] setOfValidObjects = null;

    public ComboBoxValidator(int[] setOfValidIndices) {
        this.setOfValidIndices = setOfValidIndices;
    }

    public ComboBoxValidator(Object[] setOfValidObjects) {
        this.setOfValidObjects = setOfValidObjects;
    }

    @Override
    public String getValidatorID() {
        return "combobox";
    }

    @Override
    public String toXML() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<Validator type=\"" + this.getValidatorID() + "\">");
        if (this.setOfValidIndices != null) {
            for (int i = 0; i < this.setOfValidIndices.length; ++i) {
                if (i > 0) {
                    buffer.append(",");
                }
                buffer.append(Integer.toString(this.setOfValidIndices[i]));
            }
        }
        buffer.append("</Validator>");
        return buffer.toString();
    }

    @Override
    public boolean isValid(JComponent component) {
        if (!(component instanceof JComboBox)) {
            System.out.println("[ComboBoxValidator] Unknown component type: " + component.getClass().getName());
            return false;
        }
        JComboBox box = (JComboBox)component;
        int selectedIndex = box.getSelectedIndex();
        Object selectedObject = box.getSelectedItem();
        if (this.setOfValidIndices != null) {
            for (int i = 0; i < this.setOfValidIndices.length; ++i) {
                if (this.setOfValidIndices[i] != selectedIndex) continue;
                return true;
            }
            return false;
        }
        if (this.setOfValidObjects != null) {
            for (int i = 0; i < this.setOfValidObjects.length; ++i) {
                if (this.setOfValidObjects[i] != selectedObject) continue;
                return true;
            }
            return false;
        }
        return false;
    }
}

