/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.cui.types.fields;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.w3c.dom.Element;
import utils.swing.components.documents.MaxLengthTextDocument;
import utils.swing.components.messagefields.MessageComponent;
import utils.swing.components.messagefields.MessagePasswordTextField;
import utils.swing.components.messagefields.MessageTextField;
import utils.swing.cui.types.CUIField;
import utils.swing.cui.types.CUIPopulateDialog;
import utils.swing.cui.types.ResultPair;
import utils.swing.cui.types.fields.AbstractField;
import utils.swing.cui.validators.RequiredValidator;
import utils.swing.cui.validators.TextFieldIntegerRangeValidator;
import utils.swing.cui.validators.TextFieldLengthValidator;
import utils.swing.cui.validators.TextFieldRegexContentValidator;
import utils.swing.customlaf.SHButtonUI;
import utils.xml.XML14Util;

public class TextField
extends AbstractField
implements ActionListener {
    public static final String TEXTFIELD_TYPE = "textfield";
    public static final int ANY_TYPE = 0;
    public static final int INTEGER_TYPE = 1;
    public static final int FLOAT_TYPE = 2;
    public static final int LETTER_TYPE = 3;
    public static final int ALPHANUMERIC_TYPE = 4;
    public static final int EMAIL_TYPE = 5;
    public static final int URL_TYPE = 6;
    public static final int PASSWORD_TYPE = 7;
    public static final int PORT_TYPE = 8;
    protected JTextField textField;
    protected JPanel combined;
    protected JButton picky;
    private String defaultValue = null;
    private String exampleValue = null;
    private int min = -1;
    private int max = -1;
    private CUIPopulateDialog poppy;
    private boolean isRequired = false;

    public static JTextField getTextFieldForType(int subtype) {
        return (JTextField)new TextField(null, null, subtype).getComponent();
    }

    public static JTextField getTextFieldForType(int subtype, String exampleValue) {
        TextField textField = new TextField(null, null, subtype);
        textField.setExampleValue(exampleValue);
        return (JTextField)textField.getComponent();
    }

    public void setCUIPopulateDialog(CUIPopulateDialog poppy, Icon icon) {
        this.poppy = poppy;
        this.picky = new JButton(icon);
        SHButtonUI.makeButtonSegmentedRight(this.picky);
        this.combined = new JPanel();
        this.combined.setLayout(new BorderLayout());
        this.combined.add("Center", this.textField);
        this.combined.add("East", this.picky);
        this.picky.addActionListener(this);
    }

    public JButton getPickingButton() {
        return this.picky;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String result = this.poppy.launchDialog();
        if (result != null) {
            this.textField.setText(result);
            this.proxyChangeListener.actionPerformed(e);
        }
    }

    protected boolean hasCUIPopulateDialog() {
        return this.poppy != null;
    }

    public String getTextFieldValue() {
        return this.textField.getText();
    }

    @Override
    public void toXML(StringBuffer buffer, int tabs) {
        if (this.defaultValue != null) {
            buffer.append(XML14Util.getIndent(tabs)).append("<Default>" + this.defaultValue + "</Default>\n");
        }
        if (this.exampleValue != null) {
            buffer.append(XML14Util.getIndent(tabs)).append("<Example>" + this.exampleValue + "</Example>\n");
        }
        if (this.isRequired) {
            buffer.append(XML14Util.getIndent(tabs)).append("<Required>" + Boolean.toString(true) + "</Required>\n");
        }
        if (this.min != -1 || this.max != -1) {
            buffer.append(XML14Util.getIndent(tabs)).append("<SizeConstraints max=\"" + this.max + "\" min=\"" + this.min + "\" />\n");
        }
    }

    public static CUIField fromXML(Element element, AbstractField.ChangeListener cl) {
        Element sizeConstraintsElement;
        String label = element.getAttribute("label");
        int subType = 0;
        if (element.getAttribute("subType") != null && element.getAttribute("subType").length() > 0) {
            subType = TextField.nameToSubType(element.getAttribute("subType"));
        }
        TextField type = new TextField(label, cl, subType);
        type.setDefaultValue(XML14Util.getChildText(element, "Default", null));
        type.setExampleValue(XML14Util.getChildText(element, "Example", null));
        if (XML14Util.getChildText(element, "Required", null) != null) {
            type.setRequired(true);
        }
        if ((sizeConstraintsElement = XML14Util.getChildByName(element, "SizeConstraints")) != null) {
            String minString = sizeConstraintsElement.getAttribute("min");
            String maxString = sizeConstraintsElement.getAttribute("max");
            int min = -1;
            try {
                min = Integer.parseInt(minString);
            }
            catch (Throwable t) {
                t.printStackTrace();
                min = -1;
            }
            int max = -1;
            try {
                max = Integer.parseInt(maxString);
            }
            catch (Throwable t) {
                t.printStackTrace();
                max = -1;
            }
            type.setLengthConstraints(max, min);
        }
        return type;
    }

    public TextField(String label, AbstractField.ChangeListener listener) {
        this(label, listener, 0);
    }

    public TextField(String label, AbstractField.ChangeListener listener, int subType) {
        this(TEXTFIELD_TYPE, subType, label, listener);
    }

    public void setEditable(boolean b) {
        this.textField.setEditable(b);
    }

    @Override
    public ResultPair getReadableFilledOutData(ResourceBundle bundle) {
        return new ResultPair(this.label, this.textField.getText());
    }

    @Override
    public void setStorableFilledOutData(ResultPair data) {
        if (this.textField instanceof MessageTextField) {
            this.textField.setText(data.getValue());
        } else {
            this.textField.setText(data.getValue());
        }
    }

    @Override
    public ResultPair getStorableFilledOutData() {
        return new ResultPair(this.label, this.textField.getText());
    }

    protected static int nameToSubType(String subTypeName) {
        if (subTypeName == null) {
            return 0;
        }
        if (subTypeName.equals("integer")) {
            return 1;
        }
        if (subTypeName.equals("float")) {
            return 2;
        }
        if (subTypeName.equals("letter")) {
            return 3;
        }
        if (subTypeName.equals("alphanumberic")) {
            return 4;
        }
        if (subTypeName.equals("email")) {
            return 5;
        }
        if (subTypeName.equals("url")) {
            return 6;
        }
        if (subTypeName.equals("password")) {
            return 7;
        }
        if (subTypeName.equals("port")) {
            return 8;
        }
        return 0;
    }

    @Override
    protected String subTypeToName() {
        switch (this.subType) {
            case 0: {
                return null;
            }
            case 1: {
                return "integer";
            }
            case 2: {
                return "float";
            }
            case 3: {
                return "letter";
            }
            case 4: {
                return "alphanumeric";
            }
            case 5: {
                return "email";
            }
            case 6: {
                return "url";
            }
            case 7: {
                return "password";
            }
            case 8: {
                return "port";
            }
        }
        return null;
    }

    protected TextField(String id, int subType, String label, AbstractField.ChangeListener listener) {
        super(id, subType, label, listener);
        this.textField.addKeyListener(this.proxyChangeListener);
    }

    @Override
    protected void initValidatorsForSubType() {
        switch (this.subType) {
            case 0: {
                return;
            }
            case 8: {
                this.addValidator(new TextFieldRegexContentValidator(TextFieldRegexContentValidator.NUMBER_INTEGER_REGEX));
                this.addValidator(new TextFieldIntegerRangeValidator(0, 65535));
                this.textField.addKeyListener(DigitRestrictedKeyListener.INSTANCE);
                return;
            }
            case 1: {
                this.addValidator(new TextFieldRegexContentValidator(TextFieldRegexContentValidator.NUMBER_INTEGER_REGEX));
                this.textField.addKeyListener(DigitRestrictedKeyListener.INSTANCE);
                return;
            }
            case 2: {
                this.addValidator(new TextFieldRegexContentValidator(TextFieldRegexContentValidator.NUMBER_FLOAT_REGEX));
                this.textField.addKeyListener(NumberRestrictedKeyListener.INSTANCE);
                return;
            }
            case 3: {
                this.addValidator(new TextFieldRegexContentValidator(TextFieldRegexContentValidator.LETTERS_REGEX));
                this.textField.addKeyListener(LetterRestrictedKeyListener.INSTANCE);
                return;
            }
            case 4: {
                this.addValidator(new TextFieldRegexContentValidator(TextFieldRegexContentValidator.ALPHANUMERIC_REGEX));
                this.textField.addKeyListener(AlphaNumericRestrictedKeyListener.INSTANCE);
                return;
            }
            case 5: {
                this.addValidator(new TextFieldRegexContentValidator(TextFieldRegexContentValidator.EMAIL_REGEX));
                return;
            }
            case 6: {
                this.addValidator(new TextFieldRegexContentValidator(TextFieldRegexContentValidator.URL_REGEX));
                return;
            }
            case 7: {
                return;
            }
        }
    }

    @Override
    protected void initComponent() {
        this.textField = this.subType == 7 ? new MessagePasswordTextField(null, null) : new MessageTextField(null, null);
    }

    @Override
    public JComponent getComponent() {
        if (this.combined != null) {
            return this.combined;
        }
        return this.textField;
    }

    public void setExampleValue(String exampleValue) {
        this.exampleValue = exampleValue;
        ((MessageComponent)((Object)this.textField)).setMessageText(exampleValue);
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        if (this.textField instanceof MessageTextField) {
            if (defaultValue != null) {
                this.textField.setText(defaultValue);
            } else {
                ((MessageTextField)this.textField).clear();
            }
        } else if (this.textField instanceof MessagePasswordTextField) {
            if (defaultValue != null) {
                this.textField.setText(defaultValue);
            } else {
                ((MessagePasswordTextField)this.textField).clear();
            }
        } else if (defaultValue != null) {
            this.textField.setText(defaultValue);
        } else {
            this.textField.setText("");
        }
    }

    public void setLengthConstraints(int maxCharacters, int minCharacters) {
        this.max = maxCharacters;
        this.min = minCharacters;
        super.addValidator(new TextFieldLengthValidator(maxCharacters, minCharacters));
        if (maxCharacters != -1) {
            this.textField.setDocument(new MaxLengthTextDocument(maxCharacters));
        }
    }

    public void restrictInputCharactersTo(char[] restrictedSet) {
        this.addValidator(new TextFieldRegexContentValidator(restrictedSet));
        this.textField.addKeyListener(new CharacterRestrictedKeyListener(restrictedSet));
    }

    public void setRequired(boolean isRequired) {
        this.isRequired = isRequired;
        if (isRequired) {
            this.addValidator(new RequiredValidator(isRequired));
        }
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getExampleValue() {
        return this.exampleValue;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    @Override
    public void clearContents() {
        if (this.textField instanceof MessageTextField) {
            ((MessageTextField)this.textField).clear();
        } else {
            this.textField.setText("");
        }
    }

    static class AlphaNumericRestrictedKeyListener
    extends RestrictedKeyListener {
        static AlphaNumericRestrictedKeyListener INSTANCE = new AlphaNumericRestrictedKeyListener();

        AlphaNumericRestrictedKeyListener() {
        }

        @Override
        public boolean allow(char c) {
            return Character.isDigit(c) || Character.isLetter(c);
        }
    }

    static class CharacterRestrictedKeyListener
    extends RestrictedKeyListener {
        private String validCharString;

        public CharacterRestrictedKeyListener(char[] restrictedSet) {
            this.validCharString = new String(restrictedSet);
        }

        public CharacterRestrictedKeyListener(String restrictedSet) {
            this.validCharString = restrictedSet;
        }

        @Override
        public boolean allow(char c) {
            return this.validCharString.indexOf(c) != -1;
        }
    }

    static class DigitRestrictedKeyListener
    extends RestrictedKeyListener {
        static DigitRestrictedKeyListener INSTANCE = new DigitRestrictedKeyListener();

        DigitRestrictedKeyListener() {
        }

        @Override
        public boolean allow(char c) {
            return Character.isDigit(c);
        }
    }

    static class LetterRestrictedKeyListener
    extends RestrictedKeyListener {
        static LetterRestrictedKeyListener INSTANCE = new LetterRestrictedKeyListener();

        LetterRestrictedKeyListener() {
        }

        @Override
        public boolean allow(char c) {
            return Character.isLetter(c);
        }
    }

    static class NumberRestrictedKeyListener
    extends CharacterRestrictedKeyListener {
        static NumberRestrictedKeyListener INSTANCE = new NumberRestrictedKeyListener();

        public NumberRestrictedKeyListener() {
            super(NumberRestrictedKeyListener.getAllNumberFormatChars());
        }

        private static String getAllNumberFormatChars() {
            DecimalFormatSymbols FORMAT_SYMBOLS = new DecimalFormatSymbols(Locale.getDefault());
            StringBuffer buffer = new StringBuffer();
            buffer.append(FORMAT_SYMBOLS.getDecimalSeparator());
            buffer.append(FORMAT_SYMBOLS.getGroupingSeparator());
            buffer.append(FORMAT_SYMBOLS.getMinusSign());
            return buffer.toString();
        }

        @Override
        public boolean allow(char c) {
            if (super.allow(c)) {
                return true;
            }
            return Character.isDigit(c);
        }
    }

    static abstract class RestrictedKeyListener
    extends KeyAdapter {
        RestrictedKeyListener() {
        }

        public abstract boolean allow(char var1);

        @Override
        public void keyTyped(KeyEvent event) {
            char typedChar = event.getKeyChar();
            if (!this.allow(typedChar)) {
                event.consume();
            }
        }
    }
}

