/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.browser;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import utils.ostools.OS;
import utils.ostools.RunCommandGetOutput;
import utils.swing.browser.LinuxBrowser;
import utils.swing.browser.MacBrowser;
import utils.swing.browser.WinBrowser;

public class Browser {
    public static void openFileExplorer(File dir) {
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().open(dir);
            }
            catch (IOException x) {
                x.printStackTrace();
            }
        }
    }

    public static void openFileExplorerAndSelectFile(File file) {
        try {
            if (OS.isMacOS()) {
                RunCommandGetOutput.runCommand(new String[]{"open", "-R", file.getAbsolutePath()}, null, false, false);
            } else if (OS.isWindows()) {
                RunCommandGetOutput.runCommand(new String[]{"explorer.exe", "/select,\"" + file.getAbsolutePath() + "\""}, null, false, false);
            } else {
                Browser.openFileExplorer(file.getParentFile());
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public static void openURL(URL url) {
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(url.toURI());
                return;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            if (OS.isWindows()) {
                WinBrowser.openURL(url);
            } else if (OS.isMacOS()) {
                MacBrowser.openURL(url);
            } else if (OS.isLinux()) {
                LinuxBrowser.openURL(url);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

