/*
 * Decompiled with CFR 0.152.
 */
package utils.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.text.View;
import utils.ostools.OS;
import utils.ostools.osx.OSXAdapter;
import utils.swing.customlaf.SHBorderFactory;

public class SwingUtil {
    public static final String PROPERTY_COLOR = "color";
    public static final String KEY_COLOR_BLUE = "blue";
    public static final String KEY_COLOR_RED = "red";
    private static final JLabel resizer = new JLabel();
    private static final JPanel panel = new JPanel();

    public static void padWithEmptyBorder(JComponent comp, int size) {
        comp.setBorder(SHBorderFactory.createEmptyBorder(size, size, size, size));
    }

    public static void centreFrame(JFrame frame) {
        frame.setLocationRelativeTo(null);
    }

    public static long getHWNDWindowId(Frame frame) {
        try {
            Object wComponentPeer = SwingUtil.invokeMethod(frame, "getPeer");
            return (Long)SwingUtil.invokeMethod(wComponentPeer, "getHWnd");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0L;
        }
    }

    private static Object invokeMethod(Object o, String methodName) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class<?> c = o.getClass();
        for (Method m : c.getMethods()) {
            if (!m.getName().equals(methodName)) continue;
            return m.invoke(o, new Object[0]);
        }
        System.out.println("[GUI] Methid " + methodName + " not found.");
        return null;
    }

    public static void removeAllActionListeners(JButton button) {
        ActionListener[] list = button.getActionListeners();
        for (int i = 0; i < list.length; ++i) {
            button.removeActionListener(list[i]);
        }
    }

    public static void frameToFront(final RootPaneContainer rpc) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (rpc != null) {
                    if (rpc instanceof Component) {
                        ((Component)((Object)rpc)).setVisible(true);
                    }
                    if (rpc instanceof Frame) {
                        Frame frame = (Frame)((Object)rpc);
                        if (OS.isWindows()) {
                            int extendedState = frame.getExtendedState();
                            frame.setExtendedState(1);
                            frame.setVisible(true);
                            frame.setExtendedState(extendedState);
                        } else {
                            frame.setExtendedState(0);
                            frame.setVisible(true);
                        }
                        frame.toFront();
                        frame.repaint();
                    } else if (rpc instanceof Window) {
                        ((Window)((Object)rpc)).setVisible(true);
                        ((Window)((Object)rpc)).toFront();
                        ((Window)((Object)rpc)).repaint();
                    }
                    if (OS.isMacOS()) {
                        OSXAdapter.requestForeground(true);
                    }
                }
            }
        });
    }

    public static JLayeredPane getParentLayeredPane(Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof JLayeredPane) {
            return (JLayeredPane)component;
        }
        return SwingUtil.getParentLayeredPane(component.getParent());
    }

    public static Frame getParentFrame(Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof Frame) {
            return (Frame)component;
        }
        return SwingUtil.getParentFrame(component.getParent());
    }

    public static JRootPane getRootPane(Component component) {
        JRootPane rootPane = SwingUtilities.getRootPane(component);
        if (rootPane == null) {
            if (component instanceof JMenuItem) {
                component = component.getParent();
            }
            if (component instanceof JPopupMenu) {
                component = SwingUtil.getTopLevelPopup((JPopupMenu)component).getInvoker();
            }
            rootPane = SwingUtilities.getRootPane(component);
        }
        return rootPane;
    }

    public static JPopupMenu getTopLevelPopup(JPopupMenu popup) {
        Container parent;
        Component invoker = popup.getInvoker();
        while (invoker instanceof JMenuItem && (parent = invoker.getParent()) instanceof JPopupMenu) {
            invoker = ((JPopupMenu)parent).getInvoker();
        }
        return popup;
    }

    public static RootPaneContainer getRootPaneContainer(Component c) {
        return SwingUtil.getRootPaneContainer(c, true);
    }

    public static RootPaneContainer getRootPaneContainer(Component c, boolean allowInternalFrame) {
        if (c instanceof RootPaneContainer) {
            return (RootPaneContainer)((Object)c);
        }
        JRootPane rootPane = SwingUtil.getRootPane(c);
        if (rootPane == null) {
            return null;
        }
        RootPaneContainer rpc = (RootPaneContainer)((Object)SwingUtilities.getAncestorOfClass(RootPaneContainer.class, rootPane));
        if (allowInternalFrame) {
            return rpc;
        }
        if (rpc == null) {
            return rpc;
        }
        if (rpc instanceof JInternalFrame) {
            return SwingUtil.getRootPaneContainer(((JInternalFrame)rpc).getDesktopPane());
        }
        return rpc;
    }

    public static void setSize(JComponent c, Dimension dim) {
        c.setSize(dim);
        c.setMaximumSize(dim);
        c.setMinimumSize(dim);
        c.setPreferredSize(dim);
    }

    public static void setSize(JComponent c, int width, int height) {
        Dimension dim = new Dimension(width, height);
        SwingUtil.setSize(c, dim);
    }

    public static void setWidth(JComponent c, int width) {
        Dimension dim = c.getPreferredSize();
        SwingUtil.setSize(c, width, dim.height);
    }

    public static void setHeight(JComponent c, int height) {
        Dimension dim = c.getPreferredSize();
        SwingUtil.setSize(c, dim.width, height);
    }

    public static void setSizesToWidest(JComponent c1, JComponent c2) {
        Dimension dim = c1.getPreferredSize();
        if (dim.width < c2.getPreferredSize().width) {
            dim = c2.getPreferredSize();
        }
        c1.setPreferredSize(dim);
        c2.setPreferredSize(dim);
    }

    public static void setSizesToWidest(JComponent[] components) {
        Dimension dim = components[0].getPreferredSize();
        for (int i = 1; i < components.length; ++i) {
            if (dim.width >= components[i].getPreferredSize().width) continue;
            dim = components[i].getPreferredSize();
        }
        for (JComponent component : components) {
            component.setPreferredSize(dim);
            component.setMinimumSize(dim);
        }
    }

    public static void setSizesToWidest(ArrayList<JComponent> components) {
        if (components.size() == 0) {
            return;
        }
        Dimension dim = components.get(0).getPreferredSize();
        for (int i = 1; i < components.size(); ++i) {
            if (dim.width >= components.get((int)i).getPreferredSize().width) continue;
            dim = components.get(i).getPreferredSize();
        }
        for (JComponent component : components) {
            component.setPreferredSize(dim);
            component.setMinimumSize(dim);
        }
    }

    public static void setSizesToTallest(JComponent ... components) {
        int height = 1;
        for (int i = 1; i < components.length; ++i) {
            height = Math.max(height, components[i].getPreferredSize().height);
        }
        for (JComponent component : components) {
            Dimension d = new Dimension(component.getPreferredSize().width, height);
            component.setPreferredSize(d);
            component.setMinimumSize(d);
        }
    }

    public static void setSizesToShortest(JComponent[] components) {
        int height = 100000000;
        for (int i = 1; i < components.length; ++i) {
            height = Math.min(height, components[i].getPreferredSize().height);
        }
        for (JComponent component : components) {
            Dimension d = new Dimension(component.getPreferredSize().width, height);
            component.setPreferredSize(d);
            component.setMaximumSize(d);
        }
    }

    public static void makeButtonRed(JButton button) {
        button.putClientProperty(PROPERTY_COLOR, KEY_COLOR_RED);
    }

    public static void makeButtonBlue(JButton button) {
        button.putClientProperty(PROPERTY_COLOR, KEY_COLOR_BLUE);
    }

    public static void fixSizeToPreferredSize(JComponent component) {
        component.setSize(component.getPreferredSize());
        component.setMaximumSize(component.getPreferredSize());
        component.setMinimumSize(component.getPreferredSize());
    }

    public static void setRenderingHints(Graphics2D g2d) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
    }

    public static Dimension getPreferredSizeOfHtml(String html, boolean width, int prefSize) {
        resizer.setText(html);
        View view = (View)resizer.getClientProperty("html");
        view.setSize(width ? (float)prefSize : 0.0f, width ? 0.0f : (float)prefSize);
        float w = view.getPreferredSpan(0);
        float h = view.getPreferredSpan(1);
        return new Dimension((int)Math.ceil(w), (int)Math.ceil(h));
    }

    public static BufferedImage getButtonImage(String text, boolean coloured) {
        return SwingUtil.getButtonImage(text, coloured, -1);
    }

    public static BufferedImage getButtonImage(String text, boolean coloured, int buttonHeight) {
        JButton button = new JButton();
        button.setText(text);
        if (!coloured) {
            button.setEnabled(false);
        }
        Dimension buttonSize = button.getPreferredSize();
        if (buttonHeight > 0) {
            buttonSize.height = buttonHeight;
        }
        button.setBounds(0, 0, buttonSize.width, buttonSize.height);
        button.setSize(buttonSize);
        BufferedImage result = OS.isOSXRetina() ? new BufferedImage(buttonSize.width * 2, buttonSize.height * 2, 2) : new BufferedImage(buttonSize.width, buttonSize.height, 2);
        Graphics2D g2d = result.createGraphics();
        if (OS.isOSXRetina()) {
            g2d.scale(2.0, 2.0);
        }
        SwingUtilities.paintComponent(g2d, button, panel, button.getBounds());
        g2d.dispose();
        return result;
    }

    public static BufferedImage getComponentImage(JComponent component, int fixedHeight, boolean enabled) {
        component.setEnabled(enabled);
        Dimension buttonSize = component.getPreferredSize();
        if (fixedHeight > 0) {
            buttonSize.height = fixedHeight;
        }
        component.setBounds(0, 0, buttonSize.width, buttonSize.height);
        component.setSize(buttonSize);
        component.validate();
        component.doLayout();
        BufferedImage result = OS.isOSXRetina() ? new BufferedImage(buttonSize.width * 2, buttonSize.height * 2, 2) : new BufferedImage(buttonSize.width, buttonSize.height, 2);
        Graphics2D g2d = result.createGraphics();
        if (OS.isOSXRetina()) {
            g2d.scale(2.0, 2.0);
        }
        SwingUtilities.paintComponent(g2d, component, panel, component.getBounds());
        g2d.dispose();
        return result;
    }

    public static AffineTransform prepareForRetina(Graphics2D g) {
        AffineTransform t = g.getTransform();
        if (OS.isOSXRetina()) {
            g.scale(0.5, 0.5);
        }
        return t;
    }

    public static GraphicsDevice getGraphicsDeviceFor(Component comp) {
        Rectangle bounds = comp.getBounds();
        int x = bounds.x + bounds.width / 2;
        int y = bounds.y + bounds.height / 2;
        System.out.println("[SwingUtil] Getting GraphicsDevice for " + x + "," + y);
        GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        System.out.println("[SwingUtil] " + devices.length + " devices");
        for (GraphicsDevice dev : devices) {
            try {
                GraphicsConfiguration conf = dev.getDefaultConfiguration();
                System.out.println("[SwingUtil] Checking " + conf);
                Rectangle devbounds = SwingUtil.getDeviceBounds(dev, conf);
                System.out.println("[SwingUtil] Bounds " + devbounds);
                if (devbounds.contains(x, y)) {
                    System.out.println("[SwingUtil] Target found");
                    return dev;
                }
                System.out.println("[SwingUtil] Point not inside bounds");
            }
            catch (Exception xx) {
                xx.printStackTrace();
            }
        }
        System.out.println("[SwingUtil] Returning default GraphicsDevice");
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        return env.getDefaultScreenDevice();
    }

    public static Rectangle getDeviceBounds(GraphicsDevice device, GraphicsConfiguration graphicsConfiguration) {
        Rectangle bounds = graphicsConfiguration.getBounds();
        DisplayMode mode = device.getDisplayMode();
        if (mode != null) {
            bounds.width = mode.getWidth();
            bounds.height = mode.getHeight();
        }
        return bounds;
    }

    public static boolean containsComponent(JComponent parent, JComponent child) {
        for (Component c : parent.getComponents()) {
            if (!c.equals(child)) continue;
            return true;
        }
        return false;
    }

    public static int getContentHeight(int componentWidth, String content) {
        JEditorPane dummyEditorPane = new JEditorPane();
        dummyEditorPane.setSize(componentWidth, Short.MAX_VALUE);
        dummyEditorPane.setText(content);
        System.out.println(dummyEditorPane.getPreferredSize().height);
        return dummyEditorPane.getPreferredSize().height;
    }
}

