/*
 * Decompiled with CFR 0.152.
 */
package utils.stream;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.util.Properties;
import java.util.Random;
import utils.stream.GenericParameteriser;

public class StreamParameteriser {
    boolean done = false;
    boolean writing = false;
    int absPos = 0;
    int markerPos = 0;
    byte[] marker;
    int payloadPos = 0;
    byte[] payload;

    public StreamParameteriser(byte[] marker, byte[] payload) {
        this.marker = marker;
        this.payload = payload;
    }

    public void nextBlockToBeTransferred(byte[] dat, int off, int len) {
        if (!this.done) {
            int i;
            int tot = off + len;
            if (!this.writing) {
                for (i = 0; i < tot; ++i) {
                    ++this.absPos;
                    if (dat[i] == this.marker[this.markerPos]) {
                        ++this.markerPos;
                        if (this.markerPos != this.marker.length) continue;
                        System.out.println("[StreamParameteriser] Writing " + this.payload.length + " bytes of data at " + this.absPos + " (marker found at " + (this.absPos - this.marker.length) + ")");
                        this.writing = true;
                        ++i;
                        break;
                    }
                    this.markerPos = 0;
                }
            }
            if (this.writing) {
                while (i < tot) {
                    dat[i] = this.payload[this.payloadPos++];
                    if (this.payloadPos == this.payload.length) {
                        this.done = true;
                        ++i;
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Random r = new Random();
        int prefix = r.nextInt(100000);
        int postfix = r.nextInt(100000);
        StreamParameteriser.test(r, prefix, postfix);
    }

    static void test(Random r, int prefix, int postfix) throws Exception {
        int i;
        System.out.println("Param block will be at " + prefix);
        GenericParameteriser gp = new GenericParameteriser();
        File test = new File("StreamParameteriserTest.deleteme");
        File testSP = new File("StreamParameteriserTest-parameterised.deleteme");
        RandomAccessFile f = new RandomAccessFile(test, "rw");
        for (i = 0; i < prefix; ++i) {
            f.write((byte)r.nextInt());
        }
        f.write(gp.getUnparameterisedBlock(10000));
        for (i = 0; i < postfix; ++i) {
            f.write((byte)r.nextInt());
        }
        f.close();
        Properties props = new Properties();
        props.setProperty("p1", "one");
        props.setProperty("p2", "two");
        props.setProperty("p3", "three or something");
        props.setProperty("p4", "%$^&*U");
        StreamParameteriser sp = gp.newStreamParametiser(props);
        FileOutputStream fout = new FileOutputStream(testSP);
        FileInputStream fin = new FileInputStream(test);
        byte[] dat = new byte[5];
        int n = 0;
        while (n != -1) {
            n = fin.read(dat);
            if (n <= 0) continue;
            sp.nextBlockToBeTransferred(dat, 0, n);
            fout.write(dat, 0, n);
        }
        fin.close();
        fout.close();
        System.out.println(gp.getParameters(testSP));
    }
}

