/*
 * Decompiled with CFR 0.152.
 */
package utils.stream;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class SSLHelper {
    static boolean SSL_ACCEPTING_ALL_CERTS = false;
    static SSLContext ssc;
    private static HostnameVerifier trustAllHosts;
    private static TrustManager[] trustAllCerts;

    public static void setupSslAndHttpsToAcceptAllCerts() throws Exception {
        SSLHelper.setupSslAndHttpsToAcceptAllCerts(false);
    }

    public static void setupSslAndHttpsToAcceptAllCerts(boolean applyToAllHttps) throws Exception {
        if (!SSL_ACCEPTING_ALL_CERTS) {
            ssc = SSLContext.getInstance("SSL");
            ssc.init(null, trustAllCerts, new SecureRandom());
            if (applyToAllHttps) {
                HttpsURLConnection.setDefaultSSLSocketFactory(ssc.getSocketFactory());
                HttpsURLConnection.setDefaultHostnameVerifier(SSLHelper.getTrustAllHostnameVerifier());
            }
            SSL_ACCEPTING_ALL_CERTS = true;
        }
    }

    public static HttpsURLConnection createHttpsURLConnection(URL httpsUrl, boolean trustAnyHosts) throws IOException {
        HttpsURLConnection conn = (HttpsURLConnection)httpsUrl.openConnection();
        if (trustAnyHosts) {
            conn.setHostnameVerifier(trustAllHosts);
        }
        return conn;
    }

    public static Socket createSSLSocket(String hostname, int port) throws IOException {
        SSLSocket sock = (SSLSocket)ssc.getSocketFactory().createSocket(hostname, port);
        sock.setNeedClientAuth(false);
        String[] suites = sock.getSupportedCipherSuites();
        sock.setEnabledCipherSuites(suites);
        return sock;
    }

    public static ServerSocket createSSLServerSocket(int port) throws IOException {
        SSLServerSocket ssock = (SSLServerSocket)ssc.getServerSocketFactory().createServerSocket(port);
        ssock.setNeedClientAuth(false);
        String[] suites = ssock.getSupportedCipherSuites();
        ssock.setEnabledCipherSuites(suites);
        return ssock;
    }

    public static HostnameVerifier getTrustAllHostnameVerifier() {
        return trustAllHosts;
    }

    public static TrustManager[] getTrustAllCertsTrustManagerArray() {
        return trustAllCerts;
    }

    public static TrustManager getTrustAllCertsTrustManager() {
        return trustAllCerts[0];
    }

    static {
        trustAllHosts = new HostnameVerifier(){

            @Override
            public boolean verify(String rserver, SSLSession sses) {
                if (!rserver.equals(sses.getPeerHost())) {
                    // empty if block
                }
                return true;
            }
        };
        trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
    }
}

