/*
 * Decompiled with CFR 0.152.
 */
package utils.stream;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import utils.stream.StreamUtils;

public class MappedFile {
    private static final boolean DEBUG = false;
    public static final int SIZE_HIGH_PERFORMANCE = 500000;
    public static final int SIZE_MEM_EFFICIENT = 50000;
    int LOCK_COUNT = 2;
    static final int W = 0;
    static final int R = 10;
    static final int WALIVE = 20;
    static final int RALIVE = 30;
    String id;
    File raffile;
    RandomAccessFile raf;
    FileChannel chan;
    MappedByteBuffer buf;
    int DATAPOS = 40;
    int DATALEN = this.DATAPOS + 50000;
    int MAXWRITE = this.DATALEN - this.DATAPOS;
    boolean writer;
    FileLock WN;
    FileLock RN;
    FileLock IAMALIVE;
    boolean highPerformance = false;
    byte[] data;
    int N = 0;

    public void setHighPerformance(boolean b) {
        this.highPerformance = b;
    }

    public MappedFile(File file, int size, boolean writer, long timeout) throws IOException, InterruptedException {
        this.writer = writer;
        long fail = System.currentTimeMillis() + timeout;
        this.MAXWRITE = size;
        this.DATALEN = this.MAXWRITE + this.DATAPOS + 8;
        this.raffile = file;
        this.raf = new RandomAccessFile(file, "rw");
        this.raf.setLength(this.DATALEN);
        if (!writer) {
            this.data = new byte[this.MAXWRITE];
        }
        this.chan = this.raf.getChannel();
        this.buf = this.chan.map(FileChannel.MapMode.READ_WRITE, 0L, this.raf.length());
        if (!this.buf.isLoaded()) {
            System.out.println("Loading");
            this.buf.load();
        }
        if (writer) {
            this.id = "[Writer] ";
            this.WN = this.getLock(0, this.N);
            this.IAMALIVE = this.getLock(20, 0);
            while (!this.isLocked(30)) {
                Thread.sleep(100L);
                if (System.currentTimeMillis() <= fail) continue;
                throw new IOException("Timed out");
            }
            System.out.println("[MappedFile] connected (writer)");
        } else {
            this.id = "[Reader] ";
            this.RN = this.getLock(10, this.N + 1);
            this.IAMALIVE = this.getLock(30, 0);
            while (!this.isLocked(20)) {
                Thread.sleep(100L);
                if (System.currentTimeMillis() <= fail) continue;
                throw new IOException("Timed out");
            }
            System.out.println("[MappedFile] connected (reader)");
        }
    }

    public void close() {
        try {
            this.IAMALIVE.release();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.raf.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.raffile.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    FileLock getLock(int SECTION, int N) throws IOException {
        long rCount = 0L;
        if (!this.highPerformance) {
            rCount = 200L;
        }
        while (true) {
            try {
                FileLock lock = this.chan.tryLock(SECTION + N % this.LOCK_COUNT, 1L, false);
                if (lock != null) {
                    return lock;
                }
                throw new IOException("ourdeadlock");
            }
            catch (IOException x) {
                if ((x.getMessage() + "").indexOf("deadlock") != -1) {
                    try {
                        if (++rCount < 200L) {
                            Thread.sleep(1L);
                            continue;
                        }
                        if (rCount < 400L) {
                            Thread.sleep(10L);
                            continue;
                        }
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException xx) {
                        xx.printStackTrace();
                    }
                    continue;
                }
                x.printStackTrace();
                throw x;
            }
            break;
        }
    }

    boolean isLocked(int SECTION) throws IOException {
        FileLock fl = this.chan.tryLock(SECTION, 1L, false);
        if (fl == null) {
            return true;
        }
        fl.release();
        return false;
    }

    public byte[] readBlock() throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.readBlock(bout);
        return bout.toByteArray();
    }

    public void readBlock(OutputStream out) throws IOException {
        if (!this.isLocked(20)) {
            throw new IOException("MappedFile disconnected");
        }
        int read = 0;
        int rem = 0;
        boolean tot = false;
        boolean done = false;
        boolean first = true;
        while (!done) {
            FileLock WN = this.getLock(0, this.N);
            this.buf.position(this.DATAPOS);
            if (first) {
                rem = this.buf.getInt();
                first = false;
            }
            if (rem > this.MAXWRITE) {
                this.buf.get(this.data, 0, this.MAXWRITE);
                read = this.MAXWRITE;
                rem -= read;
            } else {
                this.buf.get(this.data, 0, rem);
                read = rem;
                rem -= read;
                done = true;
            }
            WN.release();
            ++this.N;
            FileLock RNold = this.RN;
            this.RN = this.getLock(10, this.N + 1);
            RNold.release();
            out.write(this.data, 0, read);
        }
    }

    public void writeBlock(byte[] dat) throws IOException {
        this.writeBlock(dat, 0, dat.length);
    }

    public void writeBlock(byte[] dat, int off, int len) throws IOException {
        if (!this.isLocked(30)) {
            throw new IOException("MappedFile disconnected");
        }
        boolean done = false;
        boolean first = true;
        System.out.println("[MappedFile] in writeBlock()");
        while (!done) {
            FileLock RN = this.getLock(10, this.N);
            this.buf.position(this.DATAPOS);
            if (first) {
                this.buf.putInt(dat.length);
                first = false;
            }
            if (len > this.MAXWRITE) {
                this.buf.put(dat, off, this.MAXWRITE);
                off += this.MAXWRITE;
                len -= this.MAXWRITE;
            } else {
                this.buf.put(dat, off, len);
                done = true;
            }
            RN.release();
            ++this.N;
            FileLock WNold = this.WN;
            this.WN = this.getLock(0, this.N);
            WNold.release();
        }
    }

    public static void main(String[] args) throws Exception {
        int MFSIZ = 500000;
        int SIZ = 30000000;
        if (args[0].equals("writer")) {
            MappedFile mf = new MappedFile(new File("mappedfile"), MFSIZ, true, 20000L);
            ByteArrayOutputStream bout = new ByteArrayOutputStream(SIZ);
            for (int i = 0; i < SIZ / 4; ++i) {
                StreamUtils.writeInt(bout, i);
            }
            byte[] bb = bout.toByteArray();
            mf.writeBlock(bb);
            mf.writeBlock(bb);
        } else {
            MappedFile mf = new MappedFile(new File("mappedfile"), MFSIZ, false, 20000L);
            ByteArrayOutputStream bout = new ByteArrayOutputStream(SIZ);
            mf.readBlock(bout);
            long T = System.currentTimeMillis();
            mf.readBlock(bout);
            T = System.currentTimeMillis() - T;
            System.out.println(T + "ms");
            double MB = (double)SIZ / 1000000.0;
            double sec = (double)T / 1000.0;
            System.out.println(MB / sec + "MB/sec");
        }
        Thread.sleep(5000L);
    }
}

