/*
 * Decompiled with CFR 0.152.
 */
package utils.stream;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import utils.stream.MappedFile;

public class MappedChannel {
    MappedFile in;
    MappedFile out;

    private MappedChannel(File dir, String fname, boolean server, long connectTimeout) throws IOException {
        this(new File(dir, fname + "-stoc"), new File(dir, fname + "-ctos"), server, connectTimeout);
    }

    private MappedChannel(File serverFile, File clientFile, boolean server, long connectTimeout) throws IOException {
        System.out.println("[MappedChannel] ServerFile = " + serverFile.getAbsolutePath());
        System.out.println("[MappedChannel] ClientFile = " + clientFile.getAbsolutePath());
        System.out.println("[MappedChannel] isServer = " + server);
        try {
            this.out = new MappedFile(serverFile, 50000, server, connectTimeout);
        }
        catch (InterruptedException x) {
            throw new IOException("Interrupted");
        }
        try {
            this.in = new MappedFile(clientFile, 50000, !server, connectTimeout);
        }
        catch (InterruptedException x) {
            throw new IOException("Interrupted");
        }
        if (!server) {
            MappedFile tmp = this.out;
            this.out = this.in;
            this.in = tmp;
        }
    }

    public byte[] readBlock() throws IOException {
        return this.in.readBlock();
    }

    public void writeBlock(byte[] dat) throws IOException {
        this.out.writeBlock(dat, 0, dat.length);
    }

    public static MappedChannel openAsServer(File dir, String name, long timeout) throws IOException {
        return new MappedChannel(dir, name, true, timeout);
    }

    public static MappedChannel openAsClient(File dir, String name, long timeout) throws IOException {
        return new MappedChannel(dir, name, false, timeout);
    }

    public static MappedChannel openAsServer(File serverFile, File clientFile, long timeout) throws IOException {
        return new MappedChannel(serverFile, clientFile, true, timeout);
    }

    public static MappedChannel openAsClient(File serverFile, File clientFile, long timeout) throws IOException {
        return new MappedChannel(serverFile, clientFile, false, timeout);
    }

    public void close() {
        this.in.close();
        this.out.close();
    }

    public static void main(String[] args) throws Exception {
        if (args[0].equals("L1")) {
            new RandomAccessFile("L1", "rw").getChannel().lock();
            Thread.sleep(10000L);
            new RandomAccessFile("L2", "rw").getChannel().lock();
            System.exit(0);
        } else if (args[0].equals("L2")) {
            new RandomAccessFile("L2", "rw").getChannel().lock();
            Thread.sleep(15000L);
            RandomAccessFile raf = new RandomAccessFile("L1", "rw");
            FileChannel ch = raf.getChannel();
            System.out.println("Expect CPU usage now...");
            long rCount = 0L;
            while (true) {
                try {
                    while (true) {
                        ch.lock();
                    }
                }
                catch (IOException x) {
                    if (++rCount < 200L) {
                        Thread.sleep(1L);
                        continue;
                    }
                    if (rCount < 400L) {
                        Thread.sleep(10L);
                        continue;
                    }
                    Thread.sleep(100L);
                    continue;
                }
                break;
            }
        }
        MappedChannel mc = new MappedChannel(new File("."), "mappedtest", args[0].equals("writer"), 30000L);
        new TestWriter(mc).start();
        new TestReader(mc).start();
    }

    static class TestReader
    extends Thread {
        MappedChannel mc;

        public TestReader(MappedChannel mc) {
            this.mc = mc;
        }

        @Override
        public void run() {
            long T = System.currentTimeMillis();
            double tot = 0.0;
            try {
                while (true) {
                    byte[] dat = this.mc.readBlock();
                    tot += (double)dat.length;
                }
            }
            catch (Exception x) {
                x.printStackTrace();
                double sec = System.currentTimeMillis() - T;
                System.out.println("Data rate: " + (tot /= 1024.0) / (sec /= 1000.0) + "k/sec");
                System.exit(0);
                return;
            }
        }
    }

    static class TestWriter
    extends Thread {
        MappedChannel mc;

        public TestWriter(MappedChannel mc) {
            this.mc = mc;
        }

        @Override
        public void run() {
            try {
                long T = System.currentTimeMillis() + 5000L;
                while (System.currentTimeMillis() < T) {
                    byte[] dat = new byte[(int)(Math.random() * 100000.0)];
                    this.mc.writeBlock(dat);
                }
                System.out.println("Finished writing");
                Thread.sleep(5000L);
                this.mc.close();
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }
}

