/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools.collections;

import java.util.Iterator;
import java.util.LinkedList;

public class FixedSizeLinkedList<T>
implements Iterable<T> {
    private LinkedList<T> list = new LinkedList();
    private int maxSize;

    public FixedSizeLinkedList(int maxSize) {
        this.maxSize = maxSize;
    }

    public void put(T t) {
        this.list.add(t);
        if (this.list.size() > this.maxSize) {
            this.list.removeFirst();
        }
    }

    public T pop() {
        if (this.list.size() == 0) {
            return null;
        }
        return this.list.removeFirst();
    }

    public int size() {
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public T peek() {
        return this.list.peek();
    }

    public T peekLast() {
        if (this.isEmpty()) {
            return null;
        }
        return this.list.getLast();
    }

    public void clear() {
        this.list.clear();
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    public LinkedList<T> getList() {
        return this.list;
    }
}

