/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools.clock;

public class TimingClock
extends Thread {
    private static final Object LOCK = new Object();
    private static TimingClock INSTANCE;
    private static long unchangingT;
    private static long driftingT;
    private static long drift;
    private static long FREQ;
    private static long FREQdiv2;
    private boolean die = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startup() {
        if (INSTANCE == null) {
            Object object = LOCK;
            synchronized (object) {
                INSTANCE = new TimingClock();
                INSTANCE.start();
            }
        }
    }

    private TimingClock() {
        super("TimingClock");
        this.setDaemon(true);
    }

    public static long currentTimeMillis() {
        TimingClock.startup();
        return TimingClock.checkAndUpdateTime(FREQdiv2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long checkAndUpdateTime(long assumedWait) {
        Object object = LOCK;
        synchronized (object) {
            long T = System.currentTimeMillis();
            if (T - driftingT > 10000L || T < driftingT) {
                System.out.println("*******************************************");
                System.out.println("* TimingClock: System Clock Changed - " + (T - driftingT) + "ms");
                System.out.println("*");
                System.out.println("* WARNING: It appears that your server is losing time. ");
                System.out.println("* Time loss > 10000ms will cause session instability and dropped connections.");
                System.out.println("*******************************************");
                drift = T - (unchangingT += assumedWait);
                driftingT = T;
            } else {
                driftingT = T;
                unchangingT = driftingT - drift;
            }
            return T - drift;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.die) {
            Object object = LOCK;
            synchronized (object) {
                try {
                    LOCK.wait(FREQ);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            TimingClock.checkAndUpdateTime(FREQ);
        }
    }

    public static void main(String[] args) throws Exception {
        long tSafe;
        Object tmp = new Object();
        long pSafe = tSafe = TimingClock.currentTimeMillis();
        while (true) {
            tSafe = TimingClock.currentTimeMillis();
            System.out.println(tSafe % 1000000L + " (+" + (tSafe - pSafe) + ") vs " + System.currentTimeMillis() % 1000000L + ", uc=" + unchangingT + ", dr=" + driftingT + ", drift=" + drift);
            System.out.println("Into sleep...");
            Thread.sleep(1000L);
            System.out.println("...out of Sleep");
            pSafe = tSafe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void die() {
        if (INSTANCE != null) {
            TimingClock.INSTANCE.die = true;
            Object object = LOCK;
            synchronized (object) {
                LOCK.notify();
            }
        }
    }

    static {
        unchangingT = System.currentTimeMillis();
        driftingT = System.currentTimeMillis();
        drift = 0L;
        FREQ = 100L;
        FREQdiv2 = FREQ / 2L;
    }
}

