/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import utils.progtools.CacheListener;

public class Cache<K, V> {
    private static final ArrayList<WeakReference<Cache>> allCacheList = new ArrayList();
    private CacheListener<K, V> universalCacheListener;
    private final Object LOCK = new Object();
    private HashMap<K, LinkedEntry> map = new HashMap();
    private LinkedCacheList list = new LinkedCacheList();
    private int MAX_SIZE = 50;
    private double hits = 0.0;
    private double misses = 0.0;
    private String id;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpCacheStats() {
        ArrayList<WeakReference<Cache>> arrayList = allCacheList;
        synchronized (arrayList) {
            ArrayList<WeakReference<Cache>> temp = new ArrayList<WeakReference<Cache>>(allCacheList);
            for (WeakReference<Cache> cacheReference : temp) {
                Cache cache = (Cache)cacheReference.get();
                if (cache == null) {
                    allCacheList.remove(cacheReference);
                    continue;
                }
                double hitRate = cache.getHitRatePercent();
                if (hitRate != -1.0) {
                    System.out.println("[Cache] Cache " + cache.id + ": " + cache.map.size() + " / " + cache.MAX_SIZE + " [" + (int)cache.getHitRatePercent() + "%]");
                    continue;
                }
                System.out.println("[Cache] Cache " + cache.id + ": " + cache.map.size() + " / " + cache.MAX_SIZE);
            }
        }
    }

    public Cache(String id, int max_size) {
        this(id);
        this.MAX_SIZE = max_size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache(String id) {
        this.id = id;
        ArrayList<WeakReference<Cache>> arrayList = allCacheList;
        synchronized (arrayList) {
            allCacheList.add(new WeakReference<Cache>(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<K> getKeySet() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.map.keySet();
        }
    }

    public double getTotalRequests() {
        return this.hits + this.misses;
    }

    public double getTotalHits() {
        return this.hits;
    }

    public double getTotalMisses() {
        return this.misses;
    }

    public double getHitRatePercent() {
        if (this.hits + this.misses == 0.0) {
            return -1.0;
        }
        return 100.0 * (this.hits / (this.hits + this.misses));
    }

    public static int calculatePreferredSize(long sizeOfItem, long memoryToUse) {
        return (int)(memoryToUse / sizeOfItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimAndSetMaxSize(int max_size) {
        Object object = this.LOCK;
        synchronized (object) {
            this.MAX_SIZE = max_size;
            while (this.map.size() > this.MAX_SIZE) {
                LinkedEntry rm = this.list.removeFirst();
                if (rm == null) continue;
                rm.next = null;
                rm.prev = null;
                LinkedEntry remove = this.map.remove(rm.valueKey);
                if (remove == null || this.universalCacheListener == null) continue;
                this.universalCacheListener.removedFromCache(remove.valueKey, remove.valueValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(K key) {
        Object object = this.LOCK;
        synchronized (object) {
            return this.map.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.LOCK;
        synchronized (object) {
            this.map = new HashMap();
            this.list = new LinkedCacheList();
        }
    }

    public void setUniversalCacheListener(CacheListener<K, V> cacheListener) {
        this.universalCacheListener = cacheListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int maxSize() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.MAX_SIZE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.map.size();
        }
    }

    public void addToCache(K key, V value) {
        this.addToCache(key, value, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToCache(K key, V value, CacheListener<K, V> listener) {
        if (key == null) {
            return;
        }
        Object object = this.LOCK;
        synchronized (object) {
            LinkedEntry e = this.map.get(key);
            if (e != null) {
                e.valueValue = value;
            } else {
                LinkedEntry rm;
                this.map.put(key, this.list.add(key, value));
                if (this.map.size() > this.MAX_SIZE && (rm = this.list.removeFirst()) != null) {
                    rm.next = null;
                    rm.prev = null;
                    this.map.remove(rm.valueKey);
                    if (listener != null) {
                        listener.removedFromCache(rm.valueKey, rm.valueValue);
                    }
                    if (this.universalCacheListener != null) {
                        this.universalCacheListener.removedFromCache(rm.valueKey, rm.valueValue);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V removeFirstFromCache() {
        Object object = this.LOCK;
        synchronized (object) {
            LinkedEntry first = this.list.removeFirst();
            this.map.remove(first.valueKey);
            return first.valueValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V removeFromCache(K key) {
        if (key == null) {
            return null;
        }
        Object object = this.LOCK;
        synchronized (object) {
            LinkedEntry e = this.map.remove(key);
            if (e != null) {
                if (this.universalCacheListener != null) {
                    this.universalCacheListener.removedFromCache(e.valueKey, e.valueValue);
                }
                LinkedEntry prev = e.prev;
                LinkedEntry next = e.next;
                if (prev == null) {
                    this.list.removeFirst();
                } else if (next == null) {
                    this.list.end = prev;
                    prev.next = null;
                } else {
                    prev.next = next;
                    next.prev = prev;
                }
                return e.valueValue;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getFromCache(K key) {
        if (key == null) {
            return null;
        }
        Object object = this.LOCK;
        synchronized (object) {
            LinkedEntry e = this.map.get(key);
            if (e == null) {
                this.misses += 1.0;
                return null;
            }
            this.hits += 1.0;
            this.list.moveToFront(e);
            return e.valueValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getAllCacheObjects() {
        Object object = this.LOCK;
        synchronized (object) {
            ArrayList result = new ArrayList();
            for (LinkedEntry value : this.map.values()) {
                result.add(value.valueValue);
            }
            return result.toArray();
        }
    }

    class LinkedCacheList {
        LinkedEntry start;
        LinkedEntry end;

        LinkedCacheList() {
        }

        public LinkedEntry add(K key, V value) {
            LinkedEntry e = new LinkedEntry();
            e.valueKey = key;
            e.valueValue = value;
            e.next = null;
            if (this.end == null) {
                this.start = e;
                this.end = e;
                e.prev = null;
            } else {
                this.end.next = e;
                e.prev = this.end;
                this.end = e;
            }
            return e;
        }

        public LinkedEntry removeFirst() {
            if (this.start != null) {
                if (this.start == this.end) {
                    this.end = null;
                }
                LinkedEntry ret = this.start;
                this.start = this.start.next;
                if (this.start != null) {
                    this.start.prev = null;
                }
                return ret;
            }
            return null;
        }

        public void moveToFront(LinkedEntry e) {
            if (e != this.end) {
                if (e == this.start) {
                    this.start = e.next;
                    this.start.prev = null;
                } else {
                    e.prev.next = e.next;
                    e.next.prev = e.prev;
                }
                this.end.next = e;
                e.prev = this.end;
                e.next = null;
                this.end = e;
            }
        }
    }

    class LinkedEntry {
        K valueKey;
        V valueValue;
        LinkedEntry prev;
        LinkedEntry next;

        LinkedEntry() {
        }

        public String toString() {
            return "" + this.valueKey;
        }
    }
}

