/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.updater;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import jwrapper.jwutils.JWSystem;
import jwrapper.updater.JWLaunchProperties;
import jwrapper.updater.LaunchFile;
import utils.stream.StreamUtils;

public class JWApp {
    public String name;
    public byte[] logoICO;
    public int pngIndex;
    public int pngLen;
    public String mainClass;
    public ArrayList<String> args = new ArrayList();
    public boolean userAccessible;

    public byte[] getLogoICO() {
        return this.logoICO;
    }

    public byte[] getLogoPNG() {
        byte[] dat = new byte[this.pngLen];
        System.arraycopy(this.logoICO, this.pngIndex, dat, 0, this.pngLen);
        return dat;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("App (user:" + this.userAccessible + ") \"" + this.name + "\" = " + this.mainClass);
        for (int i = 0; i < this.args.size(); ++i) {
            sb.append(" " + this.args.get(i));
        }
        sb.append(" [any further args]");
        return sb.toString();
    }

    public static String normaliseName(String app) {
        char[] tmp = app.toCharArray();
        for (int i = 0; i < tmp.length; ++i) {
            if (Character.isLetterOrDigit(tmp[i])) continue;
            tmp[i] = 95;
        }
        return new String(tmp);
    }

    public static File getJWAppsFolder(File master) {
        return new File(master, "JWApps");
    }

    public File getICOFile() {
        File app = JWSystem.getAppFolder().getParentFile();
        File jwdirs = new File(app, "JWApps");
        if (!jwdirs.exists()) {
            jwdirs.mkdirs();
        }
        return new File(jwdirs, this.getFilesystemName() + "ICO.ico");
    }

    public String getFilesystemName() {
        return JWApp.normaliseName(this.name);
    }

    public String getUserVisibleName() {
        return this.name;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public File save(File folder) throws IOException {
        File target = new File(folder, "JWAppSpec-" + JWApp.normaliseName(this.name));
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(target));
        StreamUtils.writeInt(out, 0);
        StreamUtils.writeStringUTF8(out, this.name);
        StreamUtils.writeStringUTF8(out, this.mainClass);
        StreamUtils.writeBoolean(out, this.userAccessible);
        StreamUtils.writeInt(out, this.args.size());
        for (int i = 0; i < this.args.size(); ++i) {
            StreamUtils.writeStringUTF8(out, this.args.get(i));
        }
        if (this.logoICO == null) {
            StreamUtils.writeBytes(out, new byte[0]);
        } else {
            StreamUtils.writeBytes(out, this.logoICO);
        }
        StreamUtils.writeInt(out, this.pngIndex);
        StreamUtils.writeInt(out, this.pngLen);
        ((OutputStream)out).flush();
        ((OutputStream)out).close();
        return target;
    }

    private static JWApp load(File file) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        JWApp tmp = new JWApp();
        StreamUtils.readInt(in);
        tmp.name = StreamUtils.readStringUTF8(in);
        tmp.mainClass = StreamUtils.readStringUTF8(in);
        tmp.userAccessible = StreamUtils.readBoolean(in);
        int A = StreamUtils.readInt(in);
        for (int i = 0; i < A; ++i) {
            tmp.args.add(StreamUtils.readStringUTF8(in));
        }
        tmp.logoICO = StreamUtils.readNBytes(in, 10000000);
        tmp.pngIndex = StreamUtils.readInt(in);
        tmp.pngLen = StreamUtils.readInt(in);
        ((InputStream)in).close();
        return tmp;
    }

    public static JWApp getMyVirtualApp() throws IOException {
        return JWApp.load(JWSystem.getAppFolder(), JWLaunchProperties.getProperty("gu_virt_app"));
    }

    public static JWApp load(File folder, String name) throws IOException {
        return JWApp.load(new File(folder, "JWAppSpec-" + JWApp.normaliseName(name)));
    }

    public static JWApp getJWApp(File appBundleFolder, String name) throws IOException {
        return JWApp.load(appBundleFolder, name);
    }

    public static JWApp[] getAllJWApps(File appBundleFolder, boolean userAccessibleOnly) throws IOException {
        ArrayList<File> apps = LaunchFile.getFilesStartingWith(appBundleFolder, "JWAppSpec-", false);
        ArrayList<JWApp> tmp = new ArrayList<JWApp>();
        for (int i = 0; i < apps.size(); ++i) {
            JWApp jwapp = JWApp.load(apps.get(i));
            if (userAccessibleOnly) {
                if (!jwapp.userAccessible) continue;
                tmp.add(jwapp);
                continue;
            }
            tmp.add(jwapp);
        }
        JWApp[] all = new JWApp[tmp.size()];
        tmp.toArray(all);
        return all;
    }

    public static JWApp getFirstJWApp(File appFolder, boolean userAccessibleOnly) throws IOException {
        return JWApp.getAllJWApps(appFolder, userAccessibleOnly)[0];
    }
}

