/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.ui;

import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jwrapper.jwutils.JWSystemUI;
import jwrapper.ui.CanvasPanel;
import jwrapper.ui.JWLanguage;
import utils.swing.customlaf.SHBorderFactory;

public class JWLanguageChooserFrame {
    private JDialog dialog;
    private Translation[] translatedLanguageStrings;
    private ImageIcon logo;
    private static final int outerPadding = 30;
    private static final int innerPadding = 5;
    private static LightGrayFilter filter = new LightGrayFilter(true, 40);
    private int returnIndex = -1;

    public JWLanguageChooserFrame(ImageIcon logo, String[] supported) throws IOException {
        this.logo = logo;
        if (supported == null) {
            supported = new String[]{"en", "de", "es", "fr", "it", "nl", "pt", "sv"};
        }
        this.loadTranslations(supported);
        this.initFrame();
    }

    public String getSelectedLanguageCountryCode() {
        if (this.returnIndex == -1) {
            return null;
        }
        return this.translatedLanguageStrings[this.returnIndex].countryCode;
    }

    private void loadTranslations(String[] supported) throws IOException {
        ArrayList<Translation> translations = new ArrayList<Translation>();
        for (int i = 0; i < supported.length; ++i) {
            String key = ("LANGUAGE_" + supported[i]).toUpperCase();
            if (!JWLanguage.containsTranslationFor(key)) continue;
            Translation t = new Translation();
            t.countryCode = supported[i];
            t.translation = JWLanguage.getString(key);
            translations.add(t);
        }
        this.translatedLanguageStrings = new Translation[translations.size()];
        translations.toArray(this.translatedLanguageStrings);
    }

    private void closeFrame() {
        this.dialog.setVisible(false);
    }

    private void initFrame() throws IOException {
        int frameWidth = 500;
        int frameHeight = 550;
        this.dialog = new JDialog((Frame)null, true);
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.setUndecorated(true);
        this.dialog.setSize(frameWidth, frameHeight);
        this.dialog.setLocationRelativeTo(null);
        CanvasPanel contentPanel = new CanvasPanel();
        contentPanel.setBorder(SHBorderFactory.createEmptyBorder(30, 30, 30, 30));
        contentPanel.setLayout(new BorderLayout(0, 0));
        contentPanel.add("North", new JLabel(this.logo));
        JPanel languagePanel = new JPanel();
        languagePanel.setOpaque(false);
        languagePanel.setLayout(new GridLayout(1, 1));
        final JList<Translation> languageList = new JList<Translation>(this.translatedLanguageStrings);
        languageList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    JWLanguageChooserFrame.this.returnIndex = languageList.getSelectedIndex();
                    JWLanguageChooserFrame.this.closeFrame();
                }
            }
        });
        languageList.validate();
        JScrollPane pane = new JScrollPane(languageList);
        languagePanel.add(pane);
        int requiredWidth = languageList.getPreferredSize().width;
        int padding = (frameWidth - requiredWidth - 60) / 2 - 20;
        languagePanel.setBorder(SHBorderFactory.createEmptyBorder(30, padding, 30, padding));
        contentPanel.add("Center", languagePanel);
        JPanel panel = new JPanel(new FlowLayout(1));
        panel.setOpaque(false);
        InputStream fin = this.getClass().getResourceAsStream("next.png");
        BufferedImage enabledImage = ImageIO.read(fin);
        ImageIcon enabledIcon = new ImageIcon(enabledImage);
        ImageIcon disabledIcon = JWLanguageChooserFrame.getDisabledVersion(enabledIcon);
        final JLabel button = new JLabel(enabledIcon);
        button.setDisabledIcon(disabledIcon);
        button.setBorder(null);
        button.setSize(100, 60);
        button.setMaximumSize(button.getSize());
        button.setEnabled(false);
        button.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (button.isEnabled()) {
                    JWLanguageChooserFrame.this.closeFrame();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (button.isEnabled()) {
                    button.setCursor(Cursor.getPredefinedCursor(12));
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (button.isEnabled()) {
                    button.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
        panel.add(button);
        contentPanel.add("South", panel);
        this.dialog.getContentPane().add(contentPanel);
        languageList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                JWLanguageChooserFrame.this.returnIndex = languageList.getSelectedIndex();
                if (languageList.getSelectedIndex() >= 0) {
                    button.setEnabled(true);
                } else {
                    button.setEnabled(false);
                }
                button.repaint();
            }
        });
        CloseKeyListener closeKeyListener = new CloseKeyListener();
        this.dialog.addKeyListener(closeKeyListener);
        contentPanel.addKeyListener(closeKeyListener);
        languageList.addKeyListener(closeKeyListener);
        this.dialog.setVisible(true);
    }

    private static ImageIcon getDisabledVersion(ImageIcon icon) {
        Image image = icon.getImage();
        Image grayImage = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), filter));
        icon = new ImageIcon(grayImage);
        return icon;
    }

    public static String chooseLanguage(String[] supported) throws IOException {
        ImageIcon icon = null;
        try {
            BufferedImage img = ImageIO.read(new ByteArrayInputStream(JWSystemUI.getAppBundleLogoPNG()));
            icon = new ImageIcon(img);
        }
        catch (Exception img) {
            // empty catch block
        }
        JWLanguageChooserFrame jwLanguageChooserFrame = new JWLanguageChooserFrame(icon, supported);
        return jwLanguageChooserFrame.getSelectedLanguageCountryCode();
    }

    public static void main(String[] args) throws IOException {
        BufferedImage img = ImageIO.read(new File("../PaidMedia/SimpleHelp/Logos/New/logo/green/sh_256.png"));
        ImageIcon icon = new ImageIcon(img);
        JWLanguageChooserFrame jwLanguageChooserFrame = new JWLanguageChooserFrame(icon, null);
        System.out.println("RESULT = " + jwLanguageChooserFrame.getSelectedLanguageCountryCode());
    }

    class CloseKeyListener
    extends KeyAdapter {
        CloseKeyListener() {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 27) {
                JWLanguageChooserFrame.this.returnIndex = -1;
                JWLanguageChooserFrame.this.closeFrame();
            } else if (e.getKeyCode() == 10) {
                JWLanguageChooserFrame.this.closeFrame();
            }
        }
    }

    static class LightGrayFilter
    extends RGBImageFilter {
        private boolean brighter;
        private int percent;

        public LightGrayFilter(boolean b, int p) {
            this.brighter = b;
            this.percent = p;
            this.canFilterIndexColorModel = true;
        }

        @Override
        public int filterRGB(int x, int y, int rgb) {
            int gray = (int)((0.9 * (double)(rgb >> 16 & 0xFF) + 0.9 * (double)(rgb >> 8 & 0xFF) + 0.81 * (double)(rgb & 0xFF)) / 3.0);
            gray = this.brighter ? 255 - (255 - gray) * (100 - this.percent) / 100 : gray * (100 - this.percent) / 100;
            if (gray < 0) {
                gray = 0;
            }
            if (gray > 255) {
                gray = 255;
            }
            return rgb & 0xFF000000 | gray << 16 | gray << 8 | gray << 0;
        }
    }

    class Translation {
        String countryCode;
        String translation;

        Translation() {
        }

        public String toString() {
            return this.translation;
        }
    }
}

