/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.logging;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import jwrapper.logging.ProcessResult;
import utils.files.FileUtil;
import utils.string.CharStack;

public class ProcessOutputUtil {
    public static final String END_TOKEN = "<<<<END>>>>";
    private PrintStream outputStream;
    private String prefix;

    public ProcessOutputUtil(String prefix, PrintStream outputStream) {
        this.outputStream = outputStream;
        this.prefix = prefix;
    }

    public ProcessOutputUtil(String prefix, File targetFile) throws FileNotFoundException {
        this(prefix, new PrintStream(new FileOutputStream(targetFile)));
    }

    public PrintStream getPrintStream() {
        return this.outputStream;
    }

    public void close() {
        this.outputStream.println(END_TOKEN);
        this.outputStream.flush();
        this.outputStream.close();
    }

    public static String getStacktrace(Throwable t) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(os);
        t.printStackTrace(ps);
        return os.toString();
    }

    public void logMessage(String message) {
        if (message == null) {
            message = "";
        }
        this.outputStream.println("<<<<LOGINFO=\"" + message.trim() + "\">>>>");
        this.outputStream.flush();
        System.out.println("[" + this.prefix + "] " + message);
    }

    public void startLogMessage() {
        this.outputStream.println("<<<<LOGINFO=\"");
    }

    public void endLogMessage() {
        this.outputStream.println("\">>>>");
    }

    public void logError(String error) {
        if (error == null) {
            error = "";
        }
        this.outputStream.println("<<<<LOGERROR=\"" + error.trim() + "\">>>>");
        this.outputStream.flush();
        System.out.println("[" + this.prefix + "] " + error.trim());
    }

    public void writeSuccess(boolean success) {
        this.outputStream.println("<<<<SUCCESS=\"" + success + "\">>>>");
        this.outputStream.flush();
        System.out.println("[" + this.prefix + "] SUCCESS=" + success);
    }

    public void writeProcessResult(String source, int code) {
        long time = System.currentTimeMillis();
        this.outputStream.println("<<<<PROCESSRESULT=\"" + time + "," + source + "," + code + "\">>>>");
        this.outputStream.flush();
        System.out.println("[" + this.prefix + "] PROCESSRESULT=" + time + "," + source + "," + code);
    }

    public void writeResult(int returnCode) {
        this.writeProcessResult("", returnCode);
    }

    public void logStackTrace(Throwable t) {
        String text = ProcessOutputUtil.getStacktrace(t).trim();
        this.outputStream.println("<<<<STACKTRACE=\"" + text + "\">>>>");
        this.outputStream.flush();
        System.out.println("[" + this.prefix + "] " + text);
    }

    public static ProcessResult parseFileForLatestReturnCode(File f, String msgPrefix) throws IOException {
        String contents = FileUtil.readFileAsString(f.getAbsolutePath());
        return ProcessOutputUtil.parseOutputForLatestReturnCode(contents, msgPrefix);
    }

    public static ProcessResult[] parseFileForAllReturnCodes(File f, String msgPrefix) throws IOException {
        String contents = FileUtil.readFileAsString(f.getAbsolutePath());
        return ProcessOutputUtil.parseOutputForAllReturnCodes(contents, msgPrefix);
    }

    public static ProcessResult parseOutputForLatestReturnCode(String output, String prefix) {
        System.out.println("[ProcessOutputParserUtil] Parsing process output...");
        ProcessResult result = new ProcessResult();
        CharStack stack = new CharStack(output);
        while (!stack.isEmpty()) {
            stack.popUntil("<<<<", false);
            String key = stack.popUntil('=', true);
            stack.popUntil('\"', false);
            String value = stack.popUntil('\"', true);
            if (value == null) continue;
            if (key.equals("PROCESSRESULT")) {
                try {
                    value = value.trim();
                    String[] values = value.split(",");
                    result.time = Long.parseLong(values[0]);
                    result.source = values[1];
                    result.code = Integer.parseInt(values[2]);
                }
                catch (Throwable t) {
                    result.time = 0L;
                    result.source = "";
                    result.code = 0;
                }
                continue;
            }
            if (key.equals("LOGINFO")) {
                result.logMessages.append(prefix + " " + value.trim() + "\n");
                continue;
            }
            if (key.equals("LOGERROR")) {
                result.logErrors.append(value.trim() + "\n");
                continue;
            }
            if (!key.equals("STACKTRACE")) continue;
            result.stacktrace = value.trim();
        }
        return result;
    }

    public static ProcessResult[] parseOutputForAllReturnCodes(String output, String prefix) {
        System.out.println("[ProcessOutputParserUtil] Parsing process output for every return code...");
        ArrayList<ProcessResult> results = new ArrayList<ProcessResult>();
        CharStack stack = new CharStack(output);
        ProcessResult result = null;
        while (!stack.isEmpty()) {
            stack.popUntil("<<<<", false);
            String key = stack.popUntil('=', true);
            stack.popUntil('\"', false);
            String value = stack.popUntil('\"', true);
            if (value == null) continue;
            if (result == null) {
                result = new ProcessResult();
                results.add(result);
            }
            if (key.equals("PROCESSRESULT")) {
                try {
                    value = value.trim();
                    String[] values = value.split(",");
                    result.time = Long.parseLong(values[0]);
                    result.source = values[1];
                    result.code = Integer.parseInt(values[2]);
                    result = null;
                }
                catch (Throwable t) {
                    result.time = 0L;
                    result.source = "";
                    result.code = 0;
                }
                continue;
            }
            if (key.equals("LOGINFO")) {
                result.logMessages.append(prefix + " " + value.trim() + "\n");
                continue;
            }
            if (key.equals("LOGERROR")) {
                result.logErrors.append(value.trim() + "\n");
                continue;
            }
            if (!key.equals("STACKTRACE")) continue;
            result.stacktrace = value.trim();
        }
        ProcessResult[] allResults = new ProcessResult[results.size()];
        results.toArray(allResults);
        return allResults;
    }

    public static void logProcessMessage(String source, String msg) {
        ProcessOutputUtil po = new ProcessOutputUtil(source, System.out);
        po.logMessage(msg);
        System.out.flush();
    }

    public static void logProcessError(String source, String err) {
        ProcessOutputUtil po = new ProcessOutputUtil(source, System.out);
        po.logError(err);
        System.out.flush();
    }

    public static void logProcessTrace(String source, Throwable t) {
        ProcessOutputUtil po = new ProcessOutputUtil(source, System.out);
        po.logStackTrace(t);
        System.out.flush();
    }

    public static void logProcessResult(String source, int code) {
        ProcessOutputUtil po = new ProcessOutputUtil(source, System.out);
        po.writeProcessResult(source, code);
        System.out.flush();
    }
}

