/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.jwutils.test;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import jwrapper.jwutils.JWConstantClock;
import jwrapper.jwutils.JWSystem;
import jwrapper.jwutils.swing.JWAutomate;
import jwrapper.jwutils.test.JWTestProgress;
import jwrapper.jwutils.test.JWTestUI;
import jwrapper.updater.JWLaunchProperties;
import utils.message.Message;
import utils.message.MessageReader;
import utils.message.MessageWriter;
import utils.progtools.StackTracer;
import utils.swing.borders.SimpleShadowBorder;

public class JWTesting {
    public static String JWA_REPORT_PORT = "JWAutomation.ReportPort";
    public static String JWA_REPORT_HOST = "JWAutomation.ReportHost";
    public static String JWA_REPORT_BARRIER = "JWAutomation.BarrierSet";
    public static String BARRIER_SET_COMPLETE = "JWAutomation.BarrierSetComplete";
    private static int JWA_MSG_ATTEMPT = 1;
    private static int JWA_MSG_SUCCESS = 2;
    private static int JWA_MSG_FAIL = 3;
    private static int JWA_MSG_SCREEN = 4;
    private static int JWA_MSG_STATUS = 5;
    private static int JWA_MSG_KEEPALIVE = 7;
    private ServerSocket ssock;
    private Object LOCK = new Object();
    private HashMap map = new HashMap();
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd-HHmmss-SSS");
    private File dir;
    private File report;
    private boolean finished = false;
    private long finishAt = 0L;
    private long finishCases = 0L;
    private long inactivityTimeout = 180000L;
    private boolean noMoreCases = false;
    private Object status_LOCK = new Object();
    private HashMap statuses = new HashMap();
    JWTestProgress ui;
    private static Object reportSock_LOCK = new Object();
    private static Socket reportSock;
    private static MessageWriter mout;
    private static MessageReader min;
    private static OutputStream rout;
    private static InputStream rin;
    private static boolean reportSockOK;
    static String latestBarrierReached;
    public static Object barrier_LOCK;
    static int waitingAtBarrier;
    public static String FAKE_CONFIG_FOLDER;

    public void setInactivityTimeout(int ms) {
        this.inactivityTimeout = ms;
    }

    private void terminateInternal() {
        this.finished = true;
        try {
            this.ssock.close();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    static int getReportServerPort() {
        return Integer.parseInt(JWLaunchProperties.getProperty(JWA_REPORT_PORT));
    }

    public static JWTesting createNewTest() throws IOException {
        JWTestUI ui = new JWTestUI();
        System.out.println("Created new UI");
        return new JWTesting(ui);
    }

    private JWTesting(JWTestProgress ui) throws IOException {
        this.ui = ui;
        this.ssock = new ServerSocket(0);
        if (!JWLaunchProperties.isJWrapperSetup()) {
            JWLaunchProperties.setUpTestProperties();
        }
        JWLaunchProperties.overrideDynamicProperty(JWA_REPORT_PORT, "" + this.ssock.getLocalPort());
        System.out.println("[JWAutomation] Listening on " + this.ssock.getLocalPort());
        SSockThread sst = new SSockThread();
        sst.start();
        System.out.println("New test ready");
    }

    public void showSequentialUI(boolean b) {
        this.ui.setSequential(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void barrierReached(String name) {
        latestBarrierReached = name;
        Object object = barrier_LOCK;
        synchronized (object) {
            ++waitingAtBarrier;
            System.out.println("Waiting at barrier " + name + "...");
            try {
                barrier_LOCK.wait();
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseAllAtBarrier() {
        Object object = barrier_LOCK;
        synchronized (object) {
            waitingAtBarrier = 0;
            barrier_LOCK.notifyAll();
        }
    }

    public static String getLatestBarrierReached() {
        return latestBarrierReached;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getBarrierCount() {
        Object object = barrier_LOCK;
        synchronized (object) {
            return waitingAtBarrier;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setSock(String host, int port) {
        Object object = reportSock_LOCK;
        synchronized (object) {
            if (reportSock != null) {
                try {
                    reportSock.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                reportSock = null;
            }
            JWLaunchProperties.overrideProperty(JWA_REPORT_HOST, host);
            JWLaunchProperties.overrideProperty(JWA_REPORT_PORT, "" + port);
            JWTesting.loadSock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadSock() {
        if (!reportSockOK) {
            return;
        }
        Object object = reportSock_LOCK;
        synchronized (object) {
            if (reportSock == null) {
                try {
                    String host = JWLaunchProperties.getProperty(JWA_REPORT_HOST);
                    if (host.trim().length() == 0) {
                        host = "localhost";
                    }
                    int port = Integer.parseInt(JWLaunchProperties.getProperty(JWA_REPORT_PORT));
                    System.out.println("[JWTesting] Creating socket to test report server at " + host + ":" + port);
                    reportSock = new Socket(host, port);
                    rout = new BufferedOutputStream(reportSock.getOutputStream());
                    rin = new BufferedInputStream(reportSock.getInputStream());
                    mout = new MessageWriter(rout);
                    min = new MessageReader(rin);
                    if (JWSystem.getMyLogFile() != null) {
                        Message m = new Message();
                        m.append(JWSystem.getMyLogFile().getAbsolutePath());
                        mout.write(m);
                    } else {
                        Message m = new Message();
                        m.append("ERROR_NO_LOGFILE");
                        mout.write(m);
                    }
                    new KeepaliveThread().start();
                    System.out.println("[JWTesting] Socket to report server at " + host + ":" + port + " set up and ready");
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    reportSockOK = false;
                }
            }
        }
    }

    public static void main(String[] args) throws Exception {
        JWLaunchProperties tests = JWLaunchProperties.setUpTestProperties();
        Properties props = new Properties();
        JWTesting jwa = JWTesting.createNewTest();
        jwa.prepareTestInstance(props);
        tests.addStaticProperty(JWA_REPORT_PORT, props.getProperty(JWA_REPORT_PORT));
        System.out.println("Issuing reports...");
        JWTesting.reportAttempt("Make Tea", "Will involve use of the kettle, could be risky", 10000);
        JWTesting.reportAttempt("Make Coffee", "Will involve use of the kettle, could be risky", 3000);
        for (int i = 0; i < 60; ++i) {
            Thread.sleep(500L);
            JWTesting.reportSuccess("Scroll check " + i);
        }
        JWTesting.reportSuccess("Make Tea");
        JWTesting.reportAttempt("Bake a cake", "Nothing", 4000);
        Thread.sleep(2000L);
        JWTesting.reportAttempt("Bake a cake", "Nothing", 4000);
        Thread.sleep(2000L);
        JWTesting.reportAttempt("Bake a cake", "Nothing", 4000);
        Thread.sleep(2000L);
        JWTesting.reportAttempt("Bake a cake", "Nothing", 4000);
        Thread.sleep(2000L);
        JWTesting.reportSuccess("Bake a cake");
        JWTesting.reportSuccess("Bake a cake");
        JWTesting.reportSuccess("Bake a cake");
        JWTesting.reportSuccess("Bake a cake");
        Thread.sleep(1000L);
        JWTesting.reportSuccess("Bake a cake");
        Thread.sleep(1000L);
        JWTesting.reportSuccess("Bake a cake");
        Thread.sleep(1000L);
        JWTesting.reportSuccess("Bake a cake");
        Thread.sleep(1000L);
        JWTesting.reportSuccess("Bake a cake");
    }

    public static void createFakeAllAppVersionsSharedFolder() {
        FAKE_CONFIG_FOLDER = "JWAppsSharedConfig_" + System.currentTimeMillis() % 100000L + "_" + (int)(Math.random() * 1.0E9);
    }

    public static void createFakeAllAppVersionsSharedFolder(String name) {
        FAKE_CONFIG_FOLDER = "JWAppsSharedConfig_" + name;
    }

    public void noMoreTestcases() {
        this.noMoreCases = true;
    }

    public void terminate() {
        this.terminateInternal();
    }

    public void prepareTestInstance(Properties launchProperties) throws IOException {
        launchProperties.setProperty(JWA_REPORT_PORT, "" + this.ssock.getLocalPort());
    }

    public static boolean amTesting() {
        if (!JWLaunchProperties.isJWrapperSetup()) {
            return false;
        }
        return JWLaunchProperties.getProperty(JWA_REPORT_PORT).length() != 0;
    }

    public static boolean mustWaitAtBarrier(String name) {
        if (!JWLaunchProperties.isJWrapperSetup()) {
            return false;
        }
        return JWLaunchProperties.getProperty(JWA_REPORT_BARRIER).equalsIgnoreCase(name);
    }

    private static String normalise(String s) {
        return s.replace('\'', '_').replace('\"', '_');
    }

    public static String getMyPid() {
        try {
            return ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
        }
        catch (Exception x) {
            return "UNKNOWN PID";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reportAttempt(String name, String details, int timeoutFailMillis) {
        System.out.println("[JWTesting] Reporting attempt of " + name);
        name = JWTesting.normalise(name);
        if (details == null) {
            details = "";
        }
        JWTesting.loadSock();
        Object object = reportSock_LOCK;
        synchronized (object) {
            try {
                if (rout != null) {
                    Message m = new Message(JWA_MSG_ATTEMPT);
                    m.append(name);
                    m.append(details);
                    m.append(timeoutFailMillis);
                    mout.write(m);
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    public static void reportStandaloneSuccess(String name) {
        JWTesting.reportAttempt(name, "", 90000);
        JWTesting.reportSuccess(name);
    }

    public static void reportStandaloneFail(String name, String desc) {
        JWTesting.reportAttempt(name, desc, 0);
    }

    public static void reportStandaloneFail(String name) {
        JWTesting.reportAttempt(name, "", 0);
    }

    public static void reportStandaloneFail(String name, Throwable err) {
        JWTesting.reportAttempt(name, StackTracer.getStacktrace(err), 0);
    }

    public static void reportStandaloneSuccess(String name, String desc) {
        JWTesting.reportAttempt(name, desc, 90000);
        JWTesting.reportSuccess(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reportSuccess(String name) {
        System.out.println("[JWTesting] Reporting success of " + name);
        name = JWTesting.normalise(name);
        JWTesting.loadSock();
        Object object = reportSock_LOCK;
        synchronized (object) {
            try {
                if (rout != null) {
                    Message m = new Message(JWA_MSG_SUCCESS);
                    m.append(name);
                    mout.write(m);
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reportFail(String name, String details) {
        System.out.println("[JWTesting] Reporting FAILURE of " + name);
        name = JWTesting.normalise(name);
        JWTesting.loadSock();
        Object object = reportSock_LOCK;
        synchronized (object) {
            try {
                if (rout != null) {
                    Message m = new Message(JWA_MSG_FAIL);
                    m.append(name);
                    m.append(details);
                    mout.write(m);
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    public static void countdownStatus(String name, String nextAction, int mins) {
        for (int zz = mins; zz > 0; --zz) {
            JWTesting.reportStatus(name, nextAction + " in " + zz + " mins");
            JWAutomate.sleepMins(1.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reportStatus(String name, String status) {
        System.out.println("[JWTesting] Reporting status: " + name + " = " + status);
        name = JWTesting.normalise(name);
        JWTesting.loadSock();
        Object object = reportSock_LOCK;
        synchronized (object) {
            try {
                if (rout != null) {
                    Message m = new Message(JWA_MSG_STATUS);
                    m.append(name);
                    m.append(status);
                    mout.write(m);
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    public static void reportScreenshot(String name, JFrame frame, boolean standaloneSuccess) {
        JWTesting.reportScreenshot(name, frame.getContentPane(), standaloneSuccess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reportScreenshot(String name, Component comp, boolean standaloneSuccess) {
        if (standaloneSuccess) {
            System.out.println("[JWTesting] Reporting success of " + name);
        }
        JWTesting.loadSock();
        name = JWTesting.normalise(name);
        BufferedImage bimg = new BufferedImage(comp.getWidth() + 4, comp.getHeight() + 4, 2);
        Graphics g = bimg.getGraphics();
        try {
            SwingUtilities.invokeAndWait(new Painter(comp, g.create(1, 1, comp.getWidth(), comp.getHeight())));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        SimpleShadowBorder ssb = new SimpleShadowBorder(false);
        ssb.paintBorder(null, g, 0, 0, comp.getWidth() + 1, comp.getHeight() + 1);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)bimg, "PNG", bout);
            Object object = reportSock_LOCK;
            synchronized (object) {
                if (rout != null) {
                    Message m;
                    if (standaloneSuccess) {
                        m = new Message(JWA_MSG_ATTEMPT);
                        m.append(name);
                        m.append("");
                        m.append(5000);
                        mout.write(m);
                    }
                    m = new Message(JWA_MSG_SCREEN);
                    m.append(name);
                    m.append(bout.toByteArray());
                    mout.write(m);
                    if (standaloneSuccess) {
                        m = new Message(JWA_MSG_SUCCESS);
                        m.append(name);
                        mout.write(m);
                    }
                }
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    static {
        reportSockOK = true;
        latestBarrierReached = "None";
        barrier_LOCK = new Object();
        waitingAtBarrier = 0;
        FAKE_CONFIG_FOLDER = null;
    }

    static class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            System.out.println("Woot!");
        }
    }

    static class KeepaliveThread
    extends Thread {
        KeepaliveThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep(15000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Object object = reportSock_LOCK;
                synchronized (object) {
                    try {
                        if (rout != null) {
                            Message m = new Message(JWA_MSG_KEEPALIVE);
                            m.append("KEEPALIVE");
                            mout.write(m);
                        }
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                    }
                }
            }
        }
    }

    private static class Painter
    implements Runnable {
        Component comp;
        Graphics g;

        Painter(Component comp, Graphics g) {
            this.comp = comp;
            this.g = g;
        }

        @Override
        public void run() {
            this.comp.paintAll(this.g);
        }
    }

    private class SSockThread
    extends Thread {
        private SSockThread() {
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Socket s = JWTesting.this.ssock.accept();
                    SockThread st = new SockThread(s);
                    st.start();
                }
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    private class SockThread
    extends Thread {
        Object LOCK = new Object();
        HashMap localmap = new HashMap();
        String runLogFile;
        long lastKeepalive = JWConstantClock.currentTimeMillis();
        Socket sock;

        public SockThread(Socket sock) {
            this.sock = sock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            String clientName = "Unknown";
            try {
                System.out.println("[JWTestUI] New instance connected back");
                BufferedInputStream in = new BufferedInputStream(this.sock.getInputStream());
                BufferedOutputStream out = new BufferedOutputStream(this.sock.getOutputStream());
                MessageReader min = new MessageReader(in);
                MessageWriter mout = new MessageWriter(out);
                Message msg = min.read();
                this.runLogFile = msg.getNextString();
                clientName = new File(this.runLogFile).getName();
                while (true) {
                    Object object;
                    Object object2;
                    Object status;
                    msg = min.read();
                    int type = msg.getType();
                    String name = msg.getNextString();
                    System.out.println("[JWTestUI] Report from " + clientName + ": " + msg);
                    if (type == JWA_MSG_STATUS) {
                        status = msg.getNextString();
                        object2 = JWTesting.this.status_LOCK;
                        // MONITORENTER : object2
                        JWTesting.this.statuses.put(name, status);
                        // MONITOREXIT : object2
                        continue;
                    }
                    status = this.LOCK;
                    // MONITORENTER : status
                    System.out.println("[JWTestUI] New entry " + name + " map = " + JWTesting.this.map.size());
                    // MONITOREXIT : status
                    if (type == JWA_MSG_KEEPALIVE) {
                        this.lastKeepalive = JWConstantClock.currentTimeMillis();
                        continue;
                    }
                    if (type == JWA_MSG_ATTEMPT) {
                        String details = msg.getNextString();
                        int millis = msg.getNextInt();
                        JWTesting.this.ui.testAttempt(name, details, millis, this.runLogFile);
                        continue;
                    }
                    if (type == JWA_MSG_SUCCESS) {
                        JWTesting.this.ui.testSuccess(name);
                        continue;
                    }
                    if (type == JWA_MSG_FAIL) {
                        object = msg.getNextString();
                        continue;
                    }
                    if (type != JWA_MSG_SCREEN) continue;
                    object = this.LOCK;
                    // MONITORENTER : object
                    object2 = msg.getNextByteArray();
                    // MONITOREXIT : object
                }
            }
            catch (EOFException t) {
                System.out.println("[IMPORTANT] Client " + clientName + " has disconnected");
                return;
            }
            catch (SocketException t) {
                System.out.println("[IMPORTANT] Client " + clientName + " has disconnected");
                return;
            }
            catch (Throwable t) {
                JWTesting.this.ui.testError("Client communications has failed! - " + t);
                System.out.println("[WARNING] Client " + clientName + " communications has failed - " + t);
                t.printStackTrace();
            }
        }
    }
}

