/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.jwutils.test;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import jwrapper.jwutils.JWSockIPC;
import jwrapper.jwutils.JWSockIPCListener;
import jwrapper.jwutils.test.JWTestable;
import jwrapper.jwutils.test.JWTesting;
import utils.message.Message;
import utils.message.MessageUtils;
import utils.progtools.Counter;
import utils.stream.StreamUtils;

public class JWTestControl {
    private static int CALL = 1;
    private static int UNSHARE = 2;
    private static int RELEASE_BARRIER = 3;
    private static int DELAY = 500;
    static ServerSocket ssock;
    public static int MC_PORT;
    static Object LOCK;
    static ArrayList<JWTestable> all;
    static HashMap<String, ArrayList<JWTestable>> named;
    static Counter namedPtrs;
    static Counter ipcs;
    private static boolean amDeferred;

    public static void listenForShared(int port, int mcport) throws IOException {
        if (ssock == null) {
            ssock = new ServerSocket(port);
        }
        new PullThread().start();
        new MCastThread(port, mcport).start();
    }

    public static int getDelay() {
        return DELAY;
    }

    public static void setDelay(int ms) {
        DELAY = ms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JWTestable getNextShared() throws IOException {
        System.out.println("[JWTestControl] Ready to accept next IPC...");
        JWSockIPC ipc = JWSockIPC.createNewIPC(ssock.accept());
        System.out.println("[JWTestControl] Incoming JWT");
        ipc.setupMultipleChannels();
        System.out.println("[JWTestControl] Setup multiple channels");
        OutputStream out = ipc.getOutChannel((short)0);
        StreamUtils.writeInt(out, JWTesting.getReportServerPort());
        out.flush();
        System.out.println("[JWTestControl] Wrote report server port");
        InputStream in = ipc.getInChannel((short)0);
        String name = StreamUtils.readNString(in, 1000000);
        JWTestableLocal jwt = new JWTestableLocal(name, ipc);
        ipc.setupPingsAndReportClosure(jwt, (short)-1, 5000L);
        Object object = LOCK;
        synchronized (object) {
            System.out.println("[JWTestControl] Adding connected app " + name);
            ipcs.add(name, 1.0);
        }
        object = LOCK;
        synchronized (object) {
            all.add(jwt);
            ArrayList<JWTestable> jwts = named.get(jwt.getTestableAppName());
            if (jwts == null) {
                jwts = new ArrayList();
                named.put(jwt.getTestableAppName(), jwts);
            }
            jwts.add(jwt);
        }
        return jwt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getAvailable(String name) {
        Object object = LOCK;
        synchronized (object) {
            ArrayList<JWTestable> jwts = named.get(name);
            if (jwts == null) {
                return 0;
            }
            return jwts.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getConnected(String name) {
        Object object = LOCK;
        synchronized (object) {
            return ipcs.getInt(name, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clear(JWTestable test) throws IOException {
        JWTestableLocal jwt = (JWTestableLocal)test;
        Object object = LOCK;
        synchronized (object) {
            all.remove(jwt);
            ArrayList<JWTestable> jwts = named.get(jwt.getTestableAppName());
            if (jwts != null) {
                jwts.remove(jwt);
            }
        }
    }

    public static void callOne(String name, String str, Message m) throws IOException {
        JWTestControl.callN(1, name, str, m);
    }

    public static void callOne(String name, String str) throws IOException {
        JWTestControl.callOne(name, str, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void callN(int N, String name, String str, Message m) throws IOException {
        Object object = LOCK;
        synchronized (object) {
            ArrayList<JWTestable> jwts = named.get(name);
            for (int i = 0; i < N; ++i) {
                int currentPtr = namedPtrs.getInt(name, 0);
                try {
                    jwts.get(currentPtr % jwts.size()).call(str, m);
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
                namedPtrs.add(name, 1.0);
                try {
                    Thread.sleep(DELAY);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static void callN(int N, String name, String str) throws IOException {
        JWTestControl.callN(N, name, str, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void callAll(String name, String str, Message m) throws IOException {
        Object object = LOCK;
        synchronized (object) {
            ArrayList<JWTestable> jwts = named.get(name);
            for (int i = 0; i < jwts.size(); ++i) {
                jwts.get(i).call(str, m);
                try {
                    Thread.sleep(DELAY);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static void callAll(String name, String str) throws IOException {
        JWTestControl.callAll(name, str, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JWTestable getShared(String name, int index) throws IOException {
        Object object = LOCK;
        synchronized (object) {
            ArrayList<JWTestable> jwts = named.get(name);
            return jwts.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JWTestable popShared(String name, int timeout) throws IOException {
        long expiry = System.currentTimeMillis() + (long)timeout;
        while (System.currentTimeMillis() < expiry) {
            Object object = LOCK;
            synchronized (object) {
                ArrayList<JWTestable> jwts = named.get(name);
                if (jwts != null && jwts.size() > 0) {
                    return jwts.remove(0);
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        throw new IOException("Timed out waiting for JWTestable app " + name);
    }

    public static boolean amDeferred() {
        return amDeferred;
    }

    public static void shareJWT(JWTestable test, String host, int port) throws IOException {
        amDeferred = true;
        System.out.println("[JWTesting] Attempting to create new IPC to " + host + ":" + port);
        JWSockIPC ipc = JWSockIPC.createNewIPC(new Socket(host, port));
        System.out.println("[JWTesting] IPC Created");
        ipc.setupMultipleChannels();
        System.out.println("[JWTesting] Multiple channels created");
        int testReportPort = StreamUtils.readInt(ipc.getInChannel((short)0));
        System.out.println("[JWTesting] Setting test report server address");
        JWTesting.setSock(host, testReportPort);
        System.out.println("[JWTesting] Sharing JWT");
        new JWTestableRemote(test, ipc).start();
    }

    public static String shareJWT(JWTestable test, int mcport) throws IOException {
        MulticastSocket socket = new MulticastSocket(mcport);
        InetAddress group = InetAddress.getByName("225.0.215.0");
        try {
            socket.setNetworkInterface(NetworkInterface.getByName("en0"));
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        socket.joinGroup(group);
        byte[] buf = new byte[2048];
        Arrays.fill(buf, (byte)0);
        DatagramPacket dp = new DatagramPacket(buf, 0, buf.length);
        long T = System.currentTimeMillis() + 60000L;
        while (System.currentTimeMillis() < T) {
            System.out.println("Listening for TestControl on " + group + " port " + mcport);
            socket.receive(dp);
            String mine = "JWTestControl" + mcport;
            String str = new String(buf, 0, buf.length, "ASCII");
            int index = str.indexOf(mine);
            int port = -1;
            if (index != -1) {
                port = Integer.parseInt(str.substring(0, index));
            }
            System.out.println("[JWTesting] Received incoming " + str + " vs " + mine);
            if (index == -1) continue;
            System.out.println("[JWTesting] Received notification from test control (port " + mcport + "): " + str);
            String host = dp.getAddress().getHostAddress();
            System.out.println("[JWTesting] JWTestControl host is " + host);
            System.out.println("[JWTesting] JWTestControl port is " + port);
            JWTestControl.shareJWT(test, host, port);
            System.out.println("[JWTesting] Shared JWT with " + host);
            return host;
        }
        throw new IOException("No JWTestControl found on this network");
    }

    public static void unshareJWT() throws IOException {
        JWTestableRemote proxy = (JWTestableRemote)Thread.currentThread();
        StreamUtils.writeInt(proxy.out, UNSHARE);
        proxy.out.flush();
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        proxy.ipc.close();
    }

    public static void main(String[] args) throws Exception {
        int i;
        JWTestControl.listenForShared(1090, MC_PORT);
        for (i = 0; i < 2; ++i) {
            JWTestControl.shareJWT(new ExampleJWT("A"), "localhost", 1090);
        }
        for (i = 0; i < 5; ++i) {
            JWTestControl.shareJWT(new ExampleJWT("B"), "localhost", 1090);
        }
        Thread.sleep(100L);
        while (JWTestControl.getConnected("A") > 0) {
            JWTestControl.callN(2, "A", "meh", new Message());
            Thread.sleep(500L);
        }
        while (JWTestControl.getConnected("B") > 0) {
            JWTestControl.callAll("B", "muh", new Message());
            Thread.sleep(500L);
        }
    }

    static {
        MC_PORT = 6077;
        LOCK = new Object();
        all = new ArrayList();
        named = new HashMap();
        namedPtrs = new Counter();
        ipcs = new Counter();
        amDeferred = false;
    }

    private static class ExampleJWT
    implements JWTestable {
        String name;

        public ExampleJWT(String s) {
            this.name = s;
        }

        @Override
        public String getTestableAppName() {
            return this.name;
        }

        @Override
        public void call(String str, Message m) throws IOException {
            System.out.println(this.name + "-" + this.hashCode() + ": " + str + ", " + m);
            JWTestControl.unshareJWT();
        }

        @Override
        public void testControlConnectionFailed() {
            System.out.println("Test connection FAILED!");
        }
    }

    private static class JWTestableLocal
    implements JWTestable,
    JWSockIPCListener {
        String name;
        JWSockIPC ipc;
        InputStream in;
        OutputStream out;

        public JWTestableLocal(String name, JWSockIPC ipc) throws IOException {
            this.name = name;
            this.ipc = ipc;
            this.in = ipc.getInChannel((short)0);
            this.out = ipc.getOutChannel((short)0);
            new UnshareThread(this).start();
        }

        @Override
        public String getTestableAppName() {
            return this.name;
        }

        public void releaseBarrier() throws IOException {
            System.out.println("[JWTestControl] Releasing barrier");
            StreamUtils.writeInt(this.out, RELEASE_BARRIER);
            this.out.flush();
        }

        @Override
        public void call(String str, Message m) throws IOException {
            System.out.println("[JWTestControl] Calling " + str);
            if (m == null) {
                m = new Message();
            }
            StreamUtils.writeInt(this.out, CALL);
            StreamUtils.writeString(this.out, str);
            MessageUtils.writeMessage(this.out, m);
            this.out.flush();
        }

        @Override
        public void testControlConnectionFailed() {
            System.out.println("[JWTestControl] Connection to " + this.name + " has FAILED!");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ipcClosed() {
            Object object = LOCK;
            synchronized (object) {
                System.out.println("[JWTestControl] Removing connected app " + this.name);
                ipcs.add(this.name, -1.0);
                ArrayList<JWTestable> jwts = named.get(this.getTestableAppName());
                jwts.remove(this);
            }
        }
    }

    private static class JWTestableRemote
    extends Thread
    implements JWSockIPCListener {
        JWTestable test;
        JWSockIPC ipc;
        InputStream in;
        OutputStream out;

        public JWTestableRemote(JWTestable test, JWSockIPC ipc) throws IOException {
            this.test = test;
            this.ipc = ipc;
            this.in = ipc.getInChannel((short)0);
            this.out = ipc.getOutChannel((short)0);
        }

        @Override
        public void run() {
            try {
                StreamUtils.writeString(this.out, this.test.getTestableAppName());
                this.out.flush();
                this.ipc.setupPingsAndReportClosure(this, (short)-1, 5000L);
                JWTesting.reportStandaloneSuccess("JWT Connected - " + this.test.getTestableAppName());
                while (true) {
                    int cmd;
                    if ((cmd = StreamUtils.readInt(this.in)) != CALL) {
                        continue;
                    }
                    String str = StreamUtils.readString(this.in);
                    Message m = MessageUtils.readMessage(this.in);
                    System.out.println("[JWTestable] Asked to " + str + " " + m);
                    this.test.call(str, m);
                }
            }
            catch (Exception x) {
                JWTesting.reportAttempt(this.test.getTestableAppName() + " Failed", "" + x, 1);
                x.printStackTrace();
                this.test.testControlConnectionFailed();
                return;
            }
        }

        @Override
        public void ipcClosed() {
            this.test.testControlConnectionFailed();
        }
    }

    static class MCastThread
    extends Thread {
        int port;
        int mcport;

        public MCastThread(int port, int mcport) {
            this.port = port;
            this.mcport = mcport;
        }

        @Override
        public void run() {
            try {
                InetAddress group = InetAddress.getByName("225.0.215.0");
                MulticastSocket socket = new MulticastSocket(this.mcport);
                try {
                    socket.setNetworkInterface(NetworkInterface.getByName("en0"));
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
                socket.joinGroup(group);
                String msg = this.port + "JWTestControl" + this.mcport;
                byte[] bytes = msg.getBytes("ASCII");
                DatagramPacket dp = new DatagramPacket(bytes, bytes.length, group, this.mcport);
                System.out.println("[JWTestControl] Broadcasting to " + group + " on port " + this.mcport);
                while (true) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    socket.send(dp);
                }
            }
            catch (Throwable x) {
                System.out.println("[JWTestControl] Stopped broadcasting: " + x);
                x.printStackTrace();
                return;
            }
        }
    }

    static class PullThread
    extends Thread {
        PullThread() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        JWTestControl.getNextShared();
                    }
                }
                catch (Exception x) {
                    x.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    static class UnshareThread
    extends Thread {
        JWTestableLocal jwt;

        public UnshareThread(JWTestableLocal jwt) {
            this.jwt = jwt;
        }

        @Override
        public void run() {
            try {
                int unshare = StreamUtils.readInt(this.jwt.in);
                JWTestControl.clear(this.jwt);
            }
            catch (IOException x) {
                x.printStackTrace();
            }
        }
    }
}

