/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.jwutils;

import jwrapper.hidden.JWNativeAPI;

public class JWWindowsRegistry {
    public static final String TYPE_BINARY = "REG_BINARY";
    public static final String TYPE_DWORD = "REG_DWORD";
    public static final String TYPE_DWORD_LE = "REG_DWORD_LE";
    public static final String TYPE_DWORD_BE = "REG_DWORD_BE";
    public static final String TYPE_EXPAND_SZ = "REG_EXPAND_SZ";
    public static final String TYPE_LINK = "REG_LINK";
    public static final String TYPE_MULTI_SZ = "REG_MULTI_SZ";
    public static final String TYPE_NONE = "REG_NONE";
    public static final String TYPE_QWORD = "REG_QWORD";
    public static final String TYPE_QWORD_LE = "REG_QWORD_LE";
    public static final String TYPE_SZ = "REG_SZ";

    public boolean deleteValue(String hkey, String keyname, String valueName) {
        return JWNativeAPI.getInstance().regDeleteValue(hkey, keyname, valueName);
    }

    public static void deleteKey(String hkey, String pathToParentKey, String keyToDeleteName) {
        JWNativeAPI.getInstance().regDeleteKey(hkey, pathToParentKey, keyToDeleteName);
    }

    public static boolean regSetBinary(String hkey, String keyName, String valueName, byte[] dat, String type) {
        return JWNativeAPI.getInstance().regSetBinary(hkey, keyName, valueName, dat, dat.length, type);
    }

    public static boolean regSet(String hkey, String keyName, String valueName, String valueValue, String type) {
        return JWNativeAPI.getInstance().regSet(hkey, keyName, valueName, valueValue, type);
    }

    public static String regGet(String hkey, String keyName, String valueName) {
        return JWNativeAPI.getInstance().regGet(hkey, keyName, valueName);
    }

    public static boolean regCreateKey(String rootKeyName, String subKeyName) {
        return JWNativeAPI.getInstance().regCreateKey(rootKeyName, subKeyName);
    }

    public static boolean regCreateKey(String fullKeyName) {
        return JWWindowsRegistry.regCreateKey(JWWindowsRegistry.getRootKeyName(fullKeyName), JWWindowsRegistry.getSubKeyName(fullKeyName));
    }

    private static String getRootKeyName(String keyName) {
        int firstSlash = keyName.indexOf(92);
        if (firstSlash == -1) {
            return keyName;
        }
        return keyName.substring(0, firstSlash);
    }

    private static String getSubKeyName(String keyName) {
        int firstSlash = keyName.indexOf(92);
        if (firstSlash == -1) {
            return "";
        }
        return keyName.substring(firstSlash + 1);
    }

    public static String[][] regGetChildren(String keyName) {
        if (JWNativeAPI.getInstance() != null) {
            String[] result = JWNativeAPI.getInstance().regGetChildren(JWWindowsRegistry.getRootKeyName(keyName), JWWindowsRegistry.getSubKeyName(keyName));
            if (result == null) {
                return new String[0][0];
            }
            int numberOfKeys = 0;
            int numberOfValues = 0;
            for (int i = 0; i < result.length && !result[i].startsWith("------"); ++i) {
                ++numberOfKeys;
            }
            numberOfValues = result.length - numberOfKeys - 1;
            String[] keys = new String[numberOfKeys];
            String[] values = new String[numberOfValues];
            System.arraycopy(result, 0, keys, 0, numberOfKeys);
            System.arraycopy(result, numberOfKeys + 1, values, 0, numberOfValues);
            return new String[][]{keys, values};
        }
        return new String[0][0];
    }
}

