/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.jwutils;

import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import jwrapper.jwutils.JWGenericOS;
import jwrapper.jwutils.JWSystem;
import jwrapper.jwutils.JWWindowsRegistry;
import jwrapper.jwutils.service.ManageService;
import jwrapper.updater.JWLaunchProperties;
import utils.files.FileLockUtil;
import utils.files.PermissionsUtil;
import utils.message.Message;
import utils.message.mappedfile.MFMessageHandler;
import utils.message.mappedfile.MessageHandler;
import utils.ostools.OS;
import utils.stream.MappedChannel;
import utils.stream.StreamUtils;

public class JWService {
    static String serviceName = null;

    public static void setDefaultServiceName(String name) {
        serviceName = name;
    }

    public static void useFullyQualifiedDefaultServiceName() {
        String name = JWSystem.getMyAppName();
        serviceName = name == null || name.length() == 0 ? JWSystem.getAppBundleName() : JWSystem.getAppBundleName() + " " + name;
    }

    private static String getServiceLockFileName() {
        String name = JWSystem.getMyAppName();
        if (name == null || name.length() == 0) {
            name = JWSystem.getAppBundleName();
        }
        return name;
    }

    public static boolean isServiceRunning() {
        File parentDirectory = JWSystem.getAllAppVersionsSharedFolder();
        File lockFile = new File(parentDirectory, JWService.getServiceLockFileName() + ".lock");
        return FileLockUtil.isFileCurrentlyLocked(lockFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getServicePID() {
        block9: {
            File parentDirectory = JWSystem.getAllAppVersionsSharedFolder();
            File lockFile = new File(parentDirectory, JWService.getServiceLockFileName() + ".lock");
            if (lockFile.exists()) {
                FileLockUtil.LockResult sharedLock = FileLockUtil.sharedLockFile(lockFile, false);
                try {
                    String string;
                    FileInputStream fin = new FileInputStream(lockFile);
                    try {
                        string = StreamUtils.readAllAsString(fin);
                    }
                    catch (Throwable throwable) {
                        try {
                            fin.close();
                            throw throwable;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            break block9;
                        }
                    }
                    fin.close();
                    return string;
                }
                finally {
                    FileLockUtil.releaseLock(sharedLock);
                }
            }
        }
        return null;
    }

    private static File getServiceLauncherShortcutDirectory() {
        File parentDirectory = JWSystem.getAllAppVersionsSharedFolder();
        File targetDirectory = new File(parentDirectory, JWSystem.getMyAppName());
        return targetDirectory;
    }

    private static File getOrCreateServiceStartLauncher(String startServiceVirtualApp) throws IOException {
        return JWService.getOrCreateSgServiceLauncher("Start" + JWSystem.getMyAppName(), startServiceVirtualApp);
    }

    private static File getOrCreateServiceStopLauncher(String stopServiceVirtualApp) throws IOException {
        return JWService.getOrCreateSgServiceLauncher("Stop" + JWSystem.getMyAppName(), stopServiceVirtualApp);
    }

    private static File getOrCreateSgServiceLauncher(String shortcutName, String vapp) throws IOException {
        File targetDirectory = JWService.getServiceLauncherShortcutDirectory();
        if (!targetDirectory.exists()) {
            targetDirectory.mkdirs();
            JWGenericOS.setWritableForAllUsers(targetDirectory, true);
        }
        Properties serviceProperties = new Properties();
        serviceProperties.setProperty("show_no_ui", "true");
        String name = JWService.getServiceLockFileName();
        serviceProperties.setProperty("jwservice_lockfile", name);
        System.out.println("[JWService] Creating " + shortcutName + " launcher shortcut for virtual app (" + vapp + ")");
        File launcher = JWSystem.saveLauncherShortcutForVirtualApp(targetDirectory, shortcutName, vapp, serviceProperties, false);
        JWGenericOS.setReadableForAllUsers(launcher, true);
        return launcher;
    }

    public static void installService(String startVirtualApp, boolean requiresUI) throws Exception {
        JWService.installService(startVirtualApp, null, null, requiresUI);
    }

    public static void installService(String startVirtualApp, String stopVirtualApp, boolean requiresUI) throws Exception {
        JWService.installService(startVirtualApp, stopVirtualApp, null, requiresUI);
    }

    public static void installService(String startVirtualApp, String stopVirtualApp, URL overrideUpdateURL, boolean requiresUI) throws Exception {
        JWService.installService(startVirtualApp, stopVirtualApp, overrideUpdateURL, requiresUI, null);
    }

    public static void installService(String startVirtualApp, String stopVirtualApp, URL overrideUpdateURL, boolean requiresUI, String elevatedPostInstallClassname) throws Exception {
        JWService.doInstallService(startVirtualApp, stopVirtualApp, overrideUpdateURL, requiresUI, false, elevatedPostInstallClassname);
    }

    public static void reinstallService(String startVirtualApp, boolean requiresUI) throws Exception {
        JWService.reinstallService(startVirtualApp, null, null, requiresUI, null);
    }

    public static void reinstallService(String startVirtualApp, String stopVirtualApp, URL overrideUpdateURL, boolean requiresUI, String elevatedPostInstallClassname) throws Exception {
        JWService.doInstallService(startVirtualApp, stopVirtualApp, overrideUpdateURL, requiresUI, true, elevatedPostInstallClassname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doInstallService(String startVirtualApp, String stopVirtualApp, URL overrideUpdateURL, boolean requiresUI, boolean uninstallFirst, String serviceElevatedPostinstallClass) throws Exception {
        Object lock;
        System.out.println("[JWService] Install service requested");
        File starter = JWService.getOrCreateServiceStartLauncher(startVirtualApp);
        File stopper = null;
        if (stopVirtualApp != null) {
            stopper = JWService.getOrCreateServiceStopLauncher(stopVirtualApp);
        }
        if (JWSystem.getUpdateURL().length() <= 1 && overrideUpdateURL != null) {
            JWSystem.overrideSourceLauncherUpdateURL(overrideUpdateURL);
        }
        Object object = lock = new Object();
        synchronized (object) {
            System.out.println("[JWService] Initialising manage service virtual app");
            Properties lprops = new Properties();
            lprops.setProperty(ManageService.PROPERTY_START_LAUNCHER_PATH, starter.getCanonicalPath());
            if (stopper != null) {
                lprops.setProperty(ManageService.PROPERTY_STOP_LAUNCHER_PATH, stopper.getCanonicalPath());
            }
            lprops.setProperty(ManageService.PROPERTY_SERVICE_NEEDS_UI, Boolean.toString(requiresUI));
            if (serviceElevatedPostinstallClass != null) {
                lprops.setProperty(ManageService.PROPERTY_POSTINSTALL_MAIN, serviceElevatedPostinstallClass);
            }
            ServiceMessageHandler handler = new ServiceMessageHandler(lock);
            if (uninstallFirst) {
                JWService.initManageServiceVirtualApp(lprops, ManageService.VALUE_ACTION_REINSTALL, handler);
            } else {
                JWService.initManageServiceVirtualApp(lprops, ManageService.VALUE_ACTION_INSTALL, handler);
            }
            lock.wait(30000L);
            if (!handler.serviceInstallUninstallResult) {
                if (handler.error != null) {
                    throw handler.error;
                }
                throw new Exception("Service removal timed out.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeService() throws ServiceManagementException, IOException, Exception {
        Object INSTALL_REMOVE_LOCK;
        File targetDirectory = JWService.getServiceLauncherShortcutDirectory();
        File starter = JWSystem.getLauncherLocationForVirtualApp(targetDirectory, "Start" + JWSystem.getMyAppName());
        File stopper = JWSystem.getLauncherLocationForVirtualApp(targetDirectory, "Stop" + JWSystem.getMyAppName());
        Object object = INSTALL_REMOVE_LOCK = new Object();
        synchronized (object) {
            Properties lprops = new Properties();
            lprops.setProperty(ManageService.PROPERTY_START_LAUNCHER_PATH, starter.getCanonicalPath());
            if (stopper.exists()) {
                lprops.setProperty(ManageService.PROPERTY_STOP_LAUNCHER_PATH, stopper.getCanonicalPath());
            }
            String pid = JWService.getServicePID();
            lprops.setProperty(ManageService.PROPERTY_SERVICE_PID, pid);
            ServiceMessageHandler handler = new ServiceMessageHandler(INSTALL_REMOVE_LOCK);
            JWService.initManageServiceVirtualApp(lprops, ManageService.VALUE_ACTION_REMOVE, handler);
            INSTALL_REMOVE_LOCK.wait(30000L);
            if (!handler.serviceInstallUninstallResult) {
                if (handler.error != null) {
                    throw handler.error;
                }
                throw new Exception("Service removal timed out.");
            }
        }
    }

    private static void initManageServiceVirtualApp(Properties properties, String action, MessageHandler handler) throws Exception {
        File targetDirectory = JWService.getServiceLauncherShortcutDirectory();
        properties.setProperty(ManageService.PROPERTY_ACTION, action);
        properties.setProperty(ManageService.PROPERTY_SERVICE_DIR, targetDirectory.getCanonicalPath());
        boolean useFqNames = JWLaunchProperties.getBooleanProperty("PROP_USE_SERVICE_FQ_NAMES", false);
        if (serviceName != null) {
            properties.setProperty(ManageService.PROPERTY_SERVICE_NAME, serviceName);
        } else if (useFqNames) {
            if (JWSystem.getMyAppName() != null) {
                properties.setProperty(ManageService.PROPERTY_SERVICE_NAME, JWSystem.getAppBundleName() + " " + JWSystem.getMyAppName());
            } else {
                properties.setProperty(ManageService.PROPERTY_SERVICE_NAME, JWSystem.getAppBundleName());
            }
        } else if (JWSystem.getMyAppName() != null) {
            properties.setProperty(ManageService.PROPERTY_SERVICE_NAME, JWSystem.getMyAppName());
        } else {
            properties.setProperty(ManageService.PROPERTY_SERVICE_NAME, JWSystem.getAppBundleName());
        }
        properties.setProperty("show_no_ui", "true");
        File serverFile = File.createTempFile("managera", "server");
        serverFile.deleteOnExit();
        PermissionsUtil.setRecursiveFullPermissions(serverFile.getAbsolutePath());
        File clientFile = File.createTempFile("managera", "client");
        clientFile.deleteOnExit();
        PermissionsUtil.setRecursiveFullPermissions(clientFile.getAbsolutePath());
        properties.setProperty(ManageService.PROPERTY_CHANNEL_SERVER, serverFile.getAbsolutePath());
        properties.setProperty(ManageService.PROPERTY_CHANNEL_CLIENT, clientFile.getAbsolutePath());
        System.out.println("[JWService] Forking manage remote access service virtual app");
        boolean elevate = true;
        if (GraphicsEnvironment.isHeadless() || GraphicsEnvironment.getLocalGraphicsEnvironment().isHeadlessInstance()) {
            elevate = false;
        }
        JWSystem.forkVirtualApp("JWrapper Service Management App", properties, null, elevate, false);
        System.out.println("[JWService] Opening communication channel as server");
        MappedChannel openAsServer = MappedChannel.openAsServer(serverFile, clientFile, 30000L);
        System.out.println("[JWService] Initialising message handler");
        new MFMessageHandler(openAsServer, handler);
    }

    public static String getDefaultServiceName() {
        if (JWSystem.getMyAppName() != null) {
            return JWSystem.getMyAppName();
        }
        return JWSystem.getAppBundleName();
    }

    public static void setServiceRestartOnFailure(String serviceName, boolean on, boolean neverGiveUp) {
        if (OS.isWindows()) {
            if (on) {
                byte[] dat = new byte[]{-128, 81, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 20, 0, 0, 0, 1, 0, 0, 0, 96, -22, 0, 0, 1, 0, 0, 0, 96, -22, 0, 0, (byte)(neverGiveUp ? 1 : 0), 0, 0, 0, 0, 0, 0, 0};
                try {
                    JWWindowsRegistry.regSetBinary("HKEY_LOCAL_MACHINE", "SYSTEM\\CurrentControlSet\\services\\" + serviceName, "FailureActions", dat, "REG_BINARY");
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            } else {
                try {
                    JWWindowsRegistry.deleteKey("HKEY_LOCAL_MACHINE", "SYSTEM\\CurrentControlSet\\services", serviceName);
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        }
    }

    public static class ServiceManagementException
    extends Exception {
        public ServiceManagementException(String reason) {
            super(reason);
        }
    }

    public static class ServiceMessageHandler
    implements MessageHandler {
        private Object lock;
        public boolean serviceInstallUninstallResult = false;
        public ServiceManagementException error = null;

        public ServiceMessageHandler(Object lock) {
            this.lock = lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message m) {
            switch (m.getType()) {
                case 655361: {
                    Object object = this.lock;
                    synchronized (object) {
                        this.serviceInstallUninstallResult = true;
                        this.lock.notify();
                        break;
                    }
                }
                case 655362: {
                    String message = m.getAsString(0);
                    String details = m.getAsString(1);
                    this.error = new ServiceManagementException(message + " (" + details + ")");
                    Object object = this.lock;
                    synchronized (object) {
                        this.serviceInstallUninstallResult = false;
                        this.lock.notify();
                        break;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void closed() {
            Object object = this.lock;
            synchronized (object) {
                System.out.println("[ServiceMessageHandler] Closing channel");
                this.serviceInstallUninstallResult = false;
                this.lock.notify();
            }
        }
    }
}

