/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.crypt;

import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.HashMap;

public class JWCrypt_TA {
    private static Instrumentation STATIC;
    static boolean DEBUG;
    private static final HashMap processors;
    public static Processor processor;

    public static Instrumentation getINST() {
        return STATIC;
    }

    public static void premain(String args, Instrumentation instrumentation) throws IOException {
        STATIC = instrumentation;
        if (DEBUG) {
            System.out.println("JWC_TA started");
        }
        instrumentation.addTransformer(new JWCTransformer());
    }

    public static void addProcessor(String path, Processor proc) {
        processor = proc;
        if (DEBUG) {
            System.out.println("[JWC TA] Processor " + path);
        }
    }

    public static String condense(String path) {
        if (path.startsWith("file:/")) {
            path = path.substring(6);
        }
        StringBuffer sb = new StringBuffer();
        char[] cs = path.toCharArray();
        for (int i = 0; i < cs.length; ++i) {
            if (!Character.isLetterOrDigit(cs[i])) continue;
            sb.append(cs[i]);
        }
        return sb.toString();
    }

    static {
        DEBUG = false;
        processors = new HashMap();
    }

    public static final class JWCTransformer
    implements ClassFileTransformer {
        public byte[] transform(ClassLoader loader, String className, Class classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
            String loc = "" + protectionDomain.getCodeSource().getLocation();
            if (processor == null) {
                if (DEBUG) {
                    System.out.println("[JWC TA] Asked to transform " + className + " size " + classfileBuffer.length + ", no processor set yet (" + loc + ")");
                }
                for (int i = 0; i < 8; ++i) {
                    System.out.print(Integer.toHexString(0xFF & classfileBuffer[i]));
                }
                System.out.println();
                return null;
            }
            if (DEBUG) {
                System.out.println("[JWC TA] Asked to transform " + className + " size " + classfileBuffer.length + " using " + processor + " (" + loc + ")");
            }
            byte[] dat = processor.process(classfileBuffer);
            if (DEBUG) {
                System.out.println("[JWC TA] Returning " + className + " / " + dat);
            }
            return dat;
        }
    }

    public static interface Processor {
        public byte[] process(byte[] var1);
    }
}

