/*
 * Decompiled with CFR 0.152.
 */
package jwrapper;

import java.util.LinkedList;
import jwrapper.hidden.JWNativeAPI;
import jwrapper.jwutils.JWSystem;
import jwrapper.updater.GenericUpdater;

public class AsyncAuxDownloader {
    private static final Object LOCK = new Object();
    private static LinkedList<AbstractAuxDownloader> downloaders = new LinkedList();
    private static OSArchiveDownloader osArchiveDownloader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startAuxiliaryArchiveFetch(String auxiliaryArchiveName) {
        if (auxiliaryArchiveName == null) {
            return;
        }
        Object object = LOCK;
        synchronized (object) {
            AbstractAuxDownloader existingDownloader = AsyncAuxDownloader.getDownloaderFor(auxiliaryArchiveName);
            if (existingDownloader == null) {
                existingDownloader = new AuxiliaryDownloader(auxiliaryArchiveName);
                downloaders.add(existingDownloader);
                AsyncAuxDownloader.startOSArchiveFetch();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startOSArchiveFetch() {
        Object object = LOCK;
        synchronized (object) {
            if (!JWNativeAPI.isLoaded()) {
                System.out.println("[AsyncAuxDownloader] Starting OS archive downloader");
                if (osArchiveDownloader == null) {
                    osArchiveDownloader = new OSArchiveDownloader();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void blockUntilDownloaderFinishes(String auxiliaryArchiveName) throws NoSuchDownloaderException {
        if (auxiliaryArchiveName == null) {
            return;
        }
        Object object = LOCK;
        synchronized (object) {
            AbstractAuxDownloader existingDownloader = AsyncAuxDownloader.getDownloaderFor(auxiliaryArchiveName);
            if (existingDownloader == null) {
                throw new NoSuchDownloaderException("No downloader for '" + auxiliaryArchiveName + "' found");
            }
            while (!existingDownloader.finished) {
                try {
                    LOCK.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (osArchiveDownloader != null) {
                System.out.println("[AsyncAuxDownloader] Waiting for OS archive downloader to complete");
                while (!AsyncAuxDownloader.osArchiveDownloader.finished) {
                    try {
                        LOCK.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    private static AbstractAuxDownloader getDownloaderFor(String auxiliaryArchiveName) {
        for (AbstractAuxDownloader downloader : downloaders) {
            if (!(downloader instanceof AuxiliaryDownloader) || !((AuxiliaryDownloader)downloader).auxiliaryArchiveName.equals(auxiliaryArchiveName)) continue;
            return downloader;
        }
        return null;
    }

    static abstract class AbstractAuxDownloader
    extends Thread {
        private Exception error = null;
        protected boolean finished = false;

        protected abstract void doWork() throws Exception;

        public AbstractAuxDownloader(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.doWork();
            }
            catch (Exception t) {
                this.error = t;
                t.printStackTrace();
            }
            finally {
                this.finished = true;
                Object object = LOCK;
                synchronized (object) {
                    LOCK.notifyAll();
                }
            }
        }
    }

    static final class AuxiliaryDownloader
    extends AbstractAuxDownloader {
        private final String auxiliaryArchiveName;

        public AuxiliaryDownloader(String auxiliaryArchiveName) {
            super("AuxiliaryDownloader-" + auxiliaryArchiveName);
            this.auxiliaryArchiveName = auxiliaryArchiveName;
            this.start();
        }

        @Override
        protected void doWork() throws Exception {
            GenericUpdater.fetchAuxiliaryArchive(this.auxiliaryArchiveName, false);
        }
    }

    public static class NoSuchDownloaderException
    extends Exception {
        private NoSuchDownloaderException(String msg) {
            super(msg);
        }
    }

    static final class OSArchiveDownloader
    extends AbstractAuxDownloader {
        public OSArchiveDownloader() {
            super("OSArchiveDownloader");
            this.start();
        }

        @Override
        protected void doWork() throws Exception {
            if (!JWNativeAPI.isLoaded()) {
                GenericUpdater.fetchOsArchive(JWSystem.getAppFolder());
                JWNativeAPI.loadLibrary();
            }
        }
    }
}

