/*
 * Decompiled with CFR 0.152.
 */
package com.simplehelp.windows;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import utils.ostools.OS;
import utils.progtools.ProcessPrinter;

public class WindowsServiceManager {
    private File simpleService;
    private String lineSeparator;

    public WindowsServiceManager(File simpleService) {
        this.simpleService = simpleService;
        this.lineSeparator = System.getProperty("line.separator");
    }

    public void installService(File dotServiceFile) throws IOException, InterruptedException {
        Process exec = Runtime.getRuntime().exec(new String[]{this.simpleService.getAbsolutePath(), "-install", dotServiceFile.getAbsolutePath()});
        new ProcessPrinter(exec, System.out, System.err);
        exec.waitFor();
    }

    public void removeService(File dotServiceFile) throws IOException, InterruptedException {
        Process exec = Runtime.getRuntime().exec(new String[]{this.simpleService.getAbsolutePath(), "-uninstall", dotServiceFile.getAbsolutePath()});
        new ProcessPrinter(exec, System.out, System.err);
        exec.waitFor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDotServiceFile(File dotServiceFile, String serviceName, String description, File workingDir, String exec, File stopWorkingDir, String stopExec, boolean autoRestart, boolean runOnce, File livenessFile) throws IOException {
        StringBuilder configuration = new StringBuilder();
        configuration.append("NAME:").append(serviceName).append(this.lineSeparator);
        configuration.append("DISPLAYNAME:").append(serviceName).append(this.lineSeparator);
        configuration.append("DESCRIPTION:").append(description).append(this.lineSeparator);
        configuration.append("WORKINGDIR:").append(workingDir).append(this.lineSeparator);
        configuration.append("CMDLINE:").append(exec).append(this.lineSeparator);
        configuration.append("STOP_WORKINGDIR:").append(stopWorkingDir).append(this.lineSeparator);
        if (stopExec != null) {
            configuration.append("STOP_CMDLINE:").append(stopExec).append(this.lineSeparator);
        }
        if (livenessFile != null) {
            try {
                String absolutePath = livenessFile.getCanonicalFile().getAbsolutePath();
                configuration.append("LIVENESS_FILE:").append(absolutePath).append(this.lineSeparator);
            }
            catch (IOException t) {
                System.out.println("[WindowsServiceManager] WARNING: Unable to resolve path to livenss file!");
                t.printStackTrace();
            }
        }
        if (autoRestart) {
            configuration.append("AUTORESTART:yes").append(this.lineSeparator);
        } else {
            configuration.append("AUTORESTART:no").append(this.lineSeparator);
        }
        if (OS.isWindows7OrAbove()) {
            configuration.append("INTERACTIVE:no").append(this.lineSeparator);
        } else {
            configuration.append("INTERACTIVE:yes").append(this.lineSeparator);
        }
        if (runOnce) {
            configuration.append("RUNONCE:yes").append(this.lineSeparator);
        } else {
            configuration.append("RUNONCE:no").append(this.lineSeparator);
        }
        try (FileOutputStream fout = new FileOutputStream(dotServiceFile);){
            fout.write(configuration.toString().getBytes(StandardCharsets.US_ASCII));
        }
    }
}

