/*
 * Decompiled with CFR 0.152.
 */
package com.simplehelp.macos;

import com.simplehelp.macos.PListCreator;
import com.simplehelp.macos.uid.UidSetterUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import utils.ostools.OS;
import utils.ostools.RunCommandGetOutput;
import utils.progtools.ProcessPrinter;
import utils.string.CharStack;

public class MacOSServiceManager {
    public static final String AGENTS_LOCATION = "/Library/LaunchAgents";
    public static final String DAEMONS_LOCATION = "/Library/LaunchDaemons";
    public static final String SESSION_TYPE_AQUA = "Aqua";
    public static final String SESSION_TYPE_LOGIN = "LoginWindow";

    public static String[] getAllConsoleUsers() {
        String output = RunCommandGetOutput.runCommandGetOutput(new String[]{"w", "-h"})[0];
        String[] lines = output.split("\n");
        ArrayList<String> users = new ArrayList<String>();
        for (int i = 0; i < lines.length; ++i) {
            CharStack cs = new CharStack(lines[i]);
            cs.popWhitespace();
            String user = cs.popText(true);
            cs.popWhitespace();
            String console = cs.popText(true);
            if (console.toLowerCase().startsWith("console")) {
                System.out.println("[MacOSServiceManager] Console user is " + user);
                users.add(user);
                continue;
            }
            System.out.println("[MacOSServiceManager] Not using console: " + lines[i]);
        }
        String[] all = new String[users.size()];
        users.toArray(all);
        return all;
    }

    private static int getUid(String username) throws IOException, InterruptedException {
        String[] pairs;
        Process p = Runtime.getRuntime().exec(new String[]{"id", username});
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        new ProcessPrinter(p, bout, System.out);
        p.waitFor();
        byte[] barray = bout.toByteArray();
        String s = new String(barray);
        for (String pair : pairs = s.split(" ")) {
            if (!pair.startsWith("uid=")) continue;
            int bracket = (pair = pair.substring("uid=".length())).indexOf(40);
            if (bracket != -1) {
                return Integer.parseInt(pair.substring(0, bracket));
            }
            return Integer.parseInt(pair);
        }
        return 0;
    }

    private static int getPid(String username) throws IOException, InterruptedException {
        Process p = Runtime.getRuntime().exec("ps -axo user,pid,command");
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        new ProcessPrinter(p, bout, System.out);
        p.waitFor();
        byte[] barray = bout.toByteArray();
        String s = new String(barray);
        String[] lines = s.split("\\n");
        ArrayList<PidOption> options = new ArrayList<PidOption>();
        for (int i = 0; i < lines.length; ++i) {
            if (!lines[i].trim().startsWith(username + " ")) continue;
            try {
                String line = lines[i];
                int firstSpace = line.indexOf(32);
                String lineWithNoUsername = line.substring(firstSpace).trim();
                int secondSpace = lineWithNoUsername.indexOf(32);
                int pid = Integer.parseInt(lineWithNoUsername.substring(0, secondSpace).trim());
                String command = lineWithNoUsername.substring(secondSpace).trim();
                if (command.endsWith("/launchd")) continue;
                PidOption option = new PidOption();
                option.pid = pid;
                option.command = command;
                options.add(option);
                continue;
            }
            catch (Throwable t) {
                System.out.println("[MacOSServiceManager] Skipping " + lines[i] + ": " + t.getMessage() + " [" + t.getClass().getName() + "]");
            }
        }
        String[] preferredOptions = new String[]{"/loginwindow", "/pboard", "/distnoted agent"};
        for (int option = 0; option < preferredOptions.length; ++option) {
            for (int i = 0; i < options.size(); ++i) {
                PidOption pidOption = (PidOption)options.get(i);
                if (!pidOption.command.endsWith(preferredOptions[option])) continue;
                return pidOption.pid;
            }
        }
        return ((PidOption)options.get((int)(options.size() - 1))).pid;
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        System.out.println(MacOSServiceManager.getUid("gchristelis"));
        System.out.println(MacOSServiceManager.getPid("gchristelis"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int runLaunchCtlCommandForAllConsoleUsers(String[] command) throws IOException, InterruptedException {
        int nonzero = 0;
        String[] users = MacOSServiceManager.getAllConsoleUsers();
        File uidSetter = UidSetterUtil.getUidSetter();
        try {
            for (int i = 0; i < users.length; ++i) {
                String[] ucmd = new String[command.length + 8];
                int index = 0;
                ucmd[index++] = uidSetter.getAbsolutePath();
                ucmd[index++] = "launchctl";
                if (OS.isMacOS_10_11_OrLater()) {
                    int uid = MacOSServiceManager.getUid(users[i]);
                    ucmd[index++] = "asuser";
                    ucmd[index++] = "" + uid;
                } else {
                    int pid = MacOSServiceManager.getPid(users[i]);
                    ucmd[index++] = "bsexec";
                    ucmd[index++] = "" + pid;
                }
                ucmd[index++] = "sudo";
                ucmd[index++] = "-S";
                ucmd[index++] = "-u";
                ucmd[index++] = users[i];
                System.arraycopy(command, 0, ucmd, 8, command.length);
                int ret = MacOSServiceManager.runCommand(ucmd);
                if (ret == 0) continue;
                nonzero = ret;
            }
        }
        finally {
            if (uidSetter != null) {
                uidSetter.delete();
            }
        }
        return nonzero;
    }

    private static int runCommand(String[] command) throws IOException, InterruptedException {
        System.out.println("[MacOSServiceManager] Running command " + Arrays.toString(command));
        Process p = Runtime.getRuntime().exec(command);
        new ProcessPrinter(p, System.out, System.err);
        return p.waitFor();
    }

    private static File install(String fullyQualifiedName, String[] command, File workingDir, String[] sessionType, boolean isDaemon, PrintStream printStream, boolean abandonProcessGroup) throws Exception {
        String plist = PListCreator.getPList(fullyQualifiedName, null, command, true, workingDir.getAbsolutePath(), sessionType, abandonProcessGroup);
        if (isDaemon) {
            printStream.println("[ServiceManager] Writing Launch Daemon");
        } else {
            printStream.println("[ServiceManager] Writing Launch Agent");
        }
        File outFile = isDaemon ? new File(DAEMONS_LOCATION + File.separator + fullyQualifiedName + ".plist") : new File(AGENTS_LOCATION + File.separator + fullyQualifiedName + ".plist");
        FileOutputStream fout = new FileOutputStream(outFile);
        fout.write(plist.getBytes(StandardCharsets.UTF_8));
        fout.close();
        MacOSServiceManager.runCommand(new String[]{"chmod", "644", outFile.getAbsolutePath()});
        return outFile;
    }

    public static File installAgent(String fullyQualifiedName, String[] command, File workingDir, String[] sessionType, PrintStream printStream, boolean abandonProcessGroup) throws Exception {
        return MacOSServiceManager.install(fullyQualifiedName, command, workingDir, sessionType, false, printStream, abandonProcessGroup);
    }

    public static File installDaemon(String fullyQualifiedName, String[] command, File workingDir, String[] sessionType, PrintStream printStream) throws Exception {
        return MacOSServiceManager.install(fullyQualifiedName, command, workingDir, sessionType, true, printStream, false);
    }

    public static void removeAgent(String fullyQualifiedName, PrintStream printStream) {
        File plistPath = new File("/Library/LaunchAgents/" + fullyQualifiedName + ".plist");
        if (plistPath.exists()) {
            try {
                MacOSServiceManager.unloadAgent(fullyQualifiedName, printStream);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            plistPath.delete();
        }
    }

    public static void unloadAgent(String fullyQualifiedName, PrintStream printStream) throws Exception {
        File plist = new File("/Library/LaunchAgents/" + fullyQualifiedName + ".plist");
        printStream.println("[ServiceManager] Unloading previous agent.");
        MacOSServiceManager.runLaunchCtlCommandForAllConsoleUsers(new String[]{"launchctl", "unload", "-F", "-S", SESSION_TYPE_AQUA, plist.getAbsolutePath()});
    }

    public static void loadAgent(String fullyQualifiedName, PrintStream printStream) throws Exception {
        try {
            MacOSServiceManager.unloadAgent(fullyQualifiedName, printStream);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        printStream.println("[ServiceManager] Loading new agent.");
        File plist = new File("/Library/LaunchAgents/" + fullyQualifiedName + ".plist");
        MacOSServiceManager.runLaunchCtlCommandForAllConsoleUsers(new String[]{"launchctl", "load", "-F", "-S", SESSION_TYPE_AQUA, plist.getAbsolutePath()});
    }

    public static void removeDaemon(String fullyQualifiedName, PrintStream printStream) throws Exception {
        File plist = new File("/Library/LaunchDaemons/" + fullyQualifiedName + ".plist");
        if (plist.exists()) {
            try {
                MacOSServiceManager.unloadDaemon(fullyQualifiedName, printStream);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            plist.delete();
        }
    }

    public static void unloadDaemon(String fullyQualifiedName, PrintStream printStream) throws Exception {
        printStream.println("[ServiceManager] Unloading previous daemon.");
        File plist = new File("/Library/LaunchDaemons/" + fullyQualifiedName + ".plist");
        MacOSServiceManager.runCommand(new String[]{"launchctl", "unload", "-F", plist.getAbsolutePath()});
    }

    public static void loadDaemon(String fullyQualifiedName, PrintStream printStream) throws Exception {
        try {
            MacOSServiceManager.unloadDaemon(fullyQualifiedName, printStream);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        printStream.println("[ServiceManager] Loading new daemon.");
        File plist = new File("/Library/LaunchDaemons/" + fullyQualifiedName + ".plist");
        MacOSServiceManager.runCommand(new String[]{"launchctl", "load", "-F", plist.getAbsolutePath()});
    }

    static class PidOption {
        int pid;
        String command;

        PidOption() {
        }
    }
}

