/*
 * Decompiled with CFR 0.152.
 */
package bcutil;

import org.bouncycastle.crypto.Digest;

public class MultiDigest
implements Digest {
    private Digest digest1;
    private Digest digest2;

    public MultiDigest(Digest digest1, Digest digest2) {
        this.digest1 = digest1;
        this.digest2 = digest2;
    }

    @Override
    public String getAlgorithmName() {
        return this.digest1 + "and" + this.digest2;
    }

    @Override
    public int getDigestSize() {
        return this.digest1.getDigestSize() + this.digest2.getDigestSize();
    }

    @Override
    public void update(byte in) {
        this.digest1.update(in);
        this.digest2.update(in);
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        this.digest1.update(in, inOff, len);
        this.digest2.update(in, inOff, len);
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        byte[] res = new byte[this.getDigestSize()];
        this.digest1.doFinal(res, 0);
        this.digest2.doFinal(res, this.digest1.getDigestSize());
        System.arraycopy(res, 0, out, outOff, res.length);
        this.reset();
        return res.length;
    }

    @Override
    public void reset() {
        this.digest1.reset();
        this.digest2.reset();
    }
}

