/*
 * Decompiled with CFR 0.152.
 */
package bcutil;

import bcutil.BCUtilHandshakeMessenger;
import bcutil.BCUtilImageDumper;
import bcutil.MultiDigest;
import bcutil.SICBlockCipherDTLS;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.concurrent.Semaphore;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA3Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.digests.ShortenedDigest;
import org.bouncycastle.crypto.encodings.OAEPEncoding;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.engines.RSABlindedEngine;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.signers.PSSSigner;
import org.bouncycastle.crypto.util.SubjectPublicKeyInfoFactory;
import org.bouncycastle.util.Arrays;
import utils.stream.ByteArrayUtils;
import utils.stream.OpenByteArrayOutputStream;
import utils.string.Base64;
import utils.string.HexData;
import utils.switches.Switches;

public class BCUtil {
    public static boolean CACHE_ENCODING_BUFFERS = true;
    public static boolean DEBUG_TIMING = false;
    public static boolean DEBUG = false;
    public static boolean DEBUG_IMAGE = false;
    public static boolean SHOW_OVERHEAD = false;
    public static BCUtilImageDumper DEBUG_IMAGE_DUMPER = null;
    public static int RSA_BITS = 4096;
    boolean failedDuringRsaCheck = false;
    boolean validHashRequired = true;
    int protocolVersion = -1135280127;
    static boolean cpuBounding = true;
    static Semaphore cpu_bound_SEM = new Semaphore(Math.max(1, Runtime.getRuntime().availableProcessors() / 2), true);
    static final Object sr_LOCK = new Object();
    static SecureRandom sr;
    byte[] encIv;
    byte[] encKey;
    byte[] encMac;
    BlockCipher block;
    SICBlockCipherDTLS encCipher;
    SICBlockCipherDTLS decCipher;
    Object wrap_LOCK = new Object();
    Object unwrap_LOCK = new Object();
    boolean handshakeComplete = false;
    boolean hadToRecover = false;
    byte[] decIv;
    byte[] decKey;
    byte[] decMac;
    HMac encHmac;
    HMac decHmac;
    int blockSize;
    int macSize = 32;
    AsymmetricCipherKeyPair serverRsaKeys;
    PublicKeyHashProvider clientPublicKeyAuthHashProvider;
    String savedPublicKeyAuthHash;
    String clientRecoveryUniqueID;
    String clientRecoveryUniqueKey;
    byte[] serverGlobalRecoveryKey;
    static final String recoverySalt = "ugxxxxi5dyzGePZfBoySaw1CtZmpHp8vJMRdZqxfEfT0bfthH7vdSabPG2G0Mhth0XffW1YE8rTwm3daqTmNDI9gxiAPNPECs3Pe";
    byte[] encHashID;
    byte[] decHashID;
    byte[] encMacBuf = new byte[this.macSize];
    byte[] decMacBuf = new byte[this.macSize];
    byte[] verMacBuf = new byte[this.macSize];
    OpenByteArrayOutputStream cachedBout;
    DataOutputStream cachedDout;
    long plain;
    long encrypted;
    long nextPrint = System.currentTimeMillis() + 5000L;
    public static final int WORK_1s = 80000;
    public static final int WORK_50ms = 4000;
    public static final int WORK_10ms = 800;
    public static final int WORK_2ms = 200;
    public static final int WORK_1ms = 100;
    public static final int WORK_0ms = 1;
    private static final String[] RANDOM_KEY_HASHES;

    public static void removeCpuBounding() {
        cpuBounding = false;
    }

    public boolean didClientFailDuringPubkeyCheck() {
        return this.failedDuringRsaCheck;
    }

    public void setValidHashRequired(boolean b) {
        this.validHashRequired = b;
    }

    public boolean wasValidHashRequired() {
        return this.validHashRequired;
    }

    public boolean wasRecoveryRequired() {
        return this.hadToRecover;
    }

    private byte[] clientEncryptRecovery(byte[] plaintext) throws IOException {
        BCUtil bcu = new BCUtil();
        return BCUtil.encryptWithSecret(plaintext, recoverySalt, this.clientRecoveryUniqueKey, 200);
    }

    private byte[] clientDecryptRecovery(byte[] encrypted) throws IOException {
        BCUtil bcu = new BCUtil();
        return BCUtil.decryptWithSecret(encrypted, recoverySalt, this.clientRecoveryUniqueKey, 200);
    }

    private byte[] serverDecryptRecovery(String clientID, byte[] encrypted) throws IOException {
        String clientRecoveryKey = this.buildClientRecoveryKeyFrom(clientID);
        if (clientRecoveryKey == null) {
            throw new IOException("Unable to decrypt, client (and therefore global) recovery key is null");
        }
        BCUtil bcu = new BCUtil();
        return BCUtil.decryptWithSecret(encrypted, recoverySalt, clientRecoveryKey, 200);
    }

    private byte[] serverEncryptRecovery(String clientID, byte[] plaintext) throws IOException {
        String clientRecoveryKey = this.buildClientRecoveryKeyFrom(clientID);
        if (clientRecoveryKey == null) {
            throw new IOException("Unable to decrypt, client (and therefore global) recovery key is null");
        }
        BCUtil bcu = new BCUtil();
        return BCUtil.encryptWithSecret(plaintext, recoverySalt, clientRecoveryKey, 200);
    }

    public byte[][] getIdentifyingHash() {
        if (this.encHashID == null) {
            int i;
            ShortenedDigest digest = new ShortenedDigest(new SHA512Digest(), 6);
            for (i = 0; i < this.encKey.length; ++i) {
                digest.update(this.encKey[i]);
            }
            for (i = 0; i < this.encMac.length; ++i) {
                digest.update(this.encMac[i]);
            }
            byte[] encHash = new byte[digest.getDigestSize()];
            digest.doFinal(encHash, 0);
            digest = new ShortenedDigest(new SHA512Digest(), 6);
            for (i = 0; i < this.decKey.length; ++i) {
                digest.update(this.decKey[i]);
            }
            for (i = 0; i < this.decMac.length; ++i) {
                digest.update(this.decMac[i]);
            }
            byte[] decHash = new byte[digest.getDigestSize()];
            digest.doFinal(decHash, 0);
            this.encHashID = encHash;
            this.decHashID = decHash;
        }
        return new byte[][]{this.encHashID, this.decHashID};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BCUtil() {
        Object object = sr_LOCK;
        synchronized (object) {
            if (sr == null) {
                sr = new SecureRandom();
            }
        }
        this.block = new AESFastEngine();
        this.blockSize = this.block.getBlockSize();
        this.encIv = new byte[this.blockSize];
        this.encKey = new byte[this.blockSize];
        this.encMac = new byte[this.blockSize];
        this.decIv = new byte[this.blockSize];
        this.decKey = new byte[this.blockSize];
        this.decMac = new byte[this.blockSize];
    }

    public String getSavedPublicKeyAuthHash() {
        return this.savedPublicKeyAuthHash;
    }

    private SICBlockCipherDTLS getCipherForRandom(boolean encrypt, byte[] passwordRandom) throws IOException {
        if (passwordRandom.length < this.blockSize / 2) {
            throw new IOException("Password too short");
        }
        byte[] keystoreKey = new byte[this.blockSize];
        for (int i = 0; i < this.blockSize; ++i) {
            int n = i;
            keystoreKey[n] = (byte)(keystoreKey[n] ^ passwordRandom[i]);
        }
        byte[] keystoreIV = new byte[this.blockSize];
        for (int i = 0; i < this.blockSize; ++i) {
            int n = i;
            keystoreIV[n] = (byte)(keystoreIV[n] ^ passwordRandom[this.blockSize + i]);
        }
        ParametersWithIV keystoreKeyAndIV = new ParametersWithIV(new KeyParameter(keystoreKey), keystoreIV);
        SICBlockCipherDTLS keystoreEnc = new SICBlockCipherDTLS(new AESFastEngine());
        keystoreEnc.init(encrypt, keystoreKeyAndIV);
        return keystoreEnc;
    }

    public byte[] writeToBytes() throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.writeBCUtil(bout);
        return bout.toByteArray();
    }

    public void readFromBytes(byte[] dat) throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(dat);
        this.readBCUtil(bin);
    }

    public BCUtil clone() {
        OpenByteArrayOutputStream bout = new OpenByteArrayOutputStream();
        try {
            this.writeBCUtil(bout);
            BCUtil cloned = new BCUtil();
            cloned.readBCUtil(new ByteArrayInputStream(bout.getByteArray()));
            cloned.randomiseCounter();
            return cloned;
        }
        catch (Exception x) {
            x.printStackTrace();
            return null;
        }
    }

    public void writeBCUtil(OutputStream out) throws IOException {
        DataOutputStream dout = new DataOutputStream(out);
        dout.writeInt(this.protocolVersion);
        dout.writeInt(this.encIv.length);
        dout.write(this.encIv);
        dout.writeInt(this.encMac.length);
        dout.write(this.encMac);
        dout.writeInt(this.encKey.length);
        dout.write(this.encKey);
        dout.writeInt(this.decIv.length);
        dout.write(this.decIv);
        dout.writeInt(this.decMac.length);
        dout.write(this.decMac);
        dout.writeInt(this.decKey.length);
        dout.write(this.decKey);
        byte[] counter = this.encCipher.getCounter();
        dout.writeInt(counter.length);
        dout.write(counter);
        dout.flush();
    }

    private byte[] safeReadByteArray(DataInputStream din, int max) throws IOException {
        int size = din.readInt();
        if (size > max) {
            throw new IOException("Attempting to load a corrupt BCUtil (size: " + size + " > " + max + ")");
        }
        if (size < 0) {
            throw new IOException("Attempting to load a corrupt BCUtil (size: " + size + ")");
        }
        byte[] data = new byte[size];
        din.readFully(data);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readBCUtil(InputStream in) throws IOException {
        try (DataInputStream din = new DataInputStream(in);){
            din.readInt();
            int max = 100000;
            this.encIv = this.safeReadByteArray(din, max);
            this.encMac = this.safeReadByteArray(din, max);
            this.encKey = this.safeReadByteArray(din, max);
            this.decIv = this.safeReadByteArray(din, max);
            this.decMac = this.safeReadByteArray(din, max);
            this.decKey = this.safeReadByteArray(din, max);
            byte[] byArray = this.safeReadByteArray(din, max);
        }
        this.initCiphersFromKeys();
        this.handshakeComplete = true;
    }

    public void randomiseCounter() {
        byte[] tmp = this.encCipher.getCounter();
        sr.nextBytes(tmp);
        this.encCipher.setCounter(tmp);
    }

    public void saveBCUtil(File bcUtilFile, byte[] passwordRandom) throws IOException {
        if (!this.handshakeComplete) {
            throw new IOException("BCUtil has not finished handshaking, cannot be saved");
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        this.writeBCUtil(bout);
        byte[] message = bout.toByteArray();
        SICBlockCipherDTLS cipher = this.getCipherForRandom(true, passwordRandom);
        for (int i = 0; i < message.length; i += this.blockSize) {
            cipher.processBlock(message, i, message, i);
        }
        FileOutputStream fout = new FileOutputStream(bcUtilFile);
        DataOutputStream dout = new DataOutputStream(fout);
        dout.writeInt(message.length);
        dout.write(message);
        fout.close();
    }

    public void loadBCUtil(File bcUtilFile, byte[] passwordRandom) throws IOException {
        FileInputStream fin = new FileInputStream(bcUtilFile);
        DataInputStream dfin = new DataInputStream(fin);
        byte[] message = new byte[dfin.readInt()];
        dfin.readFully(message);
        dfin.close();
        SICBlockCipherDTLS cipher = this.getCipherForRandom(true, passwordRandom);
        for (int i = 0; i < message.length; i += this.blockSize) {
            cipher.processBlock(message, i, message, i);
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(message);
        this.readBCUtil(bin);
        this.saveBCUtil(bcUtilFile, passwordRandom);
    }

    public void saveServerRsaKeys(AsymmetricCipherKeyPair rsakeys, File keysFile, byte[] passwordRandom) throws IOException {
        RSAKeyParameters privKey = (RSAKeyParameters)rsakeys.getPrivate();
        RSAKeyParameters pubKey = (RSAKeyParameters)rsakeys.getPublic();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        byte[] privDat = BCUtil.serialiseKey(privKey);
        byte[] pubDat = BCUtil.serialiseKey(pubKey);
        dout.writeInt(privDat.length);
        dout.write(privDat);
        dout.writeInt(pubDat.length);
        dout.write(pubDat);
        dout.flush();
        while (bout.size() % this.blockSize != 0) {
            dout.write(0);
        }
        dout.flush();
        byte[] message = bout.toByteArray();
        SICBlockCipherDTLS cipher = this.getCipherForRandom(true, passwordRandom);
        for (int i = 0; i < message.length; i += this.blockSize) {
            cipher.processBlock(message, i, message, i);
        }
        FileOutputStream fout = new FileOutputStream(keysFile);
        dout = new DataOutputStream(fout);
        dout.writeInt(message.length);
        dout.write(message);
        fout.close();
    }

    public AsymmetricCipherKeyPair loadServerRsaKeys(File keysFile, byte[] passwordRandom) throws IOException {
        FileInputStream fin = new FileInputStream(keysFile);
        DataInputStream dfin = new DataInputStream(fin);
        int size = dfin.readInt();
        if (size > 10000000) {
            throw new IOException("Not a valid keys file");
        }
        byte[] message = new byte[size];
        dfin.readFully(message);
        System.out.println("[BCUtil] Server keystore " + message.length);
        dfin.close();
        SICBlockCipherDTLS cipher = this.getCipherForRandom(true, passwordRandom);
        for (int i = 0; i < message.length; i += this.blockSize) {
            cipher.processBlock(message, i, message, i);
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(message);
        DataInputStream din = new DataInputStream(bin);
        byte[] privDat = new byte[din.readInt()];
        System.out.println("[BCUtil] Private key blen " + privDat.length);
        din.readFully(privDat);
        byte[] pubDat = new byte[din.readInt()];
        System.out.println("[BCUtil] Private key blen " + pubDat.length);
        din.readFully(pubDat);
        RSAKeyParameters privKey = BCUtil.deserialiseKey(true, privDat);
        RSAKeyParameters pubKey = BCUtil.deserialiseKey(false, pubDat);
        return new AsymmetricCipherKeyPair(pubKey, privKey);
    }

    public void setServerRsaKeyPair(AsymmetricCipherKeyPair rsakeys, byte[] recoveryKey) {
        this.serverRsaKeys = rsakeys;
        this.serverGlobalRecoveryKey = recoveryKey;
    }

    public void setClientRsaKeyPairHashNoRecovery(PublicKeyHashProvider hashProvider) {
        this.setClientRsaKeyPairHash(hashProvider, null, null);
    }

    public void setClientRsaKeyPairHash(PublicKeyHashProvider hashProvider, String uniqueID, String recoveryKey) {
        this.clientPublicKeyAuthHashProvider = hashProvider;
        this.clientRecoveryUniqueID = uniqueID;
        this.clientRecoveryUniqueKey = recoveryKey;
    }

    public String buildClientRecoveryKeyFrom(String uniqueID) throws IOException {
        if (this.serverGlobalRecoveryKey == null) {
            return null;
        }
        String s = "PLAIN:[" + uniqueID + "]SECRET:[" + HexData.byteArrayToHexString(this.serverGlobalRecoveryKey) + "]";
        byte[] dat = s.getBytes("UTF8");
        String hexKey = HexData.byteArrayToHexString(BCUtil.getSha256Sha3HashOf(dat));
        if (DEBUG) {
            System.out.println("[BCUtil] Built client recovery key for " + uniqueID + ": " + hexKey);
        }
        return hexKey;
    }

    public boolean canSendSecureData() {
        return this.handshakeComplete;
    }

    public static String getHashOfRsaPublicKey(AsymmetricCipherKeyPair keys) {
        RSAKeyParameters publicKey = (RSAKeyParameters)keys.getPublic();
        return BCUtil.getHashOfRsaPublicKey(publicKey);
    }

    public static RSAKeyParameters deserialiseKey(boolean isPrivate, byte[] dat) throws IOException {
        ByteArrayInputStream bin = new ByteArrayInputStream(dat);
        DataInputStream din = new DataInputStream(bin);
        int len = din.readInt();
        byte[] tmp = new byte[len];
        din.readFully(tmp);
        BigInteger modulus = new BigInteger(tmp);
        len = din.readInt();
        tmp = new byte[len];
        din.readFully(tmp);
        BigInteger exponent = new BigInteger(tmp);
        RSAKeyParameters ret = new RSAKeyParameters(isPrivate, modulus, exponent);
        return ret;
    }

    public static byte[] serialiseKey(RSAKeyParameters publicKey) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        byte[] dat = publicKey.getModulus().toByteArray();
        dout.writeInt(dat.length);
        dout.write(dat);
        dat = publicKey.getExponent().toByteArray();
        dout.writeInt(dat.length);
        dout.write(dat);
        dout.flush();
        return bout.toByteArray();
    }

    public static long getSha256of(long dat) {
        byte[] tmp = new byte[8];
        ByteArrayUtils.writeLong(tmp, 0, dat);
        return BCUtil.getPartialSha256of(tmp);
    }

    public static long getPartialSha256of(byte[] dat) {
        byte[] tmp = BCUtil.getSha256of(dat);
        return (long)(tmp[0] & 0xFF) << 56 | (long)(tmp[1] & 0xFF) << 48 | (long)(tmp[2] & 0xFF) << 40 | (long)(tmp[3] & 0xFF) << 32 | (long)(tmp[4] & 0xFF) << 24 | (long)(tmp[5] & 0xFF) << 16 | (long)(tmp[6] & 0xFF) << 8 | (long)(tmp[7] & 0xFF);
    }

    public static boolean hashesEqual(byte[] one, byte[] two) {
        if (one == null) {
            return false;
        }
        if (two == null) {
            return false;
        }
        if (one.length != two.length) {
            return false;
        }
        for (int i = 0; i < one.length; ++i) {
            if (one[i] == two[i]) continue;
            return false;
        }
        return true;
    }

    public static byte[] getSha256of(byte[] dat) {
        SHA256Digest digest1 = new SHA256Digest();
        for (int i = 0; i < dat.length; ++i) {
            digest1.update(dat[i]);
        }
        byte[] ret1 = new byte[digest1.getDigestSize()];
        digest1.doFinal(ret1, 0);
        return ret1;
    }

    public static byte[] getSha256of(File file) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
            byte[] byArray = BCUtil.getSha256of(in);
            return byArray;
        }
    }

    public static byte[] getSha256of(InputStream in) throws IOException {
        SHA256Digest digest1 = new SHA256Digest();
        byte[] buf = new byte[10000];
        int n = 0;
        while (n != -1) {
            n = in.read(buf);
            if (n <= 0) continue;
            digest1.update(buf, 0, n);
        }
        byte[] ret1 = new byte[digest1.getDigestSize()];
        digest1.doFinal(ret1, 0);
        return ret1;
    }

    public static byte[] getSha3of(byte[] dat) {
        SHA3Digest digest1 = new SHA3Digest();
        for (int i = 0; i < dat.length; ++i) {
            digest1.update(dat[i]);
        }
        byte[] ret1 = new byte[digest1.getDigestSize()];
        digest1.doFinal(ret1, 0);
        return ret1;
    }

    public static byte[] getSigHashOf(byte[] dat) {
        return BCUtil.getSha256Sha3HashOf(dat);
    }

    public static byte[] getSha256Sha3HashOf(byte[] dat) {
        SHA256Digest digest1 = new SHA256Digest();
        SHA3Digest digest2 = new SHA3Digest(256);
        if (digest1.getDigestSize() != digest2.getDigestSize()) {
            throw new Error("Paired digests do not match (size)");
        }
        for (int i = 0; i < dat.length; ++i) {
            digest1.update(dat[i]);
            digest2.update(dat[i]);
        }
        byte[] ret1 = new byte[digest1.getDigestSize()];
        digest1.doFinal(ret1, 0);
        byte[] ret2 = new byte[digest2.getDigestSize()];
        digest2.doFinal(ret2, 0);
        byte[] tmp = new byte[ret1.length + ret2.length];
        System.arraycopy(ret1, 0, tmp, 0, ret1.length);
        System.arraycopy(ret2, 0, tmp, ret1.length, ret2.length);
        return tmp;
    }

    public static RSAKeyParameters getPrivateKey(AsymmetricCipherKeyPair rsakeys) {
        RSAKeyParameters privKey = (RSAKeyParameters)rsakeys.getPrivate();
        return privKey;
    }

    public static RSAKeyParameters getPublicKey(AsymmetricCipherKeyPair rsakeys) {
        RSAKeyParameters pubKey = (RSAKeyParameters)rsakeys.getPublic();
        return pubKey;
    }

    public static byte[] createSignature(byte[] data, RSAKeyParameters privateKey) throws IOException {
        try {
            SHA256Digest d1 = new SHA256Digest();
            SHA3Digest d2 = new SHA3Digest(256);
            MultiDigest md = new MultiDigest(d1, d2);
            int saltLen = 64;
            PSSSigner signer = new PSSSigner(new RSABlindedEngine(), md, saltLen);
            signer.init(true, privateKey);
            signer.update(data, 0, data.length);
            byte[] sig = signer.generateSignature();
            return sig;
        }
        catch (Exception x) {
            IOException t = new IOException("Unable to sign file");
            t.initCause(x);
            throw t;
        }
    }

    public static boolean verifySignature(byte[] data, byte[] sig, RSAKeyParameters publicKey) {
        try {
            SHA256Digest d1 = new SHA256Digest();
            SHA3Digest d2 = new SHA3Digest(256);
            MultiDigest md = new MultiDigest(d1, d2);
            int saltLen = 64;
            PSSSigner signer = new PSSSigner(new RSABlindedEngine(), md, saltLen);
            signer.init(false, publicKey);
            signer.update(data, 0, data.length);
            return signer.verifySignature(sig);
        }
        catch (Exception x) {
            return false;
        }
    }

    public static PSSSigner initStreamSigner(RSAKeyParameters publicKey) {
        SHA256Digest d1 = new SHA256Digest();
        SHA3Digest d2 = new SHA3Digest(256);
        MultiDigest md = new MultiDigest(d1, d2);
        int saltLen = 64;
        PSSSigner signer = new PSSSigner(new RSABlindedEngine(), md, saltLen);
        signer.init(false, publicKey);
        return signer;
    }

    public static boolean finishStreamSigner(PSSSigner signer, byte[] signature) {
        try {
            return signer.verifySignature(signature);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static RSAKeyParameters getPublicKeyFromHex(String hex) {
        String[] hexes = hex.split("/");
        byte[] exp = HexData.hexStringToByteArray(hexes[0]);
        byte[] mod = HexData.hexStringToByteArray(hexes[1]);
        RSAKeyParameters rsaKey = new RSAKeyParameters(false, new BigInteger(mod), new BigInteger(exp));
        return rsaKey;
    }

    public static String getPublicKeyToHex(AsymmetricCipherKeyPair keys) {
        RSAKeyParameters publicKey = (RSAKeyParameters)keys.getPublic();
        return BCUtil.getHexOfRsaKey(publicKey);
    }

    public static String getSignatureToHex(byte[] sig) {
        return HexData.byteArrayToHexString(sig);
    }

    public static byte[] getSignatureFromHex(String hex) {
        return HexData.hexStringToByteArray(hex);
    }

    public static String getHexOfRsaKey(RSAKeyParameters publicKey) {
        byte[] exp = publicKey.getExponent().toByteArray();
        byte[] mod = publicKey.getModulus().toByteArray();
        return HexData.byteArrayToHexString(exp) + "/" + HexData.byteArrayToHexString(mod);
    }

    public static String getHexOfDEREncodedRSAKey(RSAKeyParameters publicKey) throws IOException {
        SubjectPublicKeyInfo publicKeyInfo = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(publicKey);
        byte[] serializedPublicBytes = publicKeyInfo.toASN1Primitive().getEncoded("DER");
        return HexData.byteArrayToHexString(serializedPublicBytes);
    }

    public static String getHashOfRsaPublicKey(RSAKeyParameters publicKey) {
        int i;
        ShortenedDigest digest1 = new ShortenedDigest(new SHA512Digest(), 32);
        SHA3Digest digest2 = new SHA3Digest(256);
        byte[] b1 = publicKey.getExponent().toByteArray();
        byte[] b2 = publicKey.getModulus().toByteArray();
        if (digest1.getDigestSize() != digest2.getDigestSize()) {
            throw new Error("Paired digests do not match (size)");
        }
        for (i = 0; i < b1.length; ++i) {
            digest1.update(b1[i]);
            digest2.update(b1[i]);
        }
        for (i = 0; i < b2.length; ++i) {
            digest1.update(b2[i]);
            digest2.update(b2[i]);
        }
        byte[] ret1 = new byte[digest1.getDigestSize()];
        digest1.doFinal(ret1, 0);
        byte[] ret2 = new byte[digest2.getDigestSize()];
        digest2.doFinal(ret2, 0);
        return String.format("%x%x", new BigInteger(1, ret1), new BigInteger(1, ret2));
    }

    public static long getNextAbsID() {
        return Math.abs(BCUtil.getSecureRandom().nextLong());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SecureRandom getSecureRandom() {
        Object object = sr_LOCK;
        synchronized (object) {
            if (sr == null) {
                sr = new SecureRandom();
            }
        }
        return sr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AsymmetricCipherKeyPair generateRsaKeyPair() {
        Object object = sr_LOCK;
        synchronized (object) {
            if (sr == null) {
                sr = new SecureRandom();
            }
            RSAKeyPairGenerator generator = new RSAKeyPairGenerator();
            generator.init(new RSAKeyGenerationParameters(new BigInteger("10001", 16), sr, RSA_BITS, 80));
            AsymmetricCipherKeyPair keyPair = generator.generateKeyPair();
            return keyPair;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handshake(InputStream in, OutputStream out, boolean client, BCUtilHandshakeMessenger msg) throws IOException, ServerAuthenticityException {
        int protocol;
        this.failedDuringRsaCheck = false;
        DataOutputStream dout = new DataOutputStream(out);
        DataInputStream din = new DataInputStream(in);
        dout.writeInt(this.protocolVersion);
        dout.flush();
        long T = System.currentTimeMillis();
        if (client && msg != null) {
            msg.clientSendAndReceive();
        }
        if (DEBUG_TIMING) {
            T = System.currentTimeMillis() - T;
            System.out.println("[BCUtil] Client get pubkey took " + T + "ms");
        }
        T = System.currentTimeMillis();
        if (!client && msg != null) {
            msg.serverReceive();
        }
        if (DEBUG_TIMING) {
            T = System.currentTimeMillis() - T;
            System.out.println("[BCUtil] Server get protocol took " + T + "ms");
        }
        if ((protocol = din.readInt()) != this.protocolVersion) {
            throw new IOException("Not a BCUtil connection");
        }
        long t = System.currentTimeMillis();
        if (DEBUG) {
            System.out.println("[BCUtil] New connection - RSA-4096 / AES-256 / SIC / SHA-512");
        }
        byte[] premaster = new byte[6 * this.blockSize];
        T = System.currentTimeMillis();
        Object object = sr_LOCK;
        synchronized (object) {
            if (sr == null) {
                sr = new SecureRandom();
            }
            sr.nextBytes(premaster);
        }
        if (DEBUG_TIMING) {
            T = System.currentTimeMillis() - T;
            System.out.println("[BCUtil] Premaster took " + T + "ms");
        }
        if (DEBUG) {
            System.out.println("[BCUtil] Generated random");
        }
        byte[] remoteRandom = new byte[premaster.length];
        if (client) {
            String receivedKeyHash;
            int pklen = din.readInt();
            byte[] pkdat = new byte[pklen];
            din.readFully(pkdat);
            RSAKeyParameters serverPublicKey = BCUtil.deserialiseKey(false, pkdat);
            if (DEBUG) {
                System.out.println("[BCUtil] Client read public key " + serverPublicKey.getModulus() + " / " + serverPublicKey.getExponent());
            }
            this.savedPublicKeyAuthHash = receivedKeyHash = BCUtil.getHashOfRsaPublicKey(serverPublicKey);
            int iterationsToDo = 100;
            boolean publicKeyIsValid = false;
            if (!this.validHashRequired) {
                publicKeyIsValid = true;
            }
            String clientPublicKeyAuthHash = null;
            if (this.clientPublicKeyAuthHashProvider != null) {
                for (String hash : this.clientPublicKeyAuthHashProvider) {
                    --iterationsToDo;
                    if (!hash.equals(receivedKeyHash)) continue;
                    clientPublicKeyAuthHash = hash;
                    publicKeyIsValid = true;
                }
            }
            boolean dummy = false;
            for (int i = 0; i < iterationsToDo; ++i) {
                String randomHash1 = RANDOM_KEY_HASHES[i % RANDOM_KEY_HASHES.length];
                String randomHash2 = RANDOM_KEY_HASHES[(i + 1) % RANDOM_KEY_HASHES.length];
                dummy = randomHash1.equals(randomHash2);
            }
            if (!publicKeyIsValid) {
                if (DEBUG) {
                    System.out.println("[BCUtil] Public key is not valid, authenticity is questionable");
                }
                boolean recoveredOK = false;
                if (DEBUG) {
                    System.out.println("[BCUtil] Client recovery: " + this.clientRecoveryUniqueID + " / " + this.clientRecoveryUniqueKey);
                }
                if (this.clientRecoveryUniqueKey != null && this.clientRecoveryUniqueID != null) {
                    byte[] responseEnc;
                    if (DEBUG) {
                        System.out.println("[BCUtil] RSA pubkey hash is wrong but we may be able to recover");
                    }
                    dout.writeInt(-99);
                    String random = sr.nextLong() + "" + sr.nextLong() + "" + sr.nextLong() + "" + sr.nextLong();
                    String challenge = "Recover1:" + random + "";
                    String expectedResponse = "PleaseRecover1:[" + random + "]PleaseRecover1:[" + random + "]";
                    if (DEBUG) {
                        System.out.println("[BCUtil] Sending challenge: " + challenge);
                    }
                    if (DEBUG) {
                        System.out.println("[BCUtil] Expecting response: " + expectedResponse);
                    }
                    byte[] challengeEnc = this.clientEncryptRecovery(challenge.getBytes("UTF8"));
                    dout.writeUTF(this.clientRecoveryUniqueID);
                    dout.writeUTF(Base64.byteArrayToBase64(challengeEnc));
                    if (client && msg != null) {
                        try {
                            msg.clientSendAndReceive();
                        }
                        catch (IOException x) {
                            throw new ServerAuthenticityException("Unable to verify server authenticity, recovery failed: " + x);
                        }
                    }
                    if ((responseEnc = Base64.base64ToByteArray(din.readUTF())).length == 0) {
                        throw new ServerAuthenticityException("Unable to verify server authenticity, recovery failed");
                    }
                    String response = new String(this.clientDecryptRecovery(responseEnc), "UTF8");
                    if (DEBUG) {
                        System.out.println("[BCUtil] Received (challenge) response: " + response);
                    }
                    if (response.equals(expectedResponse)) {
                        recoveredOK = true;
                        this.hadToRecover = true;
                    } else if (DEBUG) {
                        System.out.println("[BCUtil] Recovery FAILED, response did not match expected");
                    }
                } else if (DEBUG) {
                    System.out.println("[BCUtil] RSA pubkey hash is wrong and we may not recover");
                }
                if (!recoveredOK) {
                    throw new ServerAuthenticityException("Unable to verify server authenticity");
                }
                if (DEBUG) {
                    System.out.println("[BCUtil] Recovery OK, new pubkey hash is: " + receivedKeyHash);
                }
            } else if (DEBUG) {
                System.out.println("[BCUtil] Server hash is correct, " + receivedKeyHash + " == " + clientPublicKeyAuthHash);
            }
            if (DEBUG) {
                System.out.println("[BCUtil] Client RSA encrypting premaster:");
            }
            if (DEBUG) {
                BCUtil.print(premaster);
            }
            T = System.currentTimeMillis();
            OAEPEncoding encoding = new OAEPEncoding(new RSABlindedEngine());
            encoding.init(true, new ParametersWithRandom(serverPublicKey, sr));
            try {
                byte[] encPremaster = encoding.processBlock(premaster, 0, premaster.length);
                if (DEBUG_TIMING) {
                    T = System.currentTimeMillis() - T;
                    System.out.println("[BCUtil] Client encrypt premaster took " + T + "ms (" + dummy + ")");
                }
                if (DEBUG) {
                    System.out.println("[BCUtil] Client writing encrypted premaster:");
                }
                if (DEBUG) {
                    BCUtil.print(encPremaster);
                }
                dout.writeInt(encPremaster.length);
                dout.write(encPremaster);
                dout.flush();
            }
            catch (InvalidCipherTextException x) {
                throw new IOException("" + x);
            }
            if (msg != null) {
                msg.clientSendAndReceive();
            }
            din.readFully(remoteRandom);
            if (DEBUG) {
                System.out.println("[BCUtil] Client got server random");
            }
        } else {
            int encPremasterLen;
            RSAKeyParameters myPublicKey = (RSAKeyParameters)this.serverRsaKeys.getPublic();
            if (DEBUG) {
                System.out.println("[BCUtil] Server writing public key " + myPublicKey.getModulus() + " / " + myPublicKey.getExponent());
            }
            byte[] publicKeys = BCUtil.serialiseKey(myPublicKey);
            dout.writeInt(publicKeys.length);
            dout.write(publicKeys);
            dout.flush();
            T = System.currentTimeMillis();
            if (msg != null) {
                msg.serverRespond();
            }
            this.failedDuringRsaCheck = true;
            if (msg != null) {
                msg.serverReceive();
            }
            if (DEBUG_TIMING) {
                T = System.currentTimeMillis() - T;
                System.out.println("[BCUtil] Server pubkey send, premaster receive took " + T + "ms");
            }
            if ((encPremasterLen = din.readInt()) == -99) {
                String REC1;
                String clientID = din.readUTF();
                byte[] challengeEnc = Base64.base64ToByteArray(din.readUTF());
                String challenge = new String(this.serverDecryptRecovery(clientID, challengeEnc), "UTF8");
                if (DEBUG) {
                    System.out.println("[BCUtil] Server RSA keys did not match but received recovery challenge");
                }
                if (challenge.startsWith(REC1 = "Recover1:")) {
                    String random = challenge.substring(REC1.length());
                    if (DEBUG) {
                        System.out.println("[BCUtil] Client ID is " + clientID);
                    }
                    if (DEBUG) {
                        System.out.println("[BCUtil] Client recovery auth random is " + random);
                    }
                    String response = "PleaseRecover1:[" + random + "]PleaseRecover1:[" + random + "]";
                    if (DEBUG) {
                        System.out.println("[BCUtil] Response is " + response);
                    }
                    String responseEnc = Base64.byteArrayToBase64(this.serverEncryptRecovery(clientID, response.getBytes("UTF8")));
                    dout.writeUTF(responseEnc);
                    if (msg != null) {
                        msg.serverRespond();
                    }
                    if (msg != null) {
                        msg.serverReceive();
                    }
                    encPremasterLen = din.readInt();
                }
            }
            this.failedDuringRsaCheck = false;
            if (DEBUG) {
                System.out.println("[BCUtil] Server writing random");
            }
            dout.write(premaster);
            dout.flush();
            if (msg != null) {
                msg.serverRespond();
            }
            if (DEBUG) {
                System.out.println("[BCUtil] Server reading encrypted premaster:");
            }
            byte[] encPremaster = new byte[encPremasterLen];
            din.readFully(encPremaster);
            if (DEBUG) {
                BCUtil.print(encPremaster);
            }
            if (DEBUG) {
                System.out.println("[BCUtil] Server RSA decrypting premaster: ");
            }
            T = System.currentTimeMillis();
            try {
                if (cpuBounding) {
                    cpu_bound_SEM.acquire();
                }
            }
            catch (InterruptedException x) {
                throw new IOException("" + x);
            }
            try {
                if (DEBUG_TIMING) {
                    T = System.currentTimeMillis() - T;
                    System.out.println("[BCUtil] Server get CPU lock " + T + "ms");
                }
                OAEPEncoding encoding = new OAEPEncoding(new RSABlindedEngine());
                encoding.init(false, new ParametersWithRandom(this.serverRsaKeys.getPrivate(), sr));
                try {
                    remoteRandom = encoding.processBlock(encPremaster, 0, encPremaster.length);
                }
                catch (InvalidCipherTextException x) {
                    throw new IOException("" + x);
                }
            }
            finally {
                if (cpuBounding) {
                    cpu_bound_SEM.release();
                }
            }
            if (DEBUG_TIMING) {
                T = System.currentTimeMillis() - T;
                System.out.println("[BCUtil] Server decrypting premaster (incl lock) " + T + "ms");
            }
            if (DEBUG) {
                BCUtil.print(remoteRandom);
            }
        }
        for (int i = 0; i < premaster.length; ++i) {
            premaster[i] = (byte)(premaster[i] ^ remoteRandom[i]);
        }
        if (DEBUG) {
            if (client) {
                try {
                    Thread.sleep(250L);
                }
                catch (Exception i) {
                    // empty catch block
                }
                if (DEBUG) {
                    System.out.println("[BCUtil] Client final premaster:");
                }
                BCUtil.print(premaster);
            } else {
                if (DEBUG) {
                    System.out.println("[BCUtil] Server final premaster:");
                }
                BCUtil.print(premaster);
            }
        }
        if (client) {
            System.arraycopy(premaster, 0, this.encIv, 0, this.encIv.length);
            System.arraycopy(premaster, this.blockSize, this.encKey, 0, this.encKey.length);
            System.arraycopy(premaster, this.blockSize * 2, this.encMac, 0, this.encMac.length);
            System.arraycopy(premaster, this.blockSize * 3, this.decIv, 0, this.decIv.length);
            System.arraycopy(premaster, this.blockSize * 4, this.decKey, 0, this.decKey.length);
            System.arraycopy(premaster, this.blockSize * 5, this.decMac, 0, this.decMac.length);
        } else {
            System.arraycopy(premaster, 0, this.decIv, 0, this.decIv.length);
            System.arraycopy(premaster, this.blockSize, this.decKey, 0, this.decKey.length);
            System.arraycopy(premaster, this.blockSize * 2, this.decMac, 0, this.decMac.length);
            System.arraycopy(premaster, this.blockSize * 3, this.encIv, 0, this.encIv.length);
            System.arraycopy(premaster, this.blockSize * 4, this.encKey, 0, this.encKey.length);
            System.arraycopy(premaster, this.blockSize * 5, this.encMac, 0, this.encMac.length);
        }
        T = System.currentTimeMillis();
        this.initCiphersFromKeys();
        if (DEBUG_TIMING) {
            T = System.currentTimeMillis() - T;
            System.out.println("[BCUtil] Init ciphers took " + T + "ms");
        }
        t = System.currentTimeMillis() - t;
        System.out.println("[BCUtil] Handshake complete, took " + t + "ms");
        if (DEBUG_IMAGE) {
            if (client) {
                try {
                    byte[] imagedat = DEBUG_IMAGE_DUMPER.createImage();
                    this.wrap(imagedat, imagedat.length, dout);
                }
                catch (Exception imagedat) {}
            } else {
                try {
                    byte[] data = this.unwrap(din);
                    FileOutputStream fout = new FileOutputStream("BCUtil.png");
                    fout.write(data);
                    fout.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (client && msg != null) {
            msg.clientSendAndReceive();
        }
        if (!client) {
            if (msg != null) {
                msg.serverReceive();
            }
            if (msg != null) {
                msg.serverRespond();
            }
        }
        this.handshakeComplete = true;
    }

    private void initCiphersFromKeys() {
        ParametersWithIV encKeyAndIV = new ParametersWithIV(new KeyParameter(this.encKey), this.encIv);
        this.encCipher = new SICBlockCipherDTLS(new AESFastEngine());
        this.encCipher.init(true, encKeyAndIV);
        KeyParameter encMacKey = new KeyParameter(this.encMac);
        this.encHmac = new HMac(new ShortenedDigest(new SHA512Digest(), this.macSize));
        this.encHmac.init(encMacKey);
        ParametersWithIV decKeyAndIV = new ParametersWithIV(new KeyParameter(this.decKey), this.decIv);
        this.decCipher = new SICBlockCipherDTLS(new AESFastEngine());
        this.decCipher.init(false, decKeyAndIV);
        KeyParameter decMacKey = new KeyParameter(this.decMac);
        this.decHmac = new HMac(new ShortenedDigest(new SHA512Digest(), this.macSize));
        this.decHmac.init(decMacKey);
        this.randomiseCounter();
    }

    private OpenByteArrayOutputStream getMyBout() {
        if (this.cachedBout == null) {
            this.cachedBout = new OpenByteArrayOutputStream();
            this.cachedDout = new DataOutputStream(this.cachedBout);
        }
        return this.cachedBout;
    }

    private DataOutputStream getMyDout() {
        if (this.cachedBout == null) {
            this.getMyBout();
        }
        return this.cachedDout;
    }

    public byte[] wrap(byte[] data) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        this.wrap(data, data.length, dout);
        dout.flush();
        return bout.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wrap(byte[] dat, int len, DataOutputStream out) throws IOException {
        DataOutputStream encDout;
        OpenByteArrayOutputStream encBout;
        if (CACHE_ENCODING_BUFFERS) {
            encBout = this.getMyBout();
            encDout = this.getMyDout();
        } else {
            encBout = new OpenByteArrayOutputStream();
            encDout = new DataOutputStream(encBout);
        }
        Object object = this.wrap_LOCK;
        synchronized (object) {
            encBout.reset();
            this.encHmac.update(dat, 0, len);
            this.encHmac.doFinal(this.encMacBuf, 0);
            encDout.write(this.encMacBuf);
            encDout.writeInt(len);
            encDout.write(dat, 0, len);
            while (encBout.size() % this.blockSize != 0) {
                encDout.write(0);
            }
            byte[] encrypted = encBout.getByteArray();
            int encryptedlen = encBout.size();
            if (DEBUG && !this.handshakeComplete) {
                DEBUG_IMAGE_DUMPER.dumpImg("BCUtil-Unencrypted.png", encrypted);
            }
            out.write(this.encCipher.getCounter());
            for (int i = 0; i < encryptedlen; i += this.blockSize) {
                this.encCipher.processBlock(encrypted, i, encrypted, i);
            }
            out.writeInt(encryptedlen);
            out.write(encrypted, 0, encryptedlen);
            if (DEBUG && !this.handshakeComplete) {
                DEBUG_IMAGE_DUMPER.dumpImg("BCUtil-Encrypted.png", encrypted);
            }
        }
    }

    public Object unwrapReadData(DataInputStream in, OpenByteArrayOutputStream interim, byte[] buffer) throws IOException {
        byte[] counter = new byte[this.blockSize];
        in.readFully(counter);
        int msglen = in.readInt();
        while (interim.size() < msglen) {
            int n = in.read(buffer, 0, Math.min(buffer.length, msglen - interim.size()));
            if (n == -1) {
                return -1;
            }
            if (n <= 0) continue;
            interim.write(buffer, 0, n);
        }
        byte[] msgdata = interim.getByteArray();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(counter);
        list.add(msgdata);
        list.add(msglen);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int unwrapProcessData(byte[] buffer, OpenByteArrayOutputStream plaintext, Object data) throws IOException {
        ArrayList list = (ArrayList)data;
        byte[] counter = (byte[])list.get(0);
        byte[] msgdata = (byte[])list.get(1);
        int msglen = (Integer)list.get(2);
        Object object = this.unwrap_LOCK;
        synchronized (object) {
            this.decCipher.setCounter(counter);
            for (int i = 0; i < msglen; i += this.blockSize) {
                this.decCipher.processBlock(msgdata, i, msgdata, i);
            }
            ByteArrayInputStream bin = new ByteArrayInputStream(msgdata);
            DataInputStream din = new DataInputStream(bin);
            din.readFully(this.decMacBuf);
            int plainlen = din.readInt();
            while (plaintext.size() < plainlen) {
                int n = din.read(buffer, 0, Math.min(buffer.length, plainlen - plaintext.size()));
                if (n == -1) {
                    return -1;
                }
                if (n <= 0) continue;
                plaintext.write(buffer, 0, n);
            }
            byte[] plaindat = plaintext.getByteArray();
            this.decHmac.update(plaindat, 0, plainlen);
            this.decHmac.doFinal(this.verMacBuf, 0);
            if (!Arrays.areEqual(this.decMacBuf, this.verMacBuf)) {
                throw new IOException("HMAC ERROR");
            }
            if (SHOW_OVERHEAD) {
                this.plain += (long)plainlen;
                this.encrypted += (long)(plainlen + 65);
                if (System.currentTimeMillis() > this.nextPrint) {
                    double pc = this.plain;
                    pc = 100.0 / pc * (double)this.encrypted;
                    System.out.println("[BCUtil] Est overhead: +" + (int)(pc - 100.0) + "% " + this.plain + " -> " + this.encrypted);
                    this.nextPrint = System.currentTimeMillis() + 5000L;
                }
            }
            return plainlen;
        }
    }

    public int grabPacket(DataInputStream in, OpenByteArrayOutputStream interim, byte[] buffer) throws IOException {
        DataOutputStream dout = new DataOutputStream(interim);
        byte[] counter = new byte[this.blockSize];
        in.readFully(counter);
        dout.write(counter);
        int msglen = in.readInt();
        dout.writeInt(msglen);
        msglen += counter.length + 4;
        while (interim.size() < msglen) {
            int n = in.read(buffer, 0, Math.min(buffer.length, msglen - interim.size()));
            if (n == -1) {
                return -1;
            }
            if (n <= 0) continue;
            dout.write(buffer, 0, n);
        }
        return interim.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int unwrapHighPerformance(DataInputStream in, OpenByteArrayOutputStream interim, byte[] buffer, OpenByteArrayOutputStream plaintext) throws IOException {
        byte[] counter = new byte[this.blockSize];
        in.readFully(counter);
        int msglen = in.readInt();
        while (interim.size() < msglen) {
            int n = in.read(buffer, 0, Math.min(buffer.length, msglen - interim.size()));
            if (n == -1) {
                return -1;
            }
            if (n <= 0) continue;
            interim.write(buffer, 0, n);
        }
        byte[] msgdata = interim.getByteArray();
        Object object = this.unwrap_LOCK;
        synchronized (object) {
            this.decCipher.setCounter(counter);
            for (int i = 0; i < msglen; i += this.blockSize) {
                this.decCipher.processBlock(msgdata, i, msgdata, i);
            }
            ByteArrayInputStream bin = new ByteArrayInputStream(msgdata);
            DataInputStream din = new DataInputStream(bin);
            din.readFully(this.decMacBuf);
            int plainlen = din.readInt();
            if (Switches.SH_1637_bcutilBadRecoveryKey && (plainlen < 0 || plainlen > msglen)) {
                throw new IOException("Bad message size");
            }
            while (plaintext.size() < plainlen) {
                int n = din.read(buffer, 0, Math.min(buffer.length, plainlen - plaintext.size()));
                if (n == -1) {
                    return -1;
                }
                if (n <= 0) continue;
                plaintext.write(buffer, 0, n);
            }
            byte[] plaindat = plaintext.getByteArray();
            this.decHmac.update(plaindat, 0, plainlen);
            this.decHmac.doFinal(this.verMacBuf, 0);
            if (!Arrays.areEqual(this.decMacBuf, this.verMacBuf)) {
                throw new IOException("HMAC ERROR");
            }
            if (SHOW_OVERHEAD) {
                this.plain += (long)plainlen;
                this.encrypted += (long)(plainlen + 65);
                if (System.currentTimeMillis() > this.nextPrint) {
                    double pc = this.plain;
                    pc = 100.0 / pc * (double)this.encrypted;
                    System.out.println("[BCUtil] Est overhead: +" + (int)(pc - 100.0) + "% " + this.plain + " -> " + this.encrypted);
                    this.nextPrint = System.currentTimeMillis() + 5000L;
                }
            }
            return plainlen;
        }
    }

    public byte[] unwrap(byte[] dat) throws IOException {
        return this.unwrap(new DataInputStream(new ByteArrayInputStream(dat)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] unwrap(DataInputStream in) throws IOException {
        byte[] counter = new byte[this.blockSize];
        in.readFully(counter);
        int msglen = in.readInt();
        byte[] message = new byte[msglen];
        in.readFully(message);
        Object object = this.unwrap_LOCK;
        synchronized (object) {
            this.decCipher.setCounter(counter);
            for (int i = 0; i < msglen; i += this.blockSize) {
                this.decCipher.processBlock(message, i, message, i);
            }
            ByteArrayInputStream bin = new ByteArrayInputStream(message);
            DataInputStream din = new DataInputStream(bin);
            din.readFully(this.decMacBuf);
            int plainlen = din.readInt();
            if (plainlen < 0 || plainlen > msglen) {
                throw new IOException("Bad message size");
            }
            byte[] plaintext = new byte[plainlen];
            din.readFully(plaintext);
            this.decHmac.update(plaintext, 0, plaintext.length);
            this.decHmac.doFinal(this.verMacBuf, 0);
            if (!Arrays.areEqual(this.decMacBuf, this.verMacBuf)) {
                throw new IOException("HMAC ERROR");
            }
            if (SHOW_OVERHEAD) {
                this.plain += (long)plaintext.length;
                this.encrypted += (long)(plaintext.length + 65);
                if (System.currentTimeMillis() > this.nextPrint) {
                    double pc = this.plain;
                    pc = 100.0 / pc * (double)this.encrypted;
                    System.out.println("[BCUtil] Est overhead: +" + (int)(pc - 100.0) + "% " + this.plain + " -> " + this.encrypted);
                    this.nextPrint = System.currentTimeMillis() + 5000L;
                }
            }
            return plaintext;
        }
    }

    public static void print(byte[] key) {
        for (int i = 0; i < key.length; ++i) {
            System.out.print("\t" + key[i]);
            if ((1 + i) % 6 != 0) continue;
            System.out.println();
        }
        System.out.println();
    }

    public static String generateBase64Salt(int numberOfBytes) throws UnsupportedEncodingException {
        int diff = (numberOfBytes + 2) % 3;
        if (diff != 0) {
            numberOfBytes += 3 - diff;
        }
        byte[] randomBytes = new byte[numberOfBytes];
        BCUtil.getSecureRandom().nextBytes(randomBytes);
        return Base64.byteArrayToBase64(randomBytes);
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        String salt = BCUtil.generateBase64Salt(64);
        System.out.println(salt);
    }

    public static byte[] encryptWithSecret(byte[] data, String salt, String secret, int work) throws IOException {
        BCUtil bcu = new BCUtil();
        bcu.initFromSecret(salt, secret, work);
        return bcu.wrap(data);
    }

    public static byte[] decryptWithSecret(byte[] data, String salt, String secret, int work) throws IOException {
        BCUtil bcu = new BCUtil();
        bcu.initFromSecret(salt, secret, work);
        return bcu.unwrap(data);
    }

    public void initFromSecret(String salt, String secret, int work) {
        this.initFromSecret(PBEParametersGenerator.PKCS5PasswordToUTF8Bytes(salt.toCharArray()), secret, work);
    }

    public void initFromSecret(byte[] salt, String secret, int work) {
        PKCS5S2ParametersGenerator generator = new PKCS5S2ParametersGenerator(new SHA512Digest());
        generator.init(PBEParametersGenerator.PKCS5PasswordToUTF8Bytes(secret.toCharArray()), salt, work);
        KeyParameter macparams = (KeyParameter)((PBEParametersGenerator)generator).generateDerivedMacParameters(this.blockSize * 8);
        ParametersWithIV keyparams = (ParametersWithIV)((PBEParametersGenerator)generator).generateDerivedParameters(this.blockSize * 8, this.blockSize * 8);
        if (DEBUG) {
            System.out.println("[BCUtil] New setup from secret - PBKDF2 + SHA-512 / AES-256 / SIC / SHA-512");
        }
        this.encIv = keyparams.getIV();
        this.encKey = ((KeyParameter)keyparams.getParameters()).getKey();
        this.encMac = macparams.getKey();
        System.arraycopy(this.encIv, 0, this.decIv, 0, this.decIv.length);
        System.arraycopy(this.encKey, 0, this.decKey, 0, this.decKey.length);
        System.arraycopy(this.encMac, 0, this.decMac, 0, this.decMac.length);
        this.initCiphersFromKeys();
        this.randomiseCounter();
        this.handshakeComplete = true;
    }

    public static String encryptedPassword(String pword, String secret) throws IOException {
        return BCUtil.encryptedPasswordWithSalt(pword, secret, BCUtil.generateBase64Salt(24));
    }

    public static String encryptedPasswordWithSalt(String pword, String secret, String salt) throws IOException {
        byte[] dat;
        try {
            dat = pword.getBytes("UnicodeBig");
        }
        catch (Exception x) {
            dat = pword.getBytes("UTF-8");
        }
        dat = BCUtil.encryptWithSecret(dat, salt, secret, 800);
        return salt + ":" + Base64.byteArrayToBase64(dat);
    }

    public static String decryptPassword(String pword, String secret) throws IOException {
        int colon = pword.indexOf(58);
        if (colon == -1) {
            return null;
        }
        String salt = pword.substring(0, colon);
        byte[] part = Base64.base64ToByteArray(pword.substring(colon + 1));
        part = BCUtil.decryptWithSecret(part, salt, secret, 800);
        try {
            return new String(part, "UnicodeBig");
        }
        catch (Exception x) {
            return new String(part, "UTF-8");
        }
    }

    static {
        RANDOM_KEY_HASHES = new String[]{"7BA904E2A6B6AF9A90BFFBD744D695B8665CD192E1F66C2BD422C736B2810EDE43784F5A771CD975B2BB79E06A31AC56100AE7055E025EDA744C2641F7BC4415", "FA3330F827FCF532492024014CA3FD0D1209B0AEA819E91310309A33093111D641F0DA27DB80A8307740D7F0FC46C99879C2E5F90502EBE3444DC5C0E98481E6", "2D18CECD1A4ABC06F2D5D7FF8DDC5AB7027A95DB5F5762017FDFB9F6E0D0665DC668322C5114135984BFF9DB9BE5B021A1707536C53CAE1885043EE4F902F1B8", "89BB4FC550F14DDF8A0F70F2C0D11978FBD6CB8AE89CC24FEE32FE4A8253A252E7A0E0DACA103526766A20DD203B9AD4EB8F517F9EFA7397A50028908FC98CDD", "C4CA4E99D918206E4DB5936ADE322E4701C3BAF963D13CDF6939271277CF0B88F8462215790EE16F2A14DED8A49D37F7FE3ECFC7D3851ECB4F457F6755D76B8E", "11732159C182B95D04B1AC0BA2B7D6428D60F4E9D107B4B41662CC381416F171D1136EA32AE20D9715BD403B2EAACFF2D23AABF2ED5F6B439D2F1C171C36E192", "26517258866FC9CE18B6D697A64A89A2B3923DC555AEB71A986F5D076DB00205A8E5E4C9903DD27AE61A671274A128F7B1EFA7826681097BDBD0EA17E296DB2D", "66CAA7C1682E8440ED8F979105AFBEBC030BE3FA2449CAA40C6D002A9AEF56165E11BE7512FCAD24AE7D1A8C4BE865A715D24C2AB46751E428CFE66B7879ED14", "069032C2F8D0F69D40FFF3BA39C3E20603393F79E0D13A34FF490842A38072F5C659390864702E98CA20FEDC4A53197422DDBE87963FC1AAB39EEA9307C3F688", "7B0A16F107EF49050C6E4696FBF5E95778776BE269ECFD183DF34657D36473A4F6E090DA75FB0EAFD7D01E6F4D0F47CB3F1F1CB90FE82F7DE818BA80F9F42EF9"};
    }

    public static interface PublicKeyHashProvider
    extends Iterable<String> {
    }

    public class ServerAuthenticityException
    extends Exception {
        public ServerAuthenticityException(String msg) {
            super(msg);
        }
    }
}

