/*
 * Decompiled with CFR 0.152.
 */
package utils.vnc.utils;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import utils.vnc.PixelFormat;

public class PixelInputStream
extends DataInputStream {
    private PixelFormat format;
    byte[] threeBuffer = new byte[3];
    byte[] fourBuffer = new byte[4];
    long total = 0L;
    long count = 0L;

    public PixelInputStream(PixelFormat format, InputStream in) {
        super(new BufferedInputStream(in));
        this.format = format;
    }

    public int readCPixel() throws IOException {
        if (this.format.getTrueColorFlag() == 0) {
            return this.readPixel();
        }
        if (this.format.getRedMax() != 255 || this.format.getGreenMax() != 255 || this.format.getBlueMax() != 255) {
            return this.readPixel();
        }
        this.readFully(this.threeBuffer);
        return this.bytesToPixel(this.threeBuffer[0], this.threeBuffer[1], this.threeBuffer[2]);
    }

    public int bytesToPixel(int b1, int b2, int b3, int b4) {
        if (this.format.isBigEndian()) {
            return (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | b4 & 0xFF;
        }
        return (b3 & 0xFF) << 16 | (b2 & 0xFF) << 8 | b1 & 0xFF;
    }

    public int bytesToPixel(int b1, int b2, int b3) {
        if (this.format.isBigEndian()) {
            return (b1 & 0xFF) << 16 | (b2 & 0xFF) << 8 | b3 & 0xFF;
        }
        return (b3 & 0xFF) << 16 | (b2 & 0xFF) << 8 | b1 & 0xFF;
    }

    public int shortToPixel(short s) {
        if (this.format.isBigEndian()) {
            s = Short.reverseBytes(s);
        }
        int r = 8 * (s & 0x1F);
        int g = 8 * (s >> 5 & 0x1F);
        int b = 8 * (s >> 10 & 0x1F);
        return this.bytesToPixel(r, g, b);
    }

    public int readPixel() throws IOException {
        switch (this.format.getBitsPerPixel()) {
            case 32: {
                if (this.format.getDepth() == 32 || this.format.getDepth() == 24) {
                    this.readFully(this.fourBuffer);
                    return this.bytesToPixel(this.fourBuffer[0], this.fourBuffer[1], this.fourBuffer[2], this.fourBuffer[3]);
                }
                if (this.format.getDepth() == 16) {
                    int s1 = this.readUnsignedShort();
                    int s2 = this.readUnsignedShort();
                    if (this.format.isBigEndian()) {
                        return this.shortToPixel((short)s1);
                    }
                    return this.shortToPixel((short)s2);
                }
                System.out.println("Unsupported color depth (" + this.format.getDepth() + ") for bpp of " + this.format.getBitsPerPixel());
                break;
            }
            case 24: {
                if (this.format.getDepth() == 24) {
                    this.readFully(this.threeBuffer);
                    return this.bytesToPixel(this.threeBuffer[0], this.threeBuffer[1], this.threeBuffer[2]);
                }
                if (this.format.getDepth() == 16) {
                    int s1 = this.readUnsignedShort();
                    this.readUnsignedByte();
                    int r = 8 * (s1 & 0x1F);
                    int g = 8 * (s1 >> 5 & 0x1F);
                    int b = 8 * (s1 >> 10 & 0x1F);
                    int rgb = (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
                    return rgb;
                }
                System.out.println("Unsupported color depth (" + this.format.getDepth() + ") for bpp of " + this.format.getBitsPerPixel());
                break;
            }
            case 16: {
                if (this.format.getDepth() == 16) {
                    int s1 = this.readUnsignedShort();
                    int r = 8 * (s1 & 0x1F);
                    int g = 8 * (s1 >> 5 & 0x1F);
                    int b = 8 * (s1 >> 10 & 0x1F);
                    int rgb = (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
                    return rgb;
                }
                System.out.println("Unsupported color depth (" + this.format.getDepth() + ") for bpp of " + this.format.getBitsPerPixel());
                break;
            }
            case 8: {
                System.out.println("Unsupported color depth (" + this.format.getDepth() + ") for bpp of " + this.format.getBitsPerPixel());
                break;
            }
            default: {
                System.out.println("Unsupported color depth (" + this.format.getDepth() + ") for bpp of " + this.format.getBitsPerPixel());
            }
        }
        return 0;
    }
}

