/*
 * Decompiled with CFR 0.152.
 */
package utils.vnc.encoders;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import utils.stream.StreamUtils;
import utils.vnc.PixelFormat;
import utils.vnc.VNC;
import utils.vnc.encoders.datatarget.ImageDataInterface;
import utils.vnc.utils.PixelInputStream;

public class ZlibDecoder {
    private Inflater inflater = new Inflater();
    byte[] buffer;

    public void doDecoding(PixelInputStream in, int xpos, int ypos, int subWidth, int subHeight, ImageDataInterface image, PixelFormat format) throws IOException {
        int length = in.readInt();
        if (this.buffer == null || this.buffer.length < subWidth * subHeight * 4) {
            this.buffer = new byte[subWidth * subHeight * 4];
        }
        if (VNC.VNC_DEBUG_ENCODINGS) {
            System.out.println("[ZLib] Length of compressed data is " + length);
        }
        byte[] compressedData = StreamUtils.readBytes(in, length);
        this.inflater.setInput(compressedData);
        try {
            if (VNC.VNC_DEBUG_ENCODINGS) {
                System.out.println("Uncompressed " + this.inflater.inflate(this.buffer) + " [buffersize=" + this.buffer.length + "]");
            } else {
                this.inflater.inflate(this.buffer);
            }
        }
        catch (DataFormatException e) {
            e.printStackTrace();
            IOException res = new IOException();
            res.initCause(e);
            throw res;
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(this.buffer);
        PixelInputStream zlibIn = new PixelInputStream(format, bin);
        for (int yy = 0; yy < subHeight; ++yy) {
            for (int xx = 0; xx < subWidth; ++xx) {
                int pixel = zlibIn.readPixel();
                if (xx + xpos >= image.getWidth() || yy + ypos >= image.getHeight()) continue;
                image.setRGB(xx + xpos, yy + ypos, pixel);
            }
        }
        if (VNC.VNC_DEBUG_ENCODINGS) {
            System.out.println("[ZLib] Decompression complete.");
        }
    }
}

