/*
 * Decompiled with CFR 0.152.
 */
package utils.vnc;

import java.awt.event.KeyEvent;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import utils.stream.StreamUtils;
import utils.vnc.InputController;
import utils.vnc.PixelFormat;
import utils.vnc.ServerMessageHandler;
import utils.vnc.VNCSessionSettings;
import utils.vnc.authentication.ARDAuthentication;
import utils.vnc.authentication.SecurityTypes;
import utils.vnc.authentication.VNCAuthentication;
import utils.vnc.encoders.Encodings;
import utils.vnc.encoders.datatarget.ImageDataInterface;
import utils.vnc.exceptions.FailedSecurityException;
import utils.vnc.exceptions.UnsupportedSecurityException;
import utils.vnc.ui.ImageChangeListener;
import utils.vnc.utils.PixelInputStream;

public class VNC {
    private static final boolean VNC_DEBUG_UPDATES = false;
    public static boolean VNC_DEBUG_ENCODINGS = false;
    public static boolean VNC_DEBUG_SERVER_MESSAGES = false;
    public static final int SECURITY_TYPE_VNC_PASSWORD = 2;
    public static final int SECURITY_TYPE_ARD = 30;
    private int securityType;
    private int[] preferredEncodings;
    private Socket socket;
    private InputStream socketIn;
    private OutputStream socketOut;
    private PixelInputStream in;
    private InputController input;
    private ServerMessageHandler smh;
    private PixelFormat format = new PixelFormat();
    private boolean connectedLocally = false;
    private String serverVersion;
    private boolean isARD;

    public void setConnectedLocally(boolean connectedLocally) {
        if (connectedLocally) {
            System.out.println("[VNC] Established a local VNC connection");
        } else {
            System.out.println("[VNC] Established a non-local VNC connection");
        }
        this.connectedLocally = connectedLocally;
    }

    public boolean isConnectedLocally() {
        return this.connectedLocally;
    }

    public void preSecurityHandshake() throws IOException, FailedSecurityException, UnsupportedSecurityException {
        this.securityType = this.handshakePreSecurity();
    }

    public void postSecurityHandshare() throws IOException, FailedSecurityException, UnsupportedSecurityException {
        this.handshakePostSecurity(this.securityType);
        this.init();
        this.initInput();
    }

    public void setDataInterface(ImageChangeListener listener, ImageDataInterface image) throws IOException {
        this.initMessageHandler(listener, image);
        this.requestEncodings(this.preferredEncodings);
    }

    public void setMousePointerState(int x, int y, byte buttonMask) throws IOException {
        if (this.input != null) {
            this.input.setMousePointerState(x, y, buttonMask);
        }
    }

    public void sendKey(boolean isKeyPressed, int keycode) throws IOException {
        if (this.input != null) {
            this.input.sendKeyEvent(isKeyPressed, keycode);
        }
    }

    public void sendKey(boolean isKeyPressed, KeyEvent e) throws IOException {
        if (this.input != null) {
            this.input.sendKeyEvent(isKeyPressed, e);
        }
    }

    private void initInput() {
        this.input = new InputController(this.socketOut);
    }

    public PixelFormat getCurrentPixelFormat() {
        return this.format;
    }

    private void requestEncodings(int[] preferredEncodings) throws IOException {
        this.socketOut.write(2);
        this.socketOut.write(0);
        StreamUtils.writeShort(this.socketOut, (short)preferredEncodings.length);
        for (int i = 0; i < preferredEncodings.length; ++i) {
            StreamUtils.writeInt(this.socketOut, preferredEncodings[i]);
        }
    }

    public void sendFramebufferUpdateRequest(int incremental, int x, int y, int width, int height) throws IOException {
        this.socketOut.write(3);
        this.socketOut.write(incremental);
        StreamUtils.writeShort(this.socketOut, (short)x);
        StreamUtils.writeShort(this.socketOut, (short)y);
        StreamUtils.writeShort(this.socketOut, (short)width);
        StreamUtils.writeShort(this.socketOut, (short)height);
        this.socketOut.flush();
    }

    public void sendContinuousFrameBufferUpdateRequest(boolean enableContinuousUpdates, int x, int y, int width, int height) throws IOException {
        this.socketOut.write(150);
        if (enableContinuousUpdates) {
            this.socketOut.write(1);
        } else {
            this.socketOut.write(0);
        }
        StreamUtils.writeShort(this.socketOut, (short)x);
        StreamUtils.writeShort(this.socketOut, (short)y);
        StreamUtils.writeShort(this.socketOut, (short)width);
        StreamUtils.writeShort(this.socketOut, (short)height);
        this.socketOut.flush();
    }

    private void initMessageHandler(ImageChangeListener handler, ImageDataInterface image) {
        this.smh = new ServerMessageHandler(this.format, this.in, image);
        this.smh.addImageChangeListener(handler);
        this.smh.start();
    }

    public void addImageChangeListener(ImageChangeListener listener) {
        this.smh.addImageChangeListener(listener);
    }

    private void init() throws IOException {
        int clientInit = 1;
        this.socketOut.write(clientInit);
        this.format.screenWidth = StreamUtils.readShort(this.socketIn);
        this.format.screenHeight = StreamUtils.readShort(this.socketIn);
        this.format.bitsPerPixel = (byte)this.socketIn.read();
        this.format.depth = (byte)this.socketIn.read();
        this.format.bigEndianFlag = (byte)this.socketIn.read();
        this.format.trueColorFlag = (byte)this.socketIn.read();
        this.format.redMax = StreamUtils.readShort(this.socketIn);
        this.format.greenMax = StreamUtils.readShort(this.socketIn);
        this.format.blueMax = StreamUtils.readShort(this.socketIn);
        this.format.redShift = (byte)this.socketIn.read();
        this.format.greenShift = (byte)this.socketIn.read();
        this.format.blueShift = (byte)this.socketIn.read();
        for (int i = 0; i < 3; ++i) {
            this.socketIn.read();
        }
        int nameLength = StreamUtils.readInt(this.socketIn);
        String name = new String(StreamUtils.readBytes(this.socketIn, nameLength));
        this.in = new PixelInputStream(this.format, this.socketIn);
        this.socketIn = null;
        System.out.println("[VNC] Remote Machine Name = " + name);
        System.out.println(this.format);
    }

    private int handshakePreSecurity() throws IOException, FailedSecurityException, UnsupportedSecurityException {
        this.serverVersion = new String(StreamUtils.readBytes(this.socketIn, 12), "ASCII");
        System.out.println("[VNC] Server declared protocol " + this.serverVersion);
        this.socketOut.write(new String("RFB 003.008\n").getBytes("ASCII"));
        this.isARD = this.serverVersion.equals("RFB 003.889\n");
        int securityType = 30;
        if (this.is37OrLater()) {
            int numberOfSecurityTypes = this.socketIn.read();
            if (numberOfSecurityTypes == 0) {
                String reason = this.readFailureText();
                throw new IOException("Connection failed during security handshake (" + reason + ")");
            }
            System.out.println("[VNC] Expecting " + numberOfSecurityTypes + " security types");
            ArrayList<Integer> allServerSecurityTypes = new ArrayList<Integer>();
            for (int i = 0; i < numberOfSecurityTypes; ++i) {
                int type = this.socketIn.read();
                System.out.println("[VNC] Supports security type " + type);
                allServerSecurityTypes.add(new Integer(type));
            }
            securityType = SecurityTypes.pickSecurityType(allServerSecurityTypes);
            System.out.println("[VNC] Selected security type " + securityType);
        } else {
            securityType = StreamUtils.readInt(this.socketIn);
            this.isSupportedSecurityType(securityType);
        }
        System.out.println("[VNC] Chosen security type " + securityType);
        this.socketOut.write(securityType);
        return securityType;
    }

    public void handshakePostSecurity(int securityType) throws IOException, FailedSecurityException {
        int securityResult = StreamUtils.readInt(this.socketIn);
        System.out.println("[VNC] Security result is " + securityResult);
        if (securityResult == 1) {
            String reason = this.readFailureText();
            throw new IOException("Connection failed during security handshake (" + reason + ")");
        }
    }

    public void isSupportedSecurityType(int type) throws UnsupportedSecurityException {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(new Integer(type));
        SecurityTypes.pickSecurityType(list);
    }

    private String readFailureText() throws IOException {
        int responseLength = StreamUtils.readInt(this.socketIn);
        byte[] response = StreamUtils.readBytes(this.socketIn, responseLength);
        String responseText = new String(response, "ASCII");
        return responseText;
    }

    public void securityHandshake(String[] credentials) throws IOException, FailedSecurityException {
        if (this.securityType == 2) {
            VNCAuthentication.authenticate(this.socketIn, this.socketOut, credentials[1]);
        } else if (this.securityType == 30 && this.isARD) {
            ARDAuthentication.authenticate(this.socketIn, this.socketOut, credentials[0], credentials[1]);
        }
    }

    private boolean is37OrLater() {
        int dot;
        String ver = this.serverVersion.trim();
        if (ver.startsWith("RFB ")) {
            ver = ver.substring("RFB ".length());
        }
        if ((dot = ver.indexOf(46)) > -1) {
            String first = ver.substring(0, dot);
            String second = ver.substring(dot + 1);
            int firstInt = Integer.parseInt(first);
            if (firstInt < 3) {
                return false;
            }
            if (firstInt > 3) {
                return true;
            }
            int secondInt = Integer.parseInt(second);
            return secondInt >= 7;
        }
        return true;
    }

    public void connect(VNCSessionSettings settings) throws IOException, FailedSecurityException, UnsupportedSecurityException {
        this.connect(settings, Encodings.ALL_ENCODINGS_ORDERED);
    }

    public void connect(VNCSessionSettings settings, int[] preferredEncodings) throws IOException, FailedSecurityException, UnsupportedSecurityException {
        this.preferredEncodings = preferredEncodings;
        this.socket = new Socket(settings.getHostname(), settings.getPort());
        this.socketOut = this.socket.getOutputStream();
        this.socketIn = new BufferedInputStream(this.socket.getInputStream());
        this.preSecurityHandshake();
    }

    public void disconnect() {
        this.input = null;
        if (this.smh != null) {
            this.smh.die();
        }
        this.smh = null;
        try {
            if (this.socket != null) {
                this.socket.close();
            }
            this.socket = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (this.socketIn != null) {
                this.socketIn.close();
            }
            this.socketIn = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (this.socketOut != null) {
                this.socketOut.close();
            }
            this.socketOut = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void login(String[] credentials) throws IOException, FailedSecurityException, UnsupportedSecurityException {
        System.out.println("[VNC] Logging in");
        this.securityHandshake(credentials);
        this.postSecurityHandshare();
    }

    public int getChosenSecurityType() {
        return this.securityType;
    }
}

