/*
 * Decompiled with CFR 0.152.
 */
package utils.vnc;

import java.io.IOException;
import java.util.ArrayList;
import utils.stream.StreamUtils;
import utils.vnc.PixelFormat;
import utils.vnc.VNC;
import utils.vnc.encoders.CoRREDecoder;
import utils.vnc.encoders.CopyRectDecoder;
import utils.vnc.encoders.RREDecoder;
import utils.vnc.encoders.RawDecoder;
import utils.vnc.encoders.ZRLEDecoder;
import utils.vnc.encoders.ZlibDecoder;
import utils.vnc.encoders.datatarget.ImageDataInterface;
import utils.vnc.ui.ImageChangeListener;
import utils.vnc.utils.PixelInputStream;

public class ServerMessageHandler
extends Thread {
    private PixelInputStream in;
    private PixelFormat format;
    private ArrayList listeners = new ArrayList();
    private ZRLEDecoder zrleDecoder = new ZRLEDecoder();
    private ZlibDecoder zlibDecoder = new ZlibDecoder();
    private ImageDataInterface image;
    private boolean die = false;

    public void setScreenSize(int width, int height) {
        this.image.setScreenSize(width, height);
        this.notiftyImageChangeListeners();
    }

    public ServerMessageHandler(PixelFormat format, PixelInputStream in, ImageDataInterface target) {
        super("ServerMessageHandler");
        this.in = in;
        this.format = format;
        this.image = target;
    }

    public void addImageChangeListener(ImageChangeListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void notiftyImageChangeListeners() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ImageChangeListener)this.listeners.get(i)).imageChanged();
        }
    }

    @Override
    public void run() {
        block9: while (!this.die) {
            try {
                int messageID = this.in.readUnsignedByte();
                if (VNC.VNC_DEBUG_SERVER_MESSAGES) {
                    System.out.println("[ServerMessageHandler] Got message type: " + messageID);
                }
                switch (messageID) {
                    case 0: {
                        this.in.read();
                        int numRectangles = StreamUtils.readShort(this.in);
                        if (VNC.VNC_DEBUG_SERVER_MESSAGES) {
                            System.out.println("[ServerMessageHandler] Got " + numRectangles + " rectangles");
                        }
                        for (int i = 0; i < numRectangles; ++i) {
                            int xpos = this.in.readUnsignedShort();
                            int ypos = this.in.readUnsignedShort();
                            int width = this.in.readUnsignedShort();
                            int height = this.in.readUnsignedShort();
                            int encoding = StreamUtils.readInt(this.in);
                            if (VNC.VNC_DEBUG_SERVER_MESSAGES) {
                                System.out.println("[ServerMessageHandler] Got rectangle " + i + "/" + numRectangles);
                                System.out.println("\txpos=" + xpos);
                                System.out.println("\typos=" + ypos);
                                System.out.println("\twidth=" + width);
                                System.out.println("\theight=" + height);
                                System.out.println("\tencoding=" + encoding);
                            }
                            if (encoding == 0) {
                                RawDecoder.doRawDecoding(this.in, xpos, ypos, width, height, this.image, this.format);
                                continue;
                            }
                            if (encoding == 1) {
                                CopyRectDecoder.doDecoding(this.in, xpos, ypos, width, height, this.image, this.format);
                                continue;
                            }
                            if (encoding == 2) {
                                RREDecoder.doDecoding(this.in, xpos, ypos, width, height, this.image, this.format);
                                continue;
                            }
                            if (encoding == 4) {
                                CoRREDecoder.doDecoding(this.in, xpos, ypos, width, height, this.image, this.format);
                                continue;
                            }
                            if (encoding == 6) {
                                this.zlibDecoder.doDecoding(this.in, xpos, ypos, width, height, this.image, this.format);
                                continue;
                            }
                            if (encoding == 16) {
                                this.zrleDecoder.doDecoding(this.in, xpos, ypos, width, height, this.image, this.format);
                                continue;
                            }
                            new Exception("Unrecognised encoding: " + encoding).printStackTrace();
                            return;
                        }
                        this.notiftyImageChangeListeners();
                        break;
                    }
                    case 1: {
                        this.in.read();
                        short firstColor = StreamUtils.readShort(this.in);
                        int noOfColours = StreamUtils.readShort(this.in);
                        for (int i = 0; i < noOfColours; ++i) {
                            short r = StreamUtils.readShort(this.in);
                            short g = StreamUtils.readShort(this.in);
                            short s = StreamUtils.readShort(this.in);
                        }
                        continue block9;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        this.in.read();
                        this.in.read();
                        this.in.read();
                        int len = StreamUtils.readInt(this.in);
                        byte[] data = StreamUtils.readBytes(this.in, len);
                        break;
                    }
                    case 150: {
                        if (!VNC.VNC_DEBUG_SERVER_MESSAGES) continue block9;
                        System.out.println("[ServerMessageHandler] Server has disabled continuous updates.");
                        break;
                    }
                    default: {
                        System.out.println("Unrecognised message type: " + messageID);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
    }

    public void die() {
        this.die = true;
    }
}

