/*
 * Decompiled with CFR 0.152.
 */
package utils.vnc;

import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.OutputStream;
import utils.stream.StreamUtils;
import utils.vnc.utils.KeySymMapper;

public class InputController {
    private OutputStream out;

    public InputController(OutputStream out) {
        this.out = out;
    }

    public void setMousePointerState(int x, int y, int buttonMask) throws IOException {
        this.out.write(5);
        this.out.write(buttonMask);
        StreamUtils.writeShort(this.out, (short)x);
        StreamUtils.writeShort(this.out, (short)y);
        this.out.flush();
    }

    public void sendKeyEvent(boolean keyPressed, KeyEvent e) throws IOException {
        this.out.write(4);
        if (keyPressed) {
            this.out.write(1);
        } else {
            this.out.write(0);
        }
        this.out.write(0);
        this.out.write(0);
        int key = KeySymMapper.getKeySymForCode(e);
        StreamUtils.writeInt(this.out, key);
        this.out.flush();
    }

    public void sendKeyEvent(boolean isKeyPressed, int keycode) throws IOException {
        this.out.write(4);
        if (isKeyPressed) {
            this.out.write(1);
        } else {
            this.out.write(0);
        }
        this.out.write(0);
        this.out.write(0);
        int key = KeySymMapper.getKeySymForCode(keycode);
        StreamUtils.writeInt(this.out, key);
        this.out.flush();
    }
}

