/*
 * Decompiled with CFR 0.152.
 */
package utils.upnp;

import java.io.IOException;
import java.net.ProxySelector;
import java.util.ArrayList;
import utils.upnp.Device;
import utils.upnp.DeviceList;
import utils.upnp.DiscoverDevices;
import utils.upnp.PortMapping;

public class SimpleUPnP {
    private int socketTimeout = 10000;
    private ProxySelector defaultProxy = ProxySelector.getDefault();
    static final boolean VERBOSE = false;

    public SimpleUPnP(int waitMilliseconds) {
        this();
        this.socketTimeout = waitMilliseconds;
    }

    public SimpleUPnP() {
        ProxySelector.setDefault(null);
    }

    public void close() {
        ProxySelector.setDefault(this.defaultProxy);
    }

    public DeviceList query() throws IOException {
        DeviceList deviceList = new DiscoverDevices(this.socketTimeout).fetchDevices();
        return deviceList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean mappingExists(String descriptionNoSpace) {
        try (SimpleUPnP upnp = new SimpleUPnP();){
            DeviceList list = upnp.query();
            Device[] connectedDevices = list.getConnectedDevices();
            for (int i = 0; i < list.getNumberOfConnectedDevices(); ++i) {
                Device device = connectedDevices[i];
                ArrayList portMappingsByName = device.getPortMappingsByName(descriptionNoSpace);
                if (portMappingsByName == null || portMappingsByName.size() <= 0) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void openPortToHost(String descriptionNoSpace, int port, String internalClientIP) {
        try (SimpleUPnP upnp = new SimpleUPnP();){
            DeviceList list = upnp.query();
            Device[] connectedDevices = list.getConnectedDevices();
            for (int i = 0; i < list.getNumberOfConnectedDevices(); ++i) {
                Device device = connectedDevices[i];
                PortMapping mapping = new PortMapping();
                mapping.description = descriptionNoSpace;
                mapping.enabled = "1";
                mapping.externalPort = port;
                mapping.internalPort = port;
                mapping.internalClient = internalClientIP;
                mapping.remoteHost = "";
                mapping.protocol = "TCP";
                if (!device.addPortMapping(mapping)) continue;
                System.out.println("[PortMap] Port forwarding to " + internalClientIP + ":" + port + " successful.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeMappings(String descriptionNoSpace) {
        try (SimpleUPnP upnp = new SimpleUPnP();){
            DeviceList list = upnp.query();
            Device[] connectedDevices = list.getConnectedDevices();
            for (int i = 0; i < list.getNumberOfConnectedDevices(); ++i) {
                Device device = connectedDevices[i];
                try {
                    ArrayList portMappingsByName = device.getPortMappingsByName("SimpleHelpServer");
                    for (int ii = 0; ii < portMappingsByName.size(); ++ii) {
                        device.deletePortMapping((PortMapping)portMappingsByName.get(ii));
                    }
                }
                catch (Throwable ignore) {
                    ignore.printStackTrace();
                }
                System.out.println("[PortMap] Removed port mapping (" + i + ").");
            }
        }
    }

    public static void main(String[] args) throws IOException {
        System.out.println("Welcome to the UPnP Tester");
        System.out.println("--------------------------");
        System.out.println();
        SimpleUPnP upnp = new SimpleUPnP();
        System.out.println("Broadcasting discovery message...");
        DeviceList list = upnp.query();
        System.out.println("Received a response from " + list.devices.size() + " devices (" + list.getNumberOfConnectedDevices() + " connected).");
        Device[] connectedDevices = list.getConnectedDevices();
        for (int i = 0; i < list.getNumberOfConnectedDevices(); ++i) {
            System.out.println("--------------------------");
            System.out.println("Communicating with device " + i);
            Device device = connectedDevices[i];
            System.out.println("Friendly name: " + device.getFriendlyName());
            System.out.println("UDN: " + device.getUDN());
            System.out.println("External IP: " + device.getExternalIPAddress());
            System.out.println("Printing out port mappings now:");
            device.printMappings();
            PortMapping mapping = new PortMapping();
            mapping.description = "SimpleHelpTest";
            mapping.enabled = "1";
            mapping.externalPort = 54123;
            mapping.internalPort = 54123;
            mapping.internalClient = "192.168.1.120";
            mapping.remoteHost = "";
            mapping.protocol = "TCP";
            System.out.println("Adding new port mapping:");
            System.out.println("\t" + mapping);
            if (!device.addPortMapping(mapping)) {
                System.out.println("Adding the port failed! Exiting...");
                return;
            }
            System.out.println("Printing out port mappings now:");
            device.printMappings();
            System.out.println("Removing the added mapping.");
            ArrayList portMappingsByName = device.getPortMappingsByName("SimpleHelpTest");
            device.deletePortMappings(portMappingsByName);
            System.out.println("Printing out port mappings now:");
            device.printMappings();
        }
    }
}

