/*
 * Decompiled with CFR 0.152.
 */
package utils.upnp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import utils.upnp.Device;
import utils.upnp.DeviceList;

public class DiscoverDevices {
    public static final String BROADCAST_IP = "239.255.255.250";
    public static final int BROADCAST_PORT = 1900;
    public static final int MAX_DELAY = 1;
    private int socketTimeout;

    public DiscoverDevices(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    private static final String getDiscoveryRequest() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("M-SEARCH * HTTP/1.1").append("\r\n");
        buffer.append("HOST: 239.255.255.250:1900").append("\r\n");
        buffer.append("MAN: \"ssdp:discover\"").append("\r\n");
        buffer.append("MX:  1").append("\r\n");
        buffer.append("ST: urn:schemas-upnp-org:device:InternetGatewayDevice:1").append("\r\n");
        buffer.append("\r\n");
        return buffer.toString();
    }

    private Device createDeviceFromResponse(InetAddress inetAddress, byte[] bResponse) {
        int maxAge = 0;
        String dateReceived = null;
        String location = null;
        String searchTarget = null;
        String usn = null;
        String response = new String(bResponse);
        try {
            BufferedReader reader = new BufferedReader(new StringReader(response));
            String line = reader.readLine();
            while (line != null) {
                int colonIndex = line.indexOf(58);
                if (colonIndex != -1) {
                    String key = line.substring(0, colonIndex).trim();
                    String value = line.substring(colonIndex + 1).trim();
                    if (!key.equalsIgnoreCase("CACHE-CONTROL")) {
                        if (key.equalsIgnoreCase("DATE")) {
                            dateReceived = value;
                        } else if (key.equalsIgnoreCase("LOCATION")) {
                            location = value;
                        } else if (key.equalsIgnoreCase("ST")) {
                            searchTarget = value;
                        } else if (key.equalsIgnoreCase("USN")) {
                            usn = value;
                        }
                    }
                }
                line = reader.readLine();
            }
            return new Device(inetAddress, maxAge, dateReceived, location, searchTarget, usn);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceList fetchDevices() throws IOException {
        DeviceList deviceList = new DeviceList();
        DatagramSocket clientSocket = new DatagramSocket();
        clientSocket.setSoTimeout(this.socketTimeout);
        InetAddress sendIP = InetAddress.getByName(BROADCAST_IP);
        byte[] sendData = DiscoverDevices.getDiscoveryRequest().getBytes();
        byte[] receiveData = new byte[102400];
        DatagramPacket sendPacket = new DatagramPacket(sendData, sendData.length, sendIP, 1900);
        clientSocket.send(sendPacket);
        try {
            DatagramPacket receivePacket = new DatagramPacket(receiveData, receiveData.length);
            clientSocket.receive(receivePacket);
            Device device = this.createDeviceFromResponse(receivePacket.getAddress(), receivePacket.getData());
            if (device != null) {
                deviceList.devices.add(device);
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
        }
        finally {
            clientSocket.close();
        }
        return deviceList;
    }
}

