/*
 * Decompiled with CFR 0.152.
 */
package utils.upnp;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import utils.stream.StreamUtils;
import utils.string.CharStack;
import utils.upnp.PortMapping;

public class Device {
    private int maxAge = 0;
    private String dateReceived = null;
    private String locationURL = null;
    private String searchTarget = null;
    private String usn = null;
    private InetAddress inetAddress;
    private String friendlyName = null;
    private String UDN = null;
    private String serviceType = null;
    private String serviceId;
    private String controlURL;
    private static final Pattern xmlPattern = Pattern.compile("<([^\\>]*)>([^\\<]*)<\\/[^\\>]*>");

    public Device(InetAddress inetAddress, int maxAge, String dateReceived, String locationURL, String searchTarget, String usn) throws IOException {
        this.inetAddress = inetAddress;
        this.maxAge = maxAge;
        this.dateReceived = dateReceived;
        this.locationURL = locationURL;
        this.searchTarget = searchTarget;
        this.usn = usn;
        this.requestServiceList();
    }

    private void requestServiceList() throws IOException {
        System.out.println("Querying URL: " + this.locationURL);
        URLConnection urlConn = new URL(this.locationURL).openConnection();
        String xmlConfig = StreamUtils.readAllAsString(urlConn.getInputStream());
        String base = this.getURLBase(xmlConfig);
        this.friendlyName = this.getFriendlyName(xmlConfig);
        this.UDN = this.getUDN(xmlConfig);
        CharStack cs = new CharStack(xmlConfig);
        while (!cs.isEmpty()) {
            cs.popUntil("<service>", false);
            String service = cs.popUntil("</service>", true);
            Matcher matcher = xmlPattern.matcher(service);
            if (this.serviceType != null && this.serviceType.equals("urn:schemas-upnp-org:service:WANIPConnection:1")) continue;
            while (matcher.find()) {
                String key = matcher.group(1);
                String value = matcher.group(2);
                if (key.equals("serviceType")) {
                    this.serviceType = value;
                    continue;
                }
                if (key.equals("serviceId")) {
                    this.serviceId = value;
                    continue;
                }
                if (!key.equals("controlURL")) continue;
                this.controlURL = base + value;
            }
        }
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public String getUDN() {
        return this.UDN;
    }

    private String getFriendlyName(String xmlConfig) {
        int start = xmlConfig.indexOf("<friendlyName>") + "<friendlyName>".length();
        int end = xmlConfig.indexOf("</friendlyName>");
        return xmlConfig.substring(start, end);
    }

    private String getUDN(String xmlConfig) {
        int start = xmlConfig.indexOf("<UDN>") + "<UDN>".length();
        int end = xmlConfig.indexOf("</UDN>");
        return xmlConfig.substring(start, end);
    }

    public void deletePortMapping(PortMapping portMapping) throws IOException {
        this.deletePortMapping(portMapping.externalPort, portMapping.protocol);
    }

    public void deletePortMapping(int externalPort, String protocol) throws IOException {
        String[] keys = new String[]{"NewRemoteHost", "NewExternalPort", "NewProtocol"};
        String[] values = new String[]{"", "" + externalPort, "" + protocol};
        Device.executeUPnPAction(this.controlURL, this.serviceType, "DeletePortMapping", keys, values);
    }

    private String getURLBase(String xmlConfig) {
        int start = xmlConfig.indexOf("<URLBase>") + "<URLBase>".length();
        int end = xmlConfig.indexOf("</URLBase>");
        return xmlConfig.substring(start, end);
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public String getDateReceived() {
        return this.dateReceived;
    }

    public String getLocationURL() {
        return this.locationURL;
    }

    public String getSearchTarget() {
        return this.searchTarget;
    }

    public String getUsn() {
        return this.usn;
    }

    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    public boolean isConnected() throws IOException {
        String connectionStatus;
        Map result = Device.executeUPnPAction(this.controlURL, this.serviceType, "GetStatusInfo", new String[0], new String[0]);
        return result != null && (connectionStatus = (String)result.get("NewConnectionStatus")) != null && connectionStatus.equalsIgnoreCase("Connected");
    }

    public boolean addPortMapping(PortMapping portMapping) {
        String[] keys = new String[]{"NewRemoteHost", "NewExternalPort", "NewProtocol", "NewInternalPort", "NewInternalClient", "NewEnabled", "NewPortMappingDescription", "NewLeaseDuration"};
        String[] values = new String[]{"", "" + portMapping.externalPort, portMapping.protocol, "" + portMapping.internalPort, portMapping.internalClient, "1", portMapping.description, "0"};
        try {
            Map result = Device.executeUPnPAction(this.controlURL, this.serviceType, "AddPortMapping", keys, values);
            return result.get("errorCode") == null;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public String getExternalIPAddress() throws IOException {
        Map result = Device.executeUPnPAction(this.controlURL, this.serviceType, "GetExternalIPAddress", new String[0], new String[0]);
        return (String)result.get("NewExternalIPAddress");
    }

    public boolean getPortMapping(int index, PortMapping portMapping) throws IOException {
        Map result = Device.executeUPnPAction(this.controlURL, this.serviceType, "GetGenericPortMappingEntry", new String[]{"NewPortMappingIndex"}, new String[]{"" + index});
        if (result == null) {
            return false;
        }
        try {
            portMapping.externalPort = Integer.parseInt((String)result.get("NewExternalPort"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            portMapping.internalPort = Integer.parseInt((String)result.get("NewInternalPort"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        portMapping.remoteHost = (String)result.get("NewRemoteHost");
        portMapping.internalClient = (String)result.get("NewInternalClient");
        portMapping.protocol = (String)result.get("NewProtocol");
        portMapping.enabled = (String)result.get("NewEnabled");
        portMapping.description = (String)result.get("NewPortMappingDescription");
        return result.get("errorCode") == null;
    }

    public static Map executeUPnPAction(String url, String service, String action, String[] keys, String[] values) throws IOException {
        StringBuffer soapMessage = new StringBuffer();
        soapMessage.append("<?xml version=\"1.0\"?>\r\n");
        soapMessage.append("<SOAP-ENV:Envelope ");
        soapMessage.append("xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" ");
        soapMessage.append("SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">");
        soapMessage.append("<SOAP-ENV:Body>");
        soapMessage.append("<m:").append(action).append(" xmlns:m=\"").append(service).append("\">");
        for (int i = 0; i < keys.length; ++i) {
            soapMessage.append("<").append(keys[i]).append(">");
            soapMessage.append(values[i]);
            soapMessage.append("</").append(keys[i]).append(">");
        }
        soapMessage.append("</m:").append(action).append(">");
        soapMessage.append("</SOAP-ENV:Body></SOAP-ENV:Envelope>");
        byte[] soapMessageBytes = soapMessage.toString().getBytes();
        URL postUrl = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)postUrl.openConnection();
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        conn.setRequestProperty("Content-Type", "text/xml");
        conn.setRequestProperty("SOAPAction", service + "#" + action);
        conn.setRequestProperty("Connection", "Close");
        conn.setRequestProperty("Content-Length", "" + soapMessageBytes.length);
        conn.getOutputStream().write(soapMessageBytes);
        HashMap<String, String> result = new HashMap<String, String>();
        if (conn.getResponseCode() != 200) {
            conn.disconnect();
            return null;
        }
        String res = StreamUtils.readAllAsString(conn.getInputStream());
        Matcher matcher = xmlPattern.matcher(res);
        while (matcher.find()) {
            result.put(matcher.group(1), matcher.group(2));
        }
        conn.disconnect();
        return result;
    }

    public void printMappings() throws IOException {
        boolean con = true;
        int index = 0;
        while (con) {
            PortMapping mapping = new PortMapping();
            if (!(con = this.getPortMapping(index++, mapping))) continue;
            System.out.println("\t" + mapping);
        }
    }

    public ArrayList getPortMappingsByName(String name) throws IOException {
        ArrayList<PortMapping> portList = new ArrayList<PortMapping>();
        boolean con = true;
        int index = 0;
        while (con) {
            PortMapping mapping = new PortMapping();
            if (!(con = this.getPortMapping(index++, mapping)) || mapping.description == null || !mapping.description.equals(name)) continue;
            portList.add(mapping);
        }
        return portList;
    }

    public void deletePortMappings(ArrayList portMappingsByName) throws IOException {
        for (int i = 0; i < portMappingsByName.size(); ++i) {
            PortMapping mapping = (PortMapping)portMappingsByName.get(i);
            this.deletePortMapping(mapping);
        }
    }
}

