/*
 * Decompiled with CFR 0.152.
 */
package utils.udp.bidirectional;

import com.aem.nodelink.utils.ThreadPool;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import utils.udp.bidirectional.UDPListener;
import utils.udp.bidirectional.UDPReader;
import utils.udp.bidirectional.UDPResponder;
import utils.udp.bidirectional.UnrecognisedPacketHandler;
import utils.udp.util.UDPWrapUtil;

public class PooledUDPServer
implements UDPResponder {
    public static int UDP_RECEIVE_BUFSIZE = 2048000;
    UDPListener handler;
    private DatagramSocket dsock;
    boolean die = false;
    ArrayList pool = new ArrayList();
    Object readLOCK = new Object();
    UDPWrapUtil send = new UDPWrapUtil();
    HandlerPool hpool;
    FailHandlerPool fpool;
    UnrecognisedPacketHandler failHandler;

    @Override
    public String getSocketInfo() {
        return "" + this.dsock.getLocalPort();
    }

    public PooledUDPServer(int port, InetAddress addr, UDPListener handler) throws IOException {
        this.dsock = new DatagramSocket(port, addr);
        this.dsock.setReceiveBufferSize(UDP_RECEIVE_BUFSIZE);
        System.out.println("[UDP Server] Buffer size " + this.dsock.getReceiveBufferSize());
        this.handler = handler;
    }

    public PooledUDPServer(int port, UDPListener handler) throws IOException {
        this.dsock = new DatagramSocket(port);
        this.dsock.setReceiveBufferSize(UDP_RECEIVE_BUFSIZE);
        System.out.println("[UDP Server] Buffer size " + this.dsock.getReceiveBufferSize());
        this.handler = handler;
    }

    public void die() {
        for (int i = 0; i < this.pool.size(); ++i) {
            ((UDPReader)this.pool.get(i)).die();
        }
        this.pool.clear();
    }

    public void startWithDefaultPoolSize() {
        this.startWithPoolSize(2, 10, 1);
    }

    public void startWithShPoolSettings() {
        this.startWithPoolSize(1, 10, 10, 1, 10);
    }

    public void startWithPoolSize(int reading, int processing, int unrecognised) {
        this.startWithPoolSize(reading, processing, 10, unrecognised, 5);
    }

    public void startWithPoolSize(int reading, int processing, int processingPriority, int unrecognised, int unrecognisedPriority) {
        System.out.println("[Pooled UDP Server] Starting " + processing + " handlers with pri " + processingPriority);
        this.hpool = new HandlerPool(new ThreadPool("UdpProcessing", processing, 100, processingPriority));
        System.out.println("[Pooled UDP Server] Starting " + unrecognised + " fail handlers with pri " + unrecognisedPriority);
        this.fpool = new FailHandlerPool(new ThreadPool("UdpUnrecognised", unrecognised, 100, unrecognisedPriority));
        for (int i = 0; i < reading; ++i) {
            UDPReader r = new UDPReader(this.readLOCK, this.dsock, 4096, this.handler, this);
            if (this.failHandler != null) {
                r.setUnrecognisedPacketHandler(this.failHandler);
            }
            r.start();
            this.pool.add(r);
        }
    }

    public void setUnrecognisedPacketHandler(UnrecognisedPacketHandler failHandler) {
        this.failHandler = failHandler;
    }

    @Override
    public String getHostFor(Object uid) {
        return ((InetSocketAddress)uid).getAddress().getHostAddress();
    }

    @Override
    public int getPortFor(Object uid) {
        return ((InetSocketAddress)uid).getPort();
    }

    @Override
    public void send(byte[] dat, Object uid) throws IOException {
        this.send(dat, 0, dat.length, uid);
    }

    @Override
    public void send(byte[] dat, int off, int len, Object uid) throws IOException {
        DatagramPacket dp = this.send.wrap(dat, off, len);
        dp.setSocketAddress((SocketAddress)uid);
        this.dsock.send(dp);
    }

    @Override
    public void sendUnwrapped(byte[] dat, int off, int len, Object uid) throws IOException {
        DatagramPacket dp = new DatagramPacket(dat, off, len);
        dp.setSocketAddress((SocketAddress)uid);
        this.dsock.send(dp);
    }

    class FailHandlerPool
    implements UnrecognisedPacketHandler {
        ThreadPool tp;

        public FailHandlerPool(ThreadPool tp) {
            this.tp = tp;
        }

        @Override
        public void unrecognisedUdpPacket(byte[] dat, int len, Object uid, UDPResponder respond) {
            if (PooledUDPServer.this.failHandler == null) {
                return;
            }
            Instance i = new Instance();
            i.dat = dat;
            i.len = len;
            i.uid = uid;
            i.respond = respond;
            if (!this.tp.runAsync(i)) {
                // empty if block
            }
        }

        class Instance
        implements Runnable {
            byte[] dat;
            int len;
            Object uid;
            UDPResponder respond;

            Instance() {
            }

            @Override
            public void run() {
                UnrecognisedPacketHandler fail = PooledUDPServer.this.failHandler;
                if (fail != null) {
                    fail.unrecognisedUdpPacket(this.dat, this.len, this.uid, this.respond);
                }
            }
        }
    }

    class HandlerPool
    implements UDPListener {
        ThreadPool tp;

        public HandlerPool(ThreadPool tp) {
            this.tp = tp;
        }

        @Override
        public void handleMessage(byte[] dat, Object uid, UDPResponder respond, String remoteIPAddress) {
            Instance i = new Instance();
            i.dat = dat;
            i.uid = uid;
            i.respond = respond;
            i.remoteIPAddress = remoteIPAddress;
            if (!this.tp.runAsync(i)) {
                // empty if block
            }
        }

        class Instance
        implements Runnable {
            byte[] dat;
            Object uid;
            UDPResponder respond;
            String remoteIPAddress;

            Instance() {
            }

            @Override
            public void run() {
                PooledUDPServer.this.handler.handleMessage(this.dat, this.uid, this.respond, this.remoteIPAddress);
            }
        }
    }
}

