/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.utils.shadowlabel;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.LabelUI;
import javax.swing.plaf.basic.BasicLabelUI;
import utils.swing.utils.shadowlabel.Effects;

public class ShadowLabelUI
extends BasicLabelUI {
    public static LabelUI downShadowUI = new ShadowLabelUI(true, Color.BLACK);
    public static LabelUI upShadowUI = new ShadowLabelUI(false, Color.BLACK);
    private boolean down = true;
    private Color color;

    public ShadowLabelUI(boolean down, Color color) {
        this.color = color;
        this.down = down;
    }

    @Override
    protected void installDefaults(JLabel c) {
        super.installDefaults(c);
        if (c.getBorder() == null) {
            c.setBorder(new EmptyBorder(2, 2, 2, 2));
        }
    }

    @Override
    protected void paintDisabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        g.setColor(l.getBackground().darker());
        g.translate(textX, textY);
        Effects.paintTextShadow((Graphics2D)g, s, this.color, this.down);
        g.translate(-textX, -textY);
    }

    @Override
    protected void paintEnabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        g.setColor(l.getForeground());
        g.translate(textX, textY);
        Effects.paintTextShadow((Graphics2D)g, s, this.color, this.down);
        g.translate(-textX, -textY);
    }
}

