/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.tree;

import java.awt.Color;
import java.util.ArrayList;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.tree.CheckNodeSelectionListener;
import utils.swing.tree.CheckRenderer;
import utils.swing.tree.IconNode;
import utils.swing.utils.TreeUtil;

public class CheckTree
extends JTree {
    JScrollPane mypane;
    IconNode root = new IconNode();
    Object state;

    public CheckTree() {
        CheckNodeSelectionListener select = new CheckNodeSelectionListener(this);
        select.setButtonWidth(22);
        CheckRenderer rend = new CheckRenderer();
        rend.setBackground(Color.white);
        this.setRowHeight(SimpleHelpLookAndFeel.scale(22));
        this.setCellRenderer(rend);
        this.addMouseListener(select);
        this.setBorder(SHBorderFactory.createEmptyBorder(2, 5, 2, 5));
        this.setRootVisible(false);
        this.root.setUserObject("(hidden root)");
        DefaultTreeModel model = new DefaultTreeModel(this.root);
        this.setModel(model);
    }

    public void addTreeModelListener(TreeModelListener listener) {
        this.getModel().addTreeModelListener(listener);
    }

    public IconNode getRoot() {
        return this.root;
    }

    public void reinitModel() {
        this.initModel(this.root);
    }

    public void initModel(IconNode root) {
        this.saveState();
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        boolean childrenPresent = false;
        for (int i = 0; i < root.getChildCount(); ++i) {
            TreeNode node = root.getChildAt(i);
            if (node.getChildCount() <= 0) continue;
            childrenPresent = true;
            break;
        }
        model.setRoot(root);
        this.revalidate();
        this.repaint();
        this.setShowsRootHandles(childrenPresent);
        this.restoreState();
    }

    public ArrayList<TreeNode> toList() {
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        TreeNode root = (TreeNode)this.getModel().getRoot();
        for (int i = 0; i < root.getChildCount(); ++i) {
            TreeNode node = root.getChildAt(i);
            TreeUtil.nodesAsList(node, list);
        }
        return list;
    }

    public JScrollPane getScrollPane() {
        if (this.mypane == null) {
            this.mypane = new JScrollPane(this);
        }
        return this.mypane;
    }

    public void saveState() {
        this.state = TreeUtil.saveState(this);
    }

    public void restoreState() {
        if (this.state != null) {
            TreeUtil.loadState(this, this.state);
        }
    }
}

