/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.simplelist.wrapper.filter;

import java.util.ArrayList;
import java.util.HashSet;
import utils.swing.simplelist.EventList;
import utils.swing.simplelist.SimpleList;
import utils.swing.simplelist.listener.ListEvent;
import utils.swing.simplelist.listener.ListListener;

public class FilterWrapper<E>
extends SimpleList<E>
implements ListListener<E> {
    protected EventList<E> listToBeFiltered;
    private boolean caseSensitive = true;
    private boolean useSpaceAsAnd = true;
    private String[] filterTextSplit;
    private int[] filterIndexToListIndex = new int[100];
    private int filterIndexToListIndexSize = 0;

    public FilterWrapper(EventList<E> listToBeFiltered) {
        this.listToBeFiltered = listToBeFiltered;
        listToBeFiltered.addListListener(this);
    }

    private void grow(int size) {
        if (size > this.filterIndexToListIndex.length) {
            int[] newArray = new int[(int)((double)Math.max(this.filterIndexToListIndex.length, size) * 1.5)];
            System.arraycopy(this.filterIndexToListIndex, 0, newArray, 0, this.filterIndexToListIndexSize);
            this.filterIndexToListIndex = newArray;
        }
    }

    private void removeFilterIndex(int filterIndex) {
        if (filterIndex >= 0) {
            if (filterIndex + 1 >= this.filterIndexToListIndexSize) {
                this.filterIndexToListIndex[filterIndex] = -1;
            } else {
                try {
                    System.arraycopy(this.filterIndexToListIndex, filterIndex + 1, this.filterIndexToListIndex, filterIndex, this.filterIndexToListIndexSize - filterIndex - 1);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    e.printStackTrace();
                }
            }
            --this.filterIndexToListIndexSize;
        }
    }

    private void insertListIndexForFilterIndex(int listIndex) {
        int filterIndex = this.getFilterIndexForListIndex(listIndex);
        this.insertListIndexForFilterIndex(listIndex, filterIndex);
    }

    private void insertListIndexForFilterIndex(int listIndex, int filterIndex) {
        this.incrementSubsequentIndices(listIndex);
        this.grow(this.filterIndexToListIndexSize + 1);
        System.arraycopy(this.filterIndexToListIndex, filterIndex, this.filterIndexToListIndex, filterIndex + 1, this.filterIndexToListIndexSize - filterIndex);
        this.filterIndexToListIndex[filterIndex] = listIndex;
        ++this.filterIndexToListIndexSize;
    }

    private void decrementSubsequentIndices(int listIndexMin) {
        for (int i = 0; i < this.filterIndexToListIndexSize; ++i) {
            if (this.filterIndexToListIndex[i] < listIndexMin) continue;
            int n = i;
            this.filterIndexToListIndex[n] = this.filterIndexToListIndex[n] - 1;
        }
    }

    private void incrementSubsequentIndices(int listIndexMin) {
        for (int i = 0; i < this.filterIndexToListIndexSize; ++i) {
            if (this.filterIndexToListIndex[i] < listIndexMin) continue;
            int n = i;
            this.filterIndexToListIndex[n] = this.filterIndexToListIndex[n] + 1;
        }
    }

    private int getListIndexForFilterIndex(int filterIndex) {
        return this.filterIndexToListIndex[filterIndex];
    }

    private int getFilterIndexForListIndex(int listIndex) {
        int result = FilterWrapper.binarySearch(this.filterIndexToListIndex, 0, this.filterIndexToListIndexSize, listIndex);
        if (result < 0) {
            return -1 * (result + 1);
        }
        return result;
    }

    private static int binarySearch(int[] a, int fromIndex, int toIndex, int key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public void stats() {
        System.out.println("FilterWrapper size:" + this.size() + " filterIndexToListIndexSize:" + this.filterIndexToListIndexSize);
        System.out.println(this);
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (int i = 0; i < this.filterIndexToListIndexSize; ++i) {
            if (i > 0) {
                builder.append(",");
            }
            builder.append(i + "->" + this.filterIndexToListIndex[i]);
        }
        builder.append("]");
        System.out.println(builder);
    }

    public void useSpaceAsAnd(boolean useSpaceAsAnd) {
        this.useSpaceAsAnd = useSpaceAsAnd;
    }

    public void setCaseSensitive(boolean cs) {
        this.caseSensitive = cs;
    }

    public void setFilterTexts(String[] filters) {
        this.filterTextSplit = filters;
        this.doFilter();
    }

    public void setFilterText(String text) {
        this.filterTextSplit = text != null ? text.split("\\s+") : null;
        this.doFilter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilter() {
        this.startBatch();
        try {
            HashSet elementsToRemove = new HashSet();
            HashSet elementsAlreadyIncluded = new HashSet();
            for (Object object : this) {
                if (!this.isIncluded(object)) {
                    elementsToRemove.add(object);
                    continue;
                }
                elementsAlreadyIncluded.add(object);
            }
            for (Object object : elementsToRemove) {
                int index = this.removeAndGetIndex(object);
                this.removeFilterIndex(index);
            }
            int insertIndex = 0;
            for (Object object : this.listToBeFiltered) {
                if (elementsAlreadyIncluded.contains(object)) {
                    ++insertIndex;
                    continue;
                }
                if (!this.isIncluded(object)) continue;
                this.add(insertIndex++, object);
            }
        }
        finally {
            this.endBatch();
        }
    }

    protected boolean isIncluded(E object) {
        if (this.filterTextSplit == null) {
            return true;
        }
        if (object == null) {
            return false;
        }
        String objectString = object instanceof Filterable ? ((Filterable)object).getFilterString() : object.toString();
        if (!this.useSpaceAsAnd) {
            for (String filter : this.filterTextSplit) {
                if (!(this.caseSensitive ? objectString.contains(filter) : objectString.toLowerCase().contains(filter.toLowerCase()))) continue;
                return true;
            }
            return false;
        }
        for (String filter : this.filterTextSplit) {
            if (!(this.caseSensitive ? !objectString.contains(filter) : !objectString.toLowerCase().contains(filter.toLowerCase()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void debugDump(String tab) {
        System.out.println(tab + "--- Filter Wrapper---");
        super.debugDump(tab);
        System.out.println(tab + "--- wrapped up ---");
        ((SimpleList)this.listToBeFiltered).debugDump(tab + "\t");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void listAltered(ListEvent<E> event) {
        switch (event.getBlockType()) {
            case 1: {
                this.startBatch();
                try {
                    ArrayList<E> affectedElements = event.getAffectedElements();
                    for (E element : affectedElements) {
                        int removedFilterIndex = this.removeAndGetIndex(element);
                        this.removeFilterIndex(removedFilterIndex);
                        this.decrementSubsequentIndices(event.getBlockStart());
                    }
                    break;
                }
                finally {
                    this.endBatch();
                }
            }
            case 2: {
                this.startBatch();
                try {
                    this.updateAll(event.getAffectedElements());
                    break;
                }
                finally {
                    this.endBatch();
                }
            }
            case 0: {
                this.startBatch();
                try {
                    int listStart = event.getBlockStart();
                    if (event.getBlockEnd() == this.listToBeFiltered.size()) {
                        ArrayList<E> affectedElements = event.getAffectedElements();
                        for (E element : affectedElements) {
                            if (this.isIncluded(element)) {
                                this.add(element);
                                this.insertListIndexForFilterIndex(listStart);
                            }
                            ++listStart;
                        }
                    } else {
                        ArrayList<E> affectedElements = event.getAffectedElements();
                        int insertionPoint = -1;
                        if (affectedElements.size() > 0) {
                            insertionPoint = this.getFilterIndexForListIndex(event.getBlockStart());
                        }
                        for (int i = affectedElements.size() - 1; i >= 0; --i) {
                            E o = affectedElements.get(i);
                            if (this.isIncluded(o)) {
                                this.add(insertionPoint, o);
                                this.insertListIndexForFilterIndex(event.getBlockStart(), insertionPoint);
                                continue;
                            }
                            this.incrementSubsequentIndices(event.getBlockStart());
                        }
                    }
                    return;
                }
                finally {
                    this.endBatch();
                }
            }
        }
        this.doFilter();
    }

    public static void main(String[] args) {
        SimpleList<Integer> list = new SimpleList<Integer>();
        FilterWrapper wrapper = new FilterWrapper(list);
        list.add(100);
        list.add(101);
        list.add(102);
        wrapper.setFilterText("101");
        wrapper.setFilterText(null);
        for (int i = 0; i < wrapper.size(); ++i) {
            System.out.println(wrapper.get(i));
        }
    }

    public static interface Filterable {
        public String getFilterString();
    }
}

