/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.nolaf;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import javax.swing.plaf.ProgressBarUI;
import utils.swing.customlaf.SHBorderFactory;

public class NoLafProgressBarUI
extends ProgressBarUI
implements ActionListener {
    public static final String KEY_COLOR = "COLOR";
    public static final Integer COLOR_GREEN = new Integer(2);
    public static final Integer COLOR_DARKBLUE = new Integer(3);
    public static final Integer COLOR_LIGHBLUE = new Integer(4);
    public static final Integer COLOR_GREY = new Integer(5);
    private BufferedImage progressBarImage;
    private BufferedImage trackImage;
    private Timer timer;
    private int maxFrames;
    private int currentFrame = 0;
    private JProgressBar progressBar;

    @Override
    public void installUI(JComponent c) {
        this.progressBar = (JProgressBar)c;
        int imageIndex = 2;
        Integer color = (Integer)c.getClientProperty(KEY_COLOR);
        if (color != null) {
            imageIndex = color;
        }
        try {
            this.progressBarImage = this.progressBar.isIndeterminate() ? ImageIO.read(NoLafProgressBarUI.class.getResourceAsStream("/utils/swing/nolaf/progress_piece" + imageIndex + ".png")) : ImageIO.read(NoLafProgressBarUI.class.getResourceAsStream("/utils/swing/nolaf/progress" + imageIndex + ".png"));
            this.trackImage = ImageIO.read(NoLafProgressBarUI.class.getResourceAsStream("/utils/swing/nolaf/progress_track.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.progressBarImage != null && this.trackImage != null) {
            this.maxFrames = this.progressBarImage.getWidth();
            this.timer = new Timer(30, this);
            this.timer.setInitialDelay(0);
            this.timer.start();
        } else {
            System.out.println("[NoLafProgressBarUI] ERROR - No progress bar Image loaded! (" + (this.progressBarImage != null) + ")(" + (this.trackImage != null) + ")");
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.progressBar = null;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        JProgressBar bar = (JProgressBar)c;
        if (bar.isIndeterminate()) {
            if (this.progressBarImage != null) {
                for (int index = this.currentFrame - this.maxFrames; index < c.getWidth(); index += this.progressBarImage.getWidth()) {
                    g2d.drawImage((Image)this.progressBarImage, index, 0, null);
                }
            }
        } else if (this.progressBarImage != null && this.trackImage != null) {
            int paintToPoint;
            int startX;
            int value = bar.getValue();
            int max = bar.getMaximum();
            int min = bar.getMinimum();
            int width = bar.getWidth();
            for (startX = paintToPoint = width * value / (max - min); startX < width - this.trackImage.getWidth(); startX += this.trackImage.getWidth() - 1) {
                g2d.drawImage((Image)this.trackImage, startX, 0, null);
            }
            g2d.drawImage((Image)this.trackImage, width - this.trackImage.getWidth(), 0, null);
            if (paintToPoint == 0) {
                return;
            }
            for (startX = 0 - this.progressBarImage.getWidth(); startX < paintToPoint - this.progressBarImage.getWidth(); startX += this.progressBarImage.getWidth() - 1) {
                g2d.drawImage((Image)this.progressBarImage, startX, 0, null);
            }
            g2d.drawImage((Image)this.progressBarImage, paintToPoint - this.progressBarImage.getWidth(), 0, null);
        }
        Toolkit.getDefaultToolkit().sync();
        g2d.dispose();
    }

    public static void main(String[] args) throws IOException {
        JProgressBar bar1;
        int i;
        JFrame frame = new JFrame();
        frame.setSize(300, 300);
        frame.setDefaultCloseOperation(3);
        JPanel panel = new JPanel(new GridLayout(9, 1));
        panel.setBorder(SHBorderFactory.createEmptyBorder(20, 20, 20, 20));
        final ArrayList<JProgressBar> bars = new ArrayList<JProgressBar>();
        for (i = 2; i < 6; ++i) {
            bar1 = new JProgressBar();
            bar1.putClientProperty(KEY_COLOR, new Integer(i));
            bar1.putClientProperty("IMAGE", "progress_piece" + i + ".png");
            bar1.setIndeterminate(true);
            bar1.setUI(new NoLafProgressBarUI());
            panel.add(bar1);
        }
        for (i = 2; i < 6; ++i) {
            bar1 = new JProgressBar();
            bar1.putClientProperty(KEY_COLOR, new Integer(i));
            bar1.setValue(i * 20);
            bar1.putClientProperty("IMAGE", "progress" + i + ".png");
            bar1.setUI(new NoLafProgressBarUI());
            panel.add(bar1);
            bars.add(bar1);
        }
        frame.getContentPane().add(panel);
        frame.setVisible(true);
        new Thread(){

            @Override
            public void run() {
                block2: while (true) {
                    try {
                        Thread.sleep(30L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    int i = 0;
                    while (true) {
                        if (i >= bars.size()) continue block2;
                        JProgressBar bar = (JProgressBar)bars.get(i);
                        int val = bar.getValue() + 1;
                        if (val > bar.getMaximum()) {
                            val = bar.getMinimum();
                        }
                        bar.setValue(val);
                        ++i;
                    }
                    break;
                }
            }
        }.start();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ++this.currentFrame;
        if (this.currentFrame > this.maxFrames) {
            this.currentFrame = 0;
        }
        if (this.progressBar != null) {
            this.progressBar.repaint();
        }
    }
}

