/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.logview;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import utils.files.FileUtil;
import utils.progtools.Counter;
import utils.progtools.profiler.SamplingProfiler;
import utils.string.CharStack;
import utils.string.SimpleRegex;
import utils.swing.SwingUtil;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.dnd.FileDropListener;
import utils.swing.dnd.TextDropListener;
import utils.swing.dnd.awt.DragAndDropHandler;
import utils.swing.layout.BorderPanel;
import utils.swing.layout.LinePanel;
import utils.swing.layout.VariableLinePanel;
import utils.swing.listeners.SystemExitWindowListener;
import utils.swing.logview.CTShifter;
import utils.swing.logview.LogEntry;
import utils.swing.logview.LogFile;
import utils.swing.logview.LogHeaderRenderer;
import utils.swing.logview.LogIcons;
import utils.swing.logview.LogModel;
import utils.swing.logview.LogRenderer;
import utils.swing.logview.mining.EmptyLogEntity;
import utils.swing.logview.mining.EntityMiner;
import utils.swing.logview.mining.LogEntity;
import utils.swing.logview.mining.LogMiner;
import utils.swing.logview.mining.LogSummary;
import utils.swing.logview.mining.MultiLogEntity;
import utils.swing.logview.mining.SummaryMiner;
import utils.swing.logview.shelp.SHMinerSet;
import utils.swing.tree.CheckTree;
import utils.swing.tree.IconCheckNode;
import utils.swing.tree.IconNode;
import utils.swing.utils.TreeUtil;

public class LogView
implements FileDropListener,
TextDropListener,
AdjustmentListener,
MouseListener,
ActionListener,
KeyListener,
ListSelectionListener,
TreeModelListener {
    boolean STRIP_TIMING = true;
    public static boolean EXIT_ON_CLOSE = false;
    static ImageIcon search = LogIcons.getIcon("search.png");
    static ImageIcon filter = LogIcons.getIcon("filter.png");
    Insets insets = new ScaledInsets(3, 3, 3, 3);
    JFrame frame;
    BorderPanel big = new BorderPanel();
    VariableLinePanel top = new VariableLinePanel(1, false, true);
    JLabel messageCount = new JLabel("1000 messages");
    JButton msgPlus = new JButton("+");
    JButton msgMinus = new JButton("-");
    JButton clearAll = new JButton("Clear");
    BorderPanel west = new BorderPanel();
    CheckTree tree = new CheckTree();
    IconNode filternode = new IconNode();
    JButton fliprows = new JButton("Lines");
    JToggleButton andfilters = new JToggleButton("AND");
    JToggleButton shading = new JToggleButton("Shade", false);
    JButton delfilter = new JButton("Del");
    JTextField findfield = new JTextField();
    JTextField filterfield = new JTextField();
    LinePanel filterbuttons = new LinePanel(1, true, false);
    Color bgnorm = new JLabel().getBackground();
    Color bgmid = this.bgnorm.darker();
    ArrayList<LogMiner> miners = new ArrayList();
    LogRenderer logrend;
    LogModel model = new LogModel();
    JTable table = new JTable(this.model);
    JScrollPane master;
    String LOGS = "LOGS";
    String SUMMARY = "SUMMARY";
    BorderPanel details = new BorderPanel();
    LinePanel texts = new LinePanel(0, false, true);
    LinePanel icons = new LinePanel(0, false, true);
    JPanel cards;
    int rowHeight;
    HashMap<String, IconNode> nodes = new HashMap();
    Counter entityCounter = new Counter();
    long validYear = -1L;
    long validMonth = -1L;
    long validDay = -1L;
    int findFrom = 0;

    public void showLog() {
        CardLayout cl = (CardLayout)this.cards.getLayout();
        cl.show(this.cards, this.LOGS);
    }

    private JLabel getSummary(LogSummary log) {
        JLabel summary = new JLabel();
        if (log.hidden) {
            summary.setText("<html>" + log.name + ": " + log.summary + "</html>");
        } else {
            summary.setText("<html><b>" + log.name + ": " + log.summary + "</b></html>");
        }
        summary.setBackground(LogRenderer.bgdark);
        if (log.error) {
            summary.setBackground(LogRenderer.bgbad);
        } else if (log.warning) {
            summary.setBackground(LogRenderer.bgwarn);
        }
        summary.setForeground(Color.white);
        summary.setOpaque(true);
        summary.setBorder(new EmptyBorder(3, 3, 3, 3));
        summary.setVerticalAlignment(1);
        return summary;
    }

    public void showSummary(ArrayList<LogSummary> summaries) {
        this.texts.removeAll();
        this.icons.removeAll();
        this.icons.setBackground(LogRenderer.bgdark);
        this.icons.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.icons.setOpaque(true);
        this.icons.add(new JLabel(LogHeaderRenderer.getIconForType(summaries.get((int)0).summary)));
        this.texts.setBackground(LogRenderer.bgdark);
        this.texts.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.texts.setOpaque(true);
        for (LogSummary summary : summaries) {
            this.texts.add(this.getSummary(summary));
        }
        CardLayout cl = (CardLayout)this.cards.getLayout();
        cl.show(this.cards, this.SUMMARY);
    }

    public LogView() {
        this.frame = new JFrame();
        this.frame.getContentPane().add(this.big);
        DragAndDropHandler dnd = new DragAndDropHandler(this, this);
        dnd.addDragAndDropToComponent(this.frame);
        this.top.setGridSpacing(this.insets);
        this.top.setOpaque(true);
        this.top.setBackground(this.bgmid);
        this.top.add(this.messageCount);
        this.top.add(this.msgPlus);
        this.top.add(this.msgMinus);
        this.top.add(this.clearAll);
        this.master = new JScrollPane(this.table);
        this.master.setColumnHeader(new JViewport(){

            @Override
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.height = 75;
                return d;
            }
        });
        this.master.getVerticalScrollBar().addAdjustmentListener(this);
        this.master.getHorizontalScrollBar().addAdjustmentListener(this);
        this.logrend = new LogRenderer(this.master, this.table);
        this.logrend.setShadingEnabled(this.shading.isSelected());
        this.table.setFont(new Font("monospaced", 0, 12));
        this.table.getTableHeader().setDefaultRenderer(new LogHeaderRenderer(this.master));
        this.table.setDefaultRenderer(LogEntry.class, this.logrend);
        this.table.setDefaultRenderer(String.class, this.logrend);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.addKeyListener(this);
        this.rowHeight = this.table.getRowHeight();
        this.table.getTableHeader().addMouseListener(this);
        this.details.addMouseListener(this);
        this.details.addCenter(this.texts);
        this.details.addWest(this.icons);
        this.cards = new JPanel(new CardLayout());
        this.cards.add((Component)this.master, this.LOGS);
        this.cards.add((Component)this.details, this.SUMMARY);
        this.big.addCenter(this.cards);
        this.big.addWest(this.west);
        this.filternode.setIcon(LogIcons.filter);
        this.filternode.setUserObject("Search Filters");
        this.tree.addTreeModelListener(this);
        this.tree.getRoot().add(this.filternode);
        this.west.addCenter(this.tree.getScrollPane());
        this.filterbuttons.setGridLayoutSpacing(this.insets.bottom, this.insets.bottom);
        this.filterbuttons.add(this.fliprows);
        this.filterbuttons.add(this.andfilters);
        this.filterbuttons.add(this.shading);
        this.filterbuttons.add(this.delfilter);
        BorderPanel strip = new BorderPanel();
        strip.addSouth(this.filterbuttons);
        BorderPanel findp = new BorderPanel(new Insets(3, 3, 3, 3));
        findp.addWest(new JLabel(search));
        findp.addCenter(this.findfield);
        BorderPanel filterp = new BorderPanel(new Insets(3, 3, 3, 3));
        filterp.addWest(new JLabel(filter));
        filterp.addCenter(this.filterfield);
        BorderPanel bars = new BorderPanel();
        bars.addNorth(findp);
        bars.addSouth(filterp);
        strip.addNorth(bars);
        this.west.addNorth(strip);
        this.findfield.addKeyListener(this);
        this.filterfield.addKeyListener(this);
        this.fliprows.addActionListener(this);
        this.andfilters.addActionListener(this);
        this.delfilter.addActionListener(this);
        this.shading.addActionListener(this);
        this.frame.setBounds(0, 0, 1100, 600);
        SwingUtil.centreFrame(this.frame);
        this.frame.setVisible(true);
        if (EXIT_ON_CLOSE) {
            this.frame.addWindowListener(new SystemExitWindowListener());
        }
    }

    public void addMinerSet(ArrayList<LogMiner> miners) {
        this.miners.addAll(miners);
    }

    public static void main(String[] args) {
        EXIT_ON_CLOSE = true;
        LogView view = new LogView();
        view.addMinerSet(SHMinerSet.SET);
    }

    private long getLogFileTime(File file) {
        long time = 0L;
        String fname = file.getName();
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SSS");
            int index = fname.indexOf("-20");
            if (index != -1) {
                fname = fname.substring(index + 1);
                time = sdf.parse(fname).getTime();
            }
            System.out.println("[LogView] Time for " + fname + " is " + time);
        }
        catch (Exception x) {
            System.out.printf("Unable to parse date from " + fname, new Object[0]);
        }
        return time;
    }

    private String stripCircular(String line) {
        try {
            if (line.startsWith("##")) {
                if ((line = line.substring(line.indexOf("## |") + 4).trim()).endsWith(" |") && line.length() > 7) {
                    line = line.substring(0, line.length() - 7);
                    while (line.endsWith("#")) {
                        line = line.substring(0, line.length() - 1);
                    }
                }
            } else if (line.startsWith("--") && (line = line.substring(line.indexOf("-- |") + 4).trim()).endsWith(" |") && line.length() > 7) {
                line = line.substring(0, line.length() - 7);
                line = line.substring(0, line.length() - 7);
                while (line.endsWith("-")) {
                    line = line.substring(0, line.length() - 1);
                }
            }
        }
        catch (StringIndexOutOfBoundsException x) {
            System.out.println("LINE: " + line);
            x.printStackTrace();
            System.exit(1);
        }
        return line;
    }

    boolean haveNode(String node) {
        return this.nodes.containsKey(node);
    }

    IconNode getCheckNodeFor(String name, boolean create) {
        IconCheckNode node = (IconCheckNode)this.nodes.get(name);
        if (node == null && create) {
            node = new IconCheckNode();
            this.nodes.put(name, node);
        }
        return node;
    }

    IconNode getNodeFor(String name, boolean create) {
        IconNode node = this.nodes.get(name);
        if (node == null && create) {
            node = new IconNode();
            this.nodes.put(name, node);
        }
        return node;
    }

    private void setNodeIcon(IconNode node, LogEntity entity) {
        while (entity.icon == null) {
            entity = entity.parent;
            if (entity != null) continue;
            return;
        }
        if (entity.icon != null) {
            node.setIcon(entity.icon);
        }
    }

    private void logFileAdded(File file) throws IOException {
        String s = FileUtil.readFileAsString(file);
        long lftime = this.getLogFileTime(file);
        System.out.println("Logfile time for " + file + " is " + lftime);
        if (lftime != 0L) {
            this.validYear = new Date(lftime).getYear() + 1900;
            this.validMonth = new Date(lftime).getMonth() + 1;
            this.validDay = new Date(lftime).getDay();
            System.out.println("Got valid year from log name: " + this.validYear);
        }
        if (s.startsWith("file://")) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        int CINDEX = 0;
        CINDEX = s.indexOf("[CircularLogStream] End of log start");
        if (CINDEX != -1) {
            int chop = s.indexOf(10, CINDEX);
            String[] initial = s.substring(0, CINDEX).trim().split("\n");
            String[] latter = s.substring(chop + 1).trim().split("\n");
            for (String line : initial) {
                list.add(line);
            }
            list.add("[LogView] CIRCULAR LOG STREAM START, DATA MAY BE DROPPED FROM BUFFER AT THIS POINT");
            int seqMin = -1;
            int seqMax = -1;
            for (String line : latter) {
                String token = null;
                if (line.startsWith("##")) {
                    token = "##";
                } else if (line.startsWith("--")) {
                    token = "--";
                }
                if (token == null) continue;
                line = line.substring(token.length());
                int index = line.indexOf(token);
                String numstr = line.substring(0, index);
                int seq = Integer.parseInt(numstr);
                if (seqMin == -1) {
                    seqMin = seq;
                }
                if (seqMax == -1) {
                    seqMax = seq;
                }
                if (seq < seqMin) {
                    seqMin = seq;
                }
                if (seq <= seqMax) continue;
                seqMax = seq;
            }
            if (seqMin == seqMax) {
                for (String line : latter) {
                    line = this.stripCircular(line);
                    list.add(line);
                }
            } else {
                for (int n = seqMin; n <= seqMax; ++n) {
                    for (String line : latter) {
                        if (!line.startsWith("##" + n) && !line.startsWith("--" + n)) continue;
                        line = this.stripCircular(line);
                        list.add(line);
                    }
                }
            }
        } else {
            String[] lines;
            for (String line : lines = s.split("\n")) {
                list.add(line);
            }
        }
        LogFile logfile = new LogFile();
        logfile.fullName = file.getName();
        logfile.tailName = file.getName();
        try {
            CharStack cs = new CharStack(logfile.tailName);
            cs.popToEnd();
            cs.backward();
            cs.popUntil("-");
            cs.popUntil("-");
            cs.popUntil("-");
            cs.forward();
            if (cs.peek() == '-') {
                cs.pop();
            }
            String secs = cs.popXmlIdentifier(true);
            cs.pop();
            String millis = cs.popXmlIdentifier(true);
            logfile.tailName = secs + "-" + millis;
            System.out.println("Got log file tail: " + logfile.tailName);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        for (LogMiner miner : this.miners) {
            miner.reset();
            miner.feedLog(s);
            miner.feedLines(list);
            if (miner instanceof SummaryMiner) {
                logfile.summaries.addAll(((SummaryMiner)miner).getSummaryLines());
            }
            if (!(miner instanceof EntityMiner)) continue;
            ArrayList<LogEntity> found = ((EntityMiner)miner).getDetectedEntities();
            for (LogEntity entity : found) {
                IconNode node;
                boolean isNew;
                System.out.println("LE: " + entity);
                this.entityCounter.add(entity.getName(), 1.0);
                if (!(this.entityCounter.get(entity.getName()) >= (double)entity.minCount) || !(isNew = !this.haveNode(entity.getName()))) continue;
                if (entity instanceof EmptyLogEntity) {
                    node = this.getNodeFor(entity.getName(), true);
                } else {
                    node = this.getCheckNodeFor(entity.getName(), true);
                    ((IconCheckNode)node).setSelected(entity.enabled);
                }
                this.setNodeIcon(node, entity);
                node.setUserObject(entity);
                if (entity.parent == null) {
                    this.tree.getRoot().add(node);
                    continue;
                }
                IconNode parent = this.getNodeFor(entity.parent.getName(), false);
                parent.add(node);
            }
            this.tree.reinitModel();
        }
        ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
        for (String line : list) {
            entries.add(new LogEntry(logfile, -1L, line));
        }
        logfile.setLogFileStartTime(lftime);
        logfile.setRows(entries);
        CTShifter.buildAndTimestamp(logfile);
        for (LogEntry le : entries) {
            int index;
            if (!this.STRIP_TIMING || (index = le.value.indexOf("(+")) == -1) continue;
            int strip = le.value.indexOf(41, index);
            le.value = le.value.substring(strip + 1);
        }
        this.model.addLogFile(logfile, this.getFilters(), !this.andfilters.isSelected(), this.getHides());
        this.updateTableShape();
        System.out.println("---- LOG FILE DROP ----");
        System.out.println(logfile.dumpString());
        System.out.println("---- END LOG FILE SUMMARY ----");
    }

    public ArrayList<LogEntity> getFilters() {
        ArrayList<LogEntity> filters = new ArrayList<LogEntity>();
        ArrayList<TreeNode> list = this.tree.toList();
        for (TreeNode node : list) {
            if (!(TreeUtil.getUserObject(node) instanceof LogEntity)) continue;
            LogEntity entity = (LogEntity)TreeUtil.getUserObject(node);
            entity.enabled = node instanceof IconCheckNode ? ((IconCheckNode)node).isSelected() : false;
            if (!entity.enabled || entity.isHideFilter()) continue;
            filters.add(entity);
        }
        return filters;
    }

    public ArrayList<LogEntity> getHides() {
        ArrayList<LogEntity> filters = new ArrayList<LogEntity>();
        ArrayList<TreeNode> list = this.tree.toList();
        for (TreeNode node : list) {
            if (!(TreeUtil.getUserObject(node) instanceof LogEntity)) continue;
            LogEntity entity = (LogEntity)TreeUtil.getUserObject(node);
            entity.enabled = node instanceof IconCheckNode ? ((IconCheckNode)node).isSelected() : false;
            if (!entity.enabled || !entity.isHideFilter()) continue;
            filters.add(entity);
        }
        return filters;
    }

    void updateTableShape() {
        TableColumnModel cols = this.table.getColumnModel();
        for (int i = 0; i < cols.getColumnCount(); ++i) {
            cols.getColumn(i).setPreferredWidth(250);
            if (i == 0) {
                cols.getColumn(i).setPreferredWidth(100);
            }
            if (i != cols.getColumnCount() - 1) continue;
            cols.getColumn(i).setPreferredWidth(1000);
        }
    }

    void updateFilters() {
        System.out.println("Updating filters...");
        SamplingProfiler profiler = new SamplingProfiler();
        profiler.startSampling(100);
        this.model.updateFilters(this.getFilters(), !this.andfilters.isSelected(), this.getHides());
        profiler.stopSampling();
        profiler.dump(1.0);
        System.out.println("Updated filters");
        this.updateTableShape();
    }

    @Override
    public void textDropped(String s) {
    }

    @Override
    public void filesDropped(File[] files) {
        Arrays.sort(files, new LogFileComparator());
        for (File f : files) {
            try {
                this.logFileAdded(f);
            }
            catch (Throwable x) {
                x.printStackTrace();
            }
        }
    }

    public void addLogFile(File file) {
        try {
            this.logFileAdded(file);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.table.getTableHeader().repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Object o = e.getSource();
        if (o == this.details) {
            this.showLog();
        } else {
            Point pp = e.getPoint();
            final int col = this.table.columnAtPoint(pp);
            Rectangle r = this.table.getTableHeader().getHeaderRect(col);
            if (pp.x - r.x >= 7 && pp.x - r.x <= r.width - 7) {
                if (pp.x - r.x < 32) {
                    SwingUtilities.invokeLater(new Thread(){

                        @Override
                        public void run() {
                            LogView.this.model.removeLogFile(col, LogView.this.getFilters(), !LogView.this.andfilters.isSelected(), LogView.this.getHides());
                            LogView.this.updateTableShape();
                            LogView.this.table.repaint();
                        }
                    });
                    try {
                        Thread.sleep(300L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    SwingUtilities.invokeLater(new Thread(){

                        @Override
                        public void run() {
                            LogView.this.table.repaint();
                        }
                    });
                } else if (col > 0) {
                    ArrayList<LogSummary> summaries = this.model.getFullSummary(col);
                    this.showSummary(summaries);
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.shading) {
            this.logrend.setShadingEnabled(this.shading.isSelected());
            this.table.repaint();
        } else if (o == this.delfilter) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
            node.removeFromParent();
            this.tree.reinitModel();
            this.updateFilters();
        } else if (o == this.andfilters) {
            this.updateFilters();
        } else if (o == this.fliprows) {
            final int currentRow = this.getCurrentRow();
            System.out.println("Current row is: " + currentRow);
            if (this.table.getRowHeight() == this.rowHeight) {
                this.table.setRowHeight(this.rowHeight * 3);
            } else {
                this.table.setRowHeight(this.rowHeight);
            }
            this.master.invalidate();
            this.master.revalidate();
            this.master.repaint();
            SwingUtilities.invokeLater(new Thread(){

                @Override
                public void run() {
                    LogView.this.master.repaint();
                    LogView.this.jumpToRow(currentRow);
                }
            });
        }
    }

    public void jumpToRow(int row) {
        this.table.setRowSelectionInterval(row, row);
        Rectangle rect = new Rectangle(this.table.getCellRect(row, 0, true));
        int height = this.master.getHeight() / 2;
        rect.y -= height;
        rect.height = height * 2;
        this.table.scrollRectToVisible(rect);
    }

    public int getCurrentRow() {
        JViewport viewport = this.master.getViewport();
        Point p = viewport.getViewPosition();
        p.y += this.master.getHeight() / 2;
        int rowIndex = this.table.rowAtPoint(p);
        return rowIndex;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        Object o = e.getSource();
        if (o == this.findfield) {
            if (e.getKeyCode() == 10) {
                String search = this.findfield.getText().trim();
                System.out.println("Looking for " + search);
                if (!search.startsWith("*")) {
                    search = "*" + search;
                }
                if (!search.endsWith("*")) {
                    search = search + "*";
                }
                int row = this.model.getIndexMatching(SimpleRegex.simpleToPattern(search, false), this.findFrom);
                System.out.println("Next index is " + row);
                if (row != -1) {
                    this.jumpToRow(row);
                    this.findFrom = row + 1;
                } else {
                    this.findFrom = 0;
                }
            }
        } else if (o == this.filterfield) {
            if (e.getKeyCode() == 10) {
                String search = this.filterfield.getText().trim();
                boolean hide = false;
                if (search.startsWith("-")) {
                    hide = true;
                    search = search.substring(1);
                }
                if (search.length() > 0) {
                    search = search.trim();
                    MultiLogEntity me = new MultiLogEntity(search, hide);
                    me.add(search);
                    me.setHide(hide);
                    me.enabled = true;
                    if (!hide) {
                        String[] matches;
                        for (String match : matches = search.split("\\*")) {
                            if ((match = match.trim()).length() <= 0) continue;
                            me.addAnnotation(match);
                        }
                    }
                    IconCheckNode node = new IconCheckNode();
                    node.setUserObject(me);
                    node.setSelected(me.enabled);
                    node.setIcon(LogIcons.filter);
                    this.filternode.add(node);
                    this.tree.reinitModel();
                    this.filterfield.setText("");
                    this.updateFilters();
                    TreeUtil.expandBySearch(this.tree, this.filternode.getUserObject());
                }
            }
        } else if (e.isAltDown() || e.isAltGraphDown()) {
            int step;
            JScrollBar bar;
            if (e.getKeyCode() == 40 || e.getKeyCode() == 34) {
                bar = this.master.getVerticalScrollBar();
                step = bar.getMaximum() / 50;
                bar.setValue(Math.min(bar.getMaximum(), bar.getValue() + step));
            }
            if (e.getKeyCode() == 38 || e.getKeyCode() == 33) {
                bar = this.master.getVerticalScrollBar();
                step = bar.getMaximum() / 50;
                bar.setValue(Math.max(bar.getMinimum(), bar.getValue() - step));
            }
            JViewport viewport = this.master.getViewport();
            Point p = viewport.getViewPosition();
            int rowIndex = this.table.rowAtPoint(p);
            this.table.setRowSelectionInterval(rowIndex, rowIndex);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
        this.updateFilters();
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
    }

    class LogFileComparator
    implements Comparator {
        LogFileComparator() {
        }

        public int compare(Object o1, Object o2) {
            File f1 = (File)o1;
            File f2 = (File)o2;
            String s1 = LogView.this.getLogFileTime(f1) + "";
            String s2 = LogView.this.getLogFileTime(f2) + "";
            return s1.compareTo(s2);
        }
    }
}

