/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.logview;

import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import utils.progtools.EnElapsedTimeFormatter;
import utils.string.StringSimilarity;
import utils.swing.logview.LogEntry;
import utils.swing.logview.LogFile;
import utils.swing.logview.mining.LogEntity;
import utils.swing.logview.mining.LogSummary;

public class LogModel
implements TableModel {
    Object LOCK = new Object();
    ArrayList<LogFile> logfiles = new ArrayList();
    ArrayList<LogEntry> all = new ArrayList();
    ArrayList<String> annotations = new ArrayList();
    EnElapsedTimeFormatter etf = new EnElapsedTimeFormatter();
    double smoothSimilarity = 1.0;
    ArrayList<TableModelListener> listeners = new ArrayList();

    @Override
    public int getRowCount() {
        return this.all.size();
    }

    public int getIndexMatching(Pattern match, int from) {
        for (int row = from; row < this.all.size(); ++row) {
            if (!match.matcher(this.all.get((int)row).value).matches()) continue;
            return row;
        }
        return -1;
    }

    public ArrayList<String> getAnnotations() {
        return this.annotations;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private void rebuild(ArrayList<LogEntity> filters, boolean anyFilter, ArrayList<LogEntity> hides) {
        this.annotations.clear();
        for (LogEntity entity : filters) {
            for (String note : entity.getAnnotations()) {
                if (this.annotations.contains(note)) continue;
                this.annotations.add(note);
            }
        }
        this.all.clear();
        for (Object file : this.logfiles) {
            file.resetIterator();
        }
        block3: while (true) {
            anchor = null;
            for (LogFile file : this.logfiles) {
                entry = file.peek();
                if (entry == null) continue;
                if (anchor == null) {
                    anchor = entry;
                    continue;
                }
                if (entry.time >= anchor.time) continue;
                anchor = entry;
            }
            if (anchor == null) break;
            anchor.file.pop();
            tail = new ArrayList<LogEntry>();
            tail.add(anchor);
            while (!anchor.file.isEmpty()) {
                test = anchor.file.peek();
                if (!test.value.trim().startsWith("[")) {
                    tail.add(test);
                    test.file.pop();
                    added = true;
                } else {
                    added = false;
                }
                if (added) continue;
            }
            skip = false;
            if (filters.size() > 0) {
                anyMatch = false;
                allMatch = true;
                for (LogEntity filter : filters) {
                    entryMatch = false;
                    for (LogEntry ent : tail) {
                        if (!filter.matchesLine(ent)) continue;
                        entryMatch = true;
                    }
                    if (entryMatch) {
                        anyMatch = true;
                        continue;
                    }
                    allMatch = false;
                }
                if (anyFilter) {
                    if (!anyMatch) {
                        skip = true;
                    }
                } else if (!allMatch) {
                    skip = true;
                }
            }
            for (LogEntity filter : hides) {
                entryMatch = false;
                for (LogEntry ent : tail) {
                    if (!filter.matchesLine(ent)) continue;
                    entryMatch = true;
                }
                if (!entryMatch) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            if (anchor.file.isFirst()) {
                anchor.file.bigListStartPoint = this.all.size();
            } else if (anchor.file.isLast()) {
                anchor.file.bigListEndPoint = this.all.size();
            }
            var8_13 = tail.iterator();
            while (true) {
                if (var8_13.hasNext()) ** break;
                continue block3;
                ent = (LogEntry)var8_13.next();
                this.all.add(ent);
            }
            break;
        }
        System.out.println("[LogModel] Rebuilt OK, " + this.all.size() + " total log entries, " + this.logfiles.size() + " log files");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getColumnCount() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.logfiles.size() + 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLogTail(int columnIndex) {
        if (columnIndex == 0) {
            return "";
        }
        Object object = this.LOCK;
        synchronized (object) {
            LogFile f = this.logfiles.get(columnIndex - 1);
            return f.tailName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return "";
        }
        Object object = this.LOCK;
        synchronized (object) {
            return this.logfiles.get(columnIndex - 1).getHeader(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasErrors(int columnIndex) {
        Object object = this.LOCK;
        synchronized (object) {
            for (LogSummary sum : this.logfiles.get(columnIndex - 1).getSummaries()) {
                if (!sum.error) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasWarnings(int columnIndex) {
        Object object = this.LOCK;
        synchronized (object) {
            for (LogSummary sum : this.logfiles.get(columnIndex - 1).getSummaries()) {
                if (!sum.warning) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<LogSummary> getFullSummary(int columnIndex) {
        if (columnIndex == 0) {
            return null;
        }
        Object object = this.LOCK;
        synchronized (object) {
            return this.logfiles.get(columnIndex - 1).getSummaries();
        }
    }

    public int getColumnVisible(int column) {
        return this.logfiles.get(column - 1).getValidLines();
    }

    public int getColumnStart(int column) {
        return this.logfiles.get((int)(column - 1)).bigListStartPoint;
    }

    public int getColumnEnd(int column) {
        return this.logfiles.get((int)(column - 1)).bigListEndPoint;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return String.class;
        }
        return LogEntry.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public LogEntry getLogEntryAt(int rowIndex) {
        return this.all.get(rowIndex);
    }

    public double calculateSimilarity(int rowIndex) {
        LogEntry entry = this.getLogEntryAt(rowIndex);
        if (rowIndex > 20) {
            double max = 0.0;
            for (int i = rowIndex - 20; i < rowIndex; ++i) {
                LogEntry prev = this.getLogEntryAt(i);
                max = Math.max(StringSimilarity.similarity(entry.value, prev.value), max);
            }
            this.smoothSimilarity = max < this.smoothSimilarity ? max : this.smoothSimilarity * 0.8 + max * 0.2;
            return this.smoothSimilarity;
        }
        return 0.0;
    }

    public boolean isCentralTime(int rowIndex) {
        LogEntry entry = this.getLogEntryAt(rowIndex);
        return entry.isCentralTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            if (rowIndex == 0) {
                return "";
            }
            LogEntry entry = this.getLogEntryAt(rowIndex);
            LogEntry prev = this.getLogEntryAt(rowIndex - 1);
            if (entry.value.startsWith("[LogView] CIRCULAR")) {
                return "???????????????????????????????????????";
            }
            long ms = entry.time - prev.time;
            if (ms == 0L) {
                return "";
            }
            String suffix = "";
            if (ms >= 1000L) {
                return this.etf.getFormattedTime(ms) + suffix;
            }
            return entry.time - prev.time + suffix;
        }
        --columnIndex;
        Object object = this.LOCK;
        synchronized (object) {
            LogEntry entry = this.all.get(rowIndex);
            LogFile file = this.logfiles.get(columnIndex);
            if (entry.file == file) {
                return entry;
            }
            if (file.isBigListIndexInsideRange(rowIndex)) {
                return new LogEntry(null, 0L, "...");
            }
            return new LogEntry(null, 0L, "");
        }
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    private void notifyStructureChanged() {
        for (TableModelListener l : this.listeners) {
            TableModelEvent event = new TableModelEvent(this, -1);
            l.tableChanged(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFilters(ArrayList<LogEntity> filters, boolean anyFilter, ArrayList<LogEntity> hides) {
        Object object = this.LOCK;
        synchronized (object) {
            this.rebuild(filters, anyFilter, hides);
            this.notifyStructureChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLogFile(LogFile file, ArrayList<LogEntity> filters, boolean anyFilter, ArrayList<LogEntity> hides) {
        Object object = this.LOCK;
        synchronized (object) {
            this.logfiles.add(file);
            this.rebuild(filters, anyFilter, hides);
            this.notifyStructureChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLogFile(int column, ArrayList<LogEntity> filters, boolean anyFilter, ArrayList<LogEntity> hides) {
        Object object = this.LOCK;
        synchronized (object) {
            this.logfiles.remove(column - 1);
            this.rebuild(filters, anyFilter, hides);
            this.notifyStructureChanged();
        }
    }
}

