/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.logview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableCellRenderer;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.icons.CombinedIcon;
import utils.swing.layout.BorderPanel;
import utils.swing.logview.LogIcons;
import utils.swing.logview.LogModel;
import utils.swing.logview.LogRenderer;

public class LogHeaderRenderer
extends DefaultTableCellRenderer {
    JScrollPane master;
    static ImageIcon down = LogIcons.getIcon("log_ahead.png");
    static ImageIcon up = LogIcons.getIcon("log_back.png");
    static ImageIcon viewing = LogIcons.getIcon("log_viewing.png");
    static ImageIcon sh = LogIcons.getIcon("sh.png");
    static ImageIcon shg = LogIcons.getIcon("shg.png");
    static ImageIcon sho = LogIcons.getIcon("sho.png");
    static ImageIcon jw = LogIcons.getIcon("jw.png");

    public static ImageIcon getIconForType(String summary) {
        ImageIcon type = summary == null ? sh : (summary.startsWith("GU ") ? jw : (summary.startsWith("RA ") ? shg : (summary.startsWith("RS ") ? sho : sh)));
        return type;
    }

    public Icon getIcon(ImageIcon type, ImageIcon pos) {
        return new CombinedIcon(new Icon[]{type, pos}, new int[]{0, 0}, new int[]{0, 36});
    }

    public LogHeaderRenderer(JScrollPane master) {
        this.master = master;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (label == null) {
            return null;
        }
        label.setFont(label.getFont().deriveFont(SimpleHelpLookAndFeel.scale(11.0f)));
        label.setBackground(LogRenderer.bgdark);
        label.setForeground(Color.white);
        label.setVerticalAlignment(1);
        label.setBorder(new CompoundBorder(new LineBorder(Color.black, 1), new EmptyBorder(2, 2, 2, 2)));
        LogModel model = (LogModel)table.getModel();
        if (column == 0) {
            label.setBackground(LogRenderer.bgdark);
        } else if (model.hasErrors(column)) {
            label.setBackground(LogRenderer.bgbad);
        } else if (model.hasWarnings(column)) {
            label.setBackground(LogRenderer.bgwarn);
        } else {
            label.setBackground(LogRenderer.bgdark);
        }
        JViewport viewport = this.master.getViewport();
        Point p = viewport.getViewPosition();
        int visibleRow = table.rowAtPoint(p);
        if (column > 0) {
            String pos;
            String logtail = model.getLogTail(column);
            String summary = model.getColumnName(column);
            ImageIcon type = LogHeaderRenderer.getIconForType(summary);
            label.setIcon(this.getIcon(type, viewing));
            int visibleRows = model.getColumnVisible(column);
            int colStart = model.getColumnStart(column);
            int colEnd = model.getColumnEnd(column);
            if (visibleRow < colStart) {
                label.setIcon(this.getIcon(type, down));
                pos = ">>" + (colStart - visibleRow) + " (" + visibleRows + ") " + logtail;
            } else if (visibleRow > colEnd) {
                label.setIcon(this.getIcon(type, up));
                pos = "--" + (visibleRow - colEnd) + " (" + visibleRows + ") " + logtail;
            } else {
                double tot = colEnd - colStart;
                double pc = 100.0 / tot;
                pos = (int)(pc *= (double)(visibleRow - colStart)) + "% (" + visibleRows + ") " + logtail;
            }
            label.setText("<html>" + pos + "<br>" + summary + "</html>");
        } else {
            label.setIcon(null);
        }
        JLabel icons = new JLabel(label.getIcon());
        icons.setVerticalAlignment(1);
        BorderPanel bp = new BorderPanel();
        bp.addWest(icons);
        bp.addCenter(label);
        bp.setBackground(label.getBackground());
        bp.setBorder(label.getBorder());
        label.setIcon(null);
        label.setBorder(new EmptyBorder(0, 2, 2, 2));
        label.setPreferredSize(new Dimension(label.getPreferredSize().width, 75));
        return bp;
    }
}

