/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.logview;

import java.util.ArrayList;
import utils.swing.logview.LogEntry;
import utils.swing.logview.mining.LogEntity;
import utils.swing.logview.mining.LogSummary;

public class LogFile {
    public String fullName;
    public String tailName;
    public int bigListStartPoint = -1;
    public int bigListEndPoint = -1;
    public long logFileStartTime = -1L;
    public boolean transient_prevSkipped = false;
    ArrayList<LogEntry> lines = new ArrayList();
    int validLines = 0;
    int index = 0;
    ArrayList<LogSummary> summaries = new ArrayList();
    ArrayList<LogEntity> entities = new ArrayList();

    public boolean isBigListIndexInsideRange(int index) {
        return index >= this.bigListStartPoint && index <= this.bigListEndPoint;
    }

    public void setRows(ArrayList<LogEntry> entries) {
        this.lines = entries;
    }

    public void setLogFileStartTime(long t) {
        this.logFileStartTime = t;
    }

    public int getRows() {
        return this.lines.size();
    }

    public int getRowCount() {
        return this.lines.size();
    }

    public LogEntry getRow(int i) {
        return this.lines.get(i);
    }

    public ArrayList<LogSummary> getSummaries() {
        return this.summaries;
    }

    public String getHeader(boolean showHidden) {
        String ret = "";
        for (LogSummary summary : this.summaries) {
            if (summary.hidden) continue;
            ret = ret + summary.name + ": " + summary.summary + "<br>";
        }
        for (LogSummary summary : this.summaries) {
            if (!showHidden || !summary.hidden) continue;
            ret = ret + summary.name + ": " + summary.summary + "<br>";
        }
        return ret;
    }

    public int getValidLines() {
        return this.validLines;
    }

    public void resetIterator() {
        this.index = 0;
        this.validLines = 0;
    }

    public LogEntry peek() {
        if (this.isEmpty()) {
            return null;
        }
        return this.lines.get(this.index);
    }

    public LogEntry pop() {
        ++this.validLines;
        if (this.isEmpty()) {
            return null;
        }
        return this.lines.get(this.index++);
    }

    public void discard() {
        ++this.index;
    }

    public boolean isEmpty() {
        return this.index == this.lines.size();
    }

    public boolean isFirst() {
        return this.index == 0;
    }

    public boolean isLast() {
        return this.index == this.lines.size() - 1;
    }

    public String dumpString() {
        StringBuffer sb = new StringBuffer();
        for (LogSummary summary : this.summaries) {
            if (summary.hidden) continue;
            sb.append(summary.name + ": " + summary.summary);
            sb.append("\n");
        }
        for (LogSummary summary : this.summaries) {
            if (!summary.hidden) continue;
            sb.append("(hidden) " + summary.name + ": " + summary.summary);
            sb.append("\n");
        }
        for (LogEntity entity : this.entities) {
            sb.append("Entity: " + entity.getName());
            sb.append("\n");
        }
        return sb.toString();
    }
}

