/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.layout;

import java.awt.Color;
import javax.swing.JPanel;
import utils.swing.SwingUtil;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.layout.GbPanel;

public class SlackStylePanel {
    public GbPanel rootComponent = new GbPanel();
    private JPanel leftPanel = new JPanel();
    private JPanel middlePanel = new JPanel();
    private JPanel rightPanel = new JPanel();
    private boolean vertical = false;

    public SlackStylePanel() {
        this.initUI();
    }

    public JPanel getLeftPanel() {
        return this.leftPanel;
    }

    public JPanel getRightPanel() {
        return this.rightPanel;
    }

    public JPanel getMiddlePanel() {
        return this.middlePanel;
    }

    public void setLeftPanelVisible(boolean visible) {
        this.leftPanel.setVisible(visible);
        this.rootComponent.repaint();
    }

    private void initUI() {
        if (!this.vertical) {
            int X = 0;
            this.rootComponent.add(this.leftPanel, X++, 0, 1, 1, 0, 1, 10, 1);
            this.rootComponent.add(this.middlePanel, X++, 0, 1, 1, 0, 1, 10, 1);
            this.rootComponent.add(this.rightPanel, X++, 0, 1, 1, 1, 1, 10, 1);
        } else {
            int Y = 0;
            this.rootComponent.add(this.leftPanel, 0, Y++, 1, 1, 0, 1, 10, 1);
            this.rootComponent.add(this.middlePanel, 0, Y++, 1, 1, 0, 1, 10, 1);
            this.rootComponent.add(this.rightPanel, 0, Y++, 1, 1, 1, 1, 10, 1);
        }
    }

    public void setWidths(int leftWidth, int middleWidth) {
        SwingUtil.setWidth(this.leftPanel, leftWidth);
        SwingUtil.setWidth(this.middlePanel, middleWidth);
    }

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    public static void main(String[] args) throws InterruptedException {
        SimpleHelpFrame frame = new SimpleHelpFrame();
        SlackStylePanel panel = new SlackStylePanel();
        panel.leftPanel.setBackground(Color.red);
        panel.middlePanel.setBackground(Color.green);
        panel.rightPanel.setBackground(Color.blue);
        panel.setWidths(SimpleHelpLookAndFeel.scale(50), SimpleHelpLookAndFeel.scale(200));
        frame.getContentPane().add(panel.getRootComponent());
        frame.setSize(500, 500);
        frame.setVisible(true);
        Thread.sleep(1000L);
        panel.setLeftPanelVisible(false);
    }
}

