/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.images;

import java.awt.Color;

public class ColorFader {
    private final Color startColor;
    private final Color endColor;
    private final boolean andBack;
    private final int steps;
    private int step = 0;
    private boolean goingBack = false;

    public ColorFader(Color startColor, Color endColor, int steps, boolean andBack) {
        this.startColor = startColor;
        this.endColor = endColor;
        this.andBack = andBack;
        this.steps = steps;
    }

    public boolean isFinished() {
        return !this.andBack && this.step < this.steps;
    }

    public boolean atStart() {
        return this.step == 0;
    }

    public Color nextColor() {
        int r = this.startColor.getRed();
        int g = this.startColor.getGreen();
        int b = this.startColor.getBlue();
        int a = this.startColor.getAlpha();
        int endR = this.endColor.getRed();
        int endG = this.endColor.getGreen();
        int endB = this.endColor.getBlue();
        int endA = this.endColor.getAlpha();
        double factor = (double)this.step / (double)this.steps;
        Color nextColor = new Color((int)((double)r + (double)(endR - r) * factor), (int)((double)g + (double)(endG - g) * factor), (int)((double)b + (double)(endB - b) * factor), (int)((double)a + (double)(endA - a) * factor));
        if (this.step == this.steps) {
            if (this.andBack && !this.goingBack) {
                this.goingBack = true;
                --this.step;
            }
        } else if (this.step == 0) {
            if (this.goingBack) {
                this.goingBack = false;
            }
            ++this.step;
        } else {
            this.step = this.goingBack ? --this.step : ++this.step;
        }
        return nextColor;
    }

    public static void main(String[] args) {
        ColorFader fader = new ColorFader(Color.white, Color.red, 20, true);
        for (int i = 0; i < 50; ++i) {
            System.out.println(i + ") " + fader.nextColor());
        }
    }
}

