/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.icons;

public class ProgressRef {
    boolean extremeSmoothing = true;
    boolean smoothing = false;
    double progress;
    double visible;
    double accel = 1.15;
    double speedmin;
    double speed = this.speedmin = 1.0E-4;

    public ProgressRef() {
        this(0.0);
    }

    public ProgressRef(double progress) {
        this.progress = progress;
    }

    public void useSmoothing(boolean b) {
        this.smoothing = b;
    }

    public boolean isComplete() {
        return this.progress >= 1.0;
    }

    public void setProgress(double d) {
        d = Math.max(0.0, d);
        this.progress = d = Math.min(1.0, d);
        if (this.progress >= 1.0) {
            this.visible = 1.0;
        }
    }

    public double getActualProgress() {
        return this.progress;
    }

    public double getProgress() {
        if (this.smoothing) {
            this.advance();
            return this.visible;
        }
        return this.progress;
    }

    public void advance() {
        if (this.progress == 1.0) {
            this.visible = 1.0;
        } else {
            double diff = this.progress - this.visible;
            if (diff > 0.01) {
                if (!this.extremeSmoothing) {
                    this.visible += diff / 25.0;
                } else {
                    double maxSpeed = this.calculateMaxSpeedToActual();
                    if (maxSpeed > this.speed * this.accel) {
                        this.speed *= this.accel;
                    } else {
                        this.speed /= this.accel;
                        if (this.speed < this.speedmin) {
                            this.speed = this.speedmin;
                        }
                    }
                    this.visible += this.speed;
                    if (this.visible > this.progress) {
                        this.visible = this.progress;
                        this.speed = this.speedmin;
                    }
                }
            } else {
                this.visible = this.progress;
            }
        }
    }

    private double calculateMaxSpeedToActual() {
        double diff = this.progress - this.visible;
        double maxSpeed = this.speedmin;
        while ((diff -= (maxSpeed *= this.accel)) > this.speed) {
        }
        return maxSpeed;
    }
}

