/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.icons;

import java.awt.Color;
import java.util.Random;
import utils.swing.icons.CircularProgressIcon;
import utils.swing.icons.ProgressRef;
import utils.swing.icons.colorproviders.ColorProvider;
import utils.swing.icons.colorproviders.PastelColorProvider;
import utils.swing.images.ImageHelper;

public class InfiniteCircularProgressIcon
extends CircularProgressIcon
implements Runnable {
    private ProgressRef[] array;
    private final Random r = new Random();
    protected int chosen = 0;
    private long sleep = 200L;
    private double speed = 0.07;
    private final double MAX = 0.99999999999;
    long sleepTillTime = 0L;

    public InfiniteCircularProgressIcon(int w, int h) {
        this(w, h, new PastelColorProvider());
    }

    public void setSleep(long ms) {
        this.sleep = ms;
    }

    public void setSpeed(double mult) {
        this.speed = 0.09 * mult;
    }

    public InfiniteCircularProgressIcon(int w, int h, ColorProvider provider) {
        super(w, h);
        int N = w / this.getThickness();
        if (N > 3) {
            N = 3;
        }
        this.array = new ProgressRef[N];
        this.setColorProvider(provider);
        for (int i = 0; i < N; ++i) {
            this.array[i] = new ProgressRef(0.99999999999);
            this.addProgressRef(this.array[i]);
        }
        this.setFadeToTargetColor(true);
    }

    public void reinitRingCount(int N) {
        this.clearProgressRefs();
        this.array = new ProgressRef[N];
        for (int i = 0; i < N; ++i) {
            this.array[i] = new ProgressRef(0.99999999999);
            this.addProgressRef(this.array[i]);
        }
    }

    @Override
    protected void generateColorsFor(ProgressRef ref) {
        Color fg = this.colors.nextColor(0.0);
        Color bg = this.colors.nextColor(0.0);
        while (ImageHelper.maxContrast(fg, bg) < 40) {
            fg = this.colors.nextColor(0.0);
        }
        this.foregroundColours.add(fg);
        this.backgroundColours.add(bg);
    }

    @Override
    public void run() {
        if (this.array.length == 0 || System.currentTimeMillis() < this.sleepTillTime) {
            return;
        }
        int maxVisibleRings = this.getMaxVisibleRings();
        ProgressRef ref = this.array[this.chosen];
        if (ref.progress == 0.99999999999) {
            ref.progress = 0.0;
        }
        ref.progress += this.speed;
        if (ref.progress >= 1.0) {
            Color previousForeground;
            ref.progress = 0.99999999999;
            if (maxVisibleRings > 2) {
                int rint = Math.max(this.r.nextInt(maxVisibleRings), 1);
                this.chosen = (this.chosen + rint) % maxVisibleRings;
            } else if (maxVisibleRings > 1) {
                this.chosen = (this.chosen + 1) % maxVisibleRings;
            }
            Color newBackground = previousForeground = (Color)this.foregroundColours.get(this.chosen);
            this.backgroundColours.set(this.chosen, newBackground);
            Color fg = this.colors.nextColor(0.0);
            while (ImageHelper.maxContrast(fg, newBackground) < 40) {
                fg = this.colors.nextColor(0.0);
            }
            this.foregroundColours.set(this.chosen, fg);
            this.array[this.chosen].progress = 0.0;
            this.sleepTillTime = System.currentTimeMillis() + this.sleep;
        }
        this.c.repaint();
    }
}

