/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.icons;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.util.LinkedList;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import utils.progtools.WeakReferenceTimerThread;
import utils.swing.aa.AntiAliasingEnforcer;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.icons.InfiniteCircularProgressIcon;
import utils.swing.icons.ProgressRef;
import utils.swing.icons.colorproviders.ColorProvider;
import utils.swing.icons.colorproviders.HueColourProvider;
import utils.swing.icons.colorproviders.PastelColorProvider;
import utils.swing.images.ImageHelper;
import utils.swing.layout.BorderPanel;

public class CircularProgressIcon
implements Icon,
Runnable {
    private Icon alternate;
    Component c;
    WeakReferenceTimerThread wrt;
    ColorProvider colors;
    private int thick = 20;
    private int buffer = 0;
    private boolean forceInnerSpace = true;
    private final int w;
    private final int h;
    private final Object list_LOCK = new Object();
    private final LinkedList<ProgressRef> list = new LinkedList();
    protected final LinkedList<Color> foregroundColours = new LinkedList();
    protected final LinkedList<Color> backgroundColours = new LinkedList();
    private boolean drawBackground = true;
    private boolean removeWhenDone = true;
    private boolean baseColorOnValue = false;
    private boolean fadeToTarget = false;
    private boolean drawDebugBorder = false;
    private int outerBuffer = 0;

    public CircularProgressIcon(int w, int h) {
        this(w, h, new PastelColorProvider());
    }

    public CircularProgressIcon(int w, int h, ColorProvider colorProvider) {
        this.w = w;
        this.h = h;
        this.colors = colorProvider;
    }

    public void setForceInnerSpace(boolean b) {
        this.forceInnerSpace = b;
    }

    public void setArcDimensions(int thickness, int buffer) {
        this.thick = thickness;
        this.buffer = buffer;
    }

    public void setOuterBuffer(int outerBuffer) {
        this.outerBuffer = outerBuffer;
    }

    public void setBaseColorOnValue(boolean baseColorOnValue) {
        this.baseColorOnValue = baseColorOnValue;
    }

    public void setRemoveWhenDone(boolean remove) {
        this.removeWhenDone = remove;
    }

    public int getThickness() {
        return this.thick;
    }

    public void setAlternate(Icon icon) {
        this.alternate = icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearProgressRefs() {
        Object object = this.list_LOCK;
        synchronized (object) {
            this.list.clear();
            this.foregroundColours.clear();
            this.backgroundColours.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProgressRef(ProgressRef ref) {
        Object object = this.list_LOCK;
        synchronized (object) {
            this.list.add(ref);
            this.generateColorsFor(ref);
        }
    }

    protected void generateColorsFor(ProgressRef ref) {
        Color fg = this.colors.nextColor(0.0);
        Color bg = this.colors.nextBackgroundColor(0.0);
        this.foregroundColours.add(fg);
        this.backgroundColours.add(bg);
    }

    public void setColorProvider(ColorProvider colors) {
        this.colors = colors;
    }

    protected int getMaxVisibleRings() {
        int size = this.w - 2 * this.outerBuffer;
        return Math.min(size / this.thick, this.list.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.wrt == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        AntiAliasingEnforcer.makeHqAntialiased(g);
        g2.setRenderingHints(ImageHelper.getQualityRenderingHints());
        Object object = this.list_LOCK;
        synchronized (object) {
            if (this.list.size() == 0) {
                if (this.alternate != null) {
                    this.alternate.paintIcon(c, g, x, y);
                }
                return;
            }
            if (this.removeWhenDone) {
                for (int i = this.list.size() - 1; i >= 0; --i) {
                    if (!(this.list.get(i).getProgress() >= 1.0)) continue;
                    this.list.remove(i);
                    this.foregroundColours.remove(i);
                    this.backgroundColours.remove(i);
                }
            }
            int size = this.w - 2 * this.outerBuffer;
            int add = this.outerBuffer;
            size -= this.thick / 2;
            add += this.thick / 4;
            BasicStroke fgStroke = new BasicStroke(this.thick / 2 - this.buffer, 0, 1);
            g2.setStroke(fgStroke);
            for (int i = 0; !(i >= this.list.size() || this.forceInnerSpace && size <= this.thick || size < 1); ++i) {
                Arc2D.Double shape;
                double complete = this.list.get(i).getProgress();
                if (this.drawBackground) {
                    shape = new Arc2D.Double(x + add, y + add, size, size, 90.0, 360.0 * (1.0 - complete), 0);
                    if (this.baseColorOnValue) {
                        g2.setColor(this.colors.nextBackgroundColor(complete));
                    } else {
                        g2.setColor(this.backgroundColours.get(i));
                    }
                    g2.draw(shape);
                }
                shape = new Arc2D.Double(x + add, y + add, size, size, 90.0, -360.0 * complete, 0);
                if (this.baseColorOnValue) {
                    g2.setColor(this.colors.nextColor(complete));
                } else if (this.fadeToTarget) {
                    g2.setColor(this.getFadeColour(this.foregroundColours.get(i), this.backgroundColours.get(i), complete));
                } else {
                    g2.setColor(this.foregroundColours.get(i));
                }
                g2.draw(shape);
                size -= this.thick;
                add += this.thick / 2;
            }
        }
        if (this.drawDebugBorder) {
            g2.setStroke(new BasicStroke(1.0f));
            g2.setColor(Color.darkGray);
            g2.drawRect(x, y, this.w, this.h);
        }
    }

    private Color getFadeColour(Color fg, Color bg, double complete) {
        int rDiff = fg.getRed() - bg.getRed();
        int gDiff = fg.getGreen() - bg.getGreen();
        int bDiff = fg.getBlue() - bg.getBlue();
        return new Color(bg.getRed() + (int)(complete * (double)rDiff), bg.getGreen() + (int)(complete * (double)gDiff), bg.getBlue() + (int)(complete * (double)bDiff));
    }

    public void setDrawBackground(boolean drawBackground) {
        this.drawBackground = drawBackground;
    }

    @Override
    public int getIconWidth() {
        return this.w;
    }

    @Override
    public int getIconHeight() {
        return this.h;
    }

    public void setUpdateComponent(Component c) {
        this.c = c;
        if (this.wrt == null) {
            this.wrt = new WeakReferenceTimerThread(this, 40);
            this.wrt.start();
        }
    }

    public void switchOff() {
        if (this.wrt != null) {
            this.wrt.stop();
        }
        this.wrt = null;
        this.c.repaint();
    }

    public void switchOn() {
        this.setUpdateComponent(this.c);
    }

    @Override
    public void run() {
        this.c.repaint();
    }

    private void drawDebugBorder(boolean drawDebugBorder) {
        this.drawDebugBorder = drawDebugBorder;
    }

    public void setFadeToTargetColor(boolean fadeToTarget) {
        this.fadeToTarget = fadeToTarget;
    }

    public static void main(String[] args) throws Exception {
        CircularProgressIcon icon;
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        boolean INFINITE = false;
        if (INFINITE) {
            icon = new InfiniteCircularProgressIcon(72, 72);
            icon.setColorProvider(new HueColourProvider(new Color(101, 167, 239)));
        } else {
            ProgressRef ref = new ProgressRef(0.25);
            ProgressRef ref2 = new ProgressRef(0.45);
            ProgressRef ref3 = new ProgressRef(0.75);
            icon = new CircularProgressIcon(36, 36);
            icon.setColorProvider(new PastelColorProvider());
            icon.addProgressRef(ref);
            icon.addProgressRef(ref2);
            icon.addProgressRef(ref3);
            icon.setArcDimensions(10, 1);
            icon.setDrawBackground(true);
        }
        JLabel label = new JLabel(icon);
        if (INFINITE) {
            icon.setUpdateComponent(label);
        }
        BorderPanel main = new BorderPanel();
        main.addCenter(label);
        frame.getContentPane().add(main);
        frame.setVisible(true);
    }

    public static class LabeledIcon
    extends JPanel {
        public LabeledIcon(String text, CircularProgressIcon icon) {
            super(new BorderLayout());
            JLabel top = new JLabel(icon);
            JLabel bottom = new JLabel(text);
            this.add((Component)top, "Center");
            this.add((Component)bottom, "South");
            icon.setUpdateComponent(top);
            icon.drawDebugBorder(true);
            bottom.setHorizontalAlignment(0);
            this.setBackground(Color.white);
        }
    }
}

