/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.dnd.awt;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.Reader;
import java.net.URI;
import java.util.List;
import utils.swing.dnd.FileDropListener;
import utils.swing.dnd.TextDropListener;

public class DragAndDropHandler
implements DropTargetListener {
    FileDropListener fdrop;
    TextDropListener tdrop;

    public DragAndDropHandler(FileDropListener f) {
        this.fdrop = f;
    }

    public DragAndDropHandler(TextDropListener f) {
        this.tdrop = f;
    }

    public DragAndDropHandler(FileDropListener f, TextDropListener t) {
        this.fdrop = f;
        this.tdrop = t;
    }

    public void addDragAndDropToComponent(Component c) {
        new DropTarget(c, this);
    }

    private void addListFromDrop(DropTargetDropEvent dtde) {
        Transferable tfer;
        boolean fdropped = false;
        boolean tdropped = false;
        DataFlavor[] flav = dtde.getCurrentDataFlavors();
        for (int i = 0; i < flav.length; ++i) {
            if (this.fdrop != null && !fdropped && flav[i].isFlavorJavaFileListType()) {
                fdropped = true;
                tfer = dtde.getTransferable();
                try {
                    if ((dtde.getSourceActions() | 0x40000000) > 0) {
                        dtde.acceptDrop(0x40000000);
                    } else if ((dtde.getSourceActions() | 1) > 0) {
                        dtde.acceptDrop(1);
                    } else {
                        dtde.acceptDrop(0);
                    }
                    List file_list = (List)tfer.getTransferData(flav[i]);
                    File[] files = new File[file_list.size()];
                    file_list.toArray(files);
                    this.fdrop.filesDropped(files);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (this.tdrop == null || tdropped || !flav[i].isFlavorTextType()) continue;
            tdropped = true;
            tfer = dtde.getTransferable();
            try {
                if ((dtde.getSourceActions() | 0x40000000) > 0) {
                    dtde.acceptDrop(0x40000000);
                } else if ((dtde.getSourceActions() | 1) > 0) {
                    dtde.acceptDrop(1);
                } else {
                    dtde.acceptDrop(0);
                }
                if (flav[i].isRepresentationClassReader()) {
                    Reader reader = flav[i].getReaderForText(tfer);
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    int n = reader.read();
                    while (n != -1) {
                        bout.write(n);
                        n = reader.read();
                    }
                    this.tdrop.textDropped(new String(bout.toByteArray()));
                    continue;
                }
                Object o = tfer.getTransferData(flav[i]);
                if (o instanceof String) {
                    this.tdrop.textDropped((String)o);
                    continue;
                }
                System.out.println("Failed drop: " + o.getClass());
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.fdrop != null && !fdropped) {
            try {
                DataFlavor flavour = new DataFlavor("text/uri-list;class=java.lang.String");
                fdropped = true;
                tfer = dtde.getTransferable();
                if ((dtde.getSourceActions() | 0x40000000) > 0) {
                    dtde.acceptDrop(0x40000000);
                } else if ((dtde.getSourceActions() | 1) > 0) {
                    dtde.acceptDrop(1);
                } else {
                    dtde.acceptDrop(0);
                }
                String data = (String)tfer.getTransferData(flavour);
                String[] uris = data.split("\n");
                File[] files = new File[uris.length];
                for (int i = 0; i < uris.length; ++i) {
                    files[i] = new File(new URI(uris[i].trim()));
                }
                this.fdrop.filesDropped(files);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        try {
            this.addListFromDrop(dtde);
            dtde.dropComplete(true);
        }
        catch (ClassCastException e) {
            dtde.dropComplete(true);
        }
        catch (NullPointerException e) {
            dtde.dropComplete(true);
        }
        catch (Throwable t) {
            dtde.dropComplete(true);
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }
}

