/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.dialog.jdialog;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import javax.swing.JComponent;
import javax.swing.JPanel;
import utils.swing.SafeDialogIcon;
import utils.swing.SwingUtil;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.panels.AbstractDialogPanel;
import utils.swing.dialog.panels.DialogHandler;
import utils.swing.dialog.panels.OKCancelDialogPanel;

public class AbstractDialog
extends Dialog
implements DialogHandler {
    private final int width;
    private final Frame rootPane;
    protected AbstractDialogPanel dialogPanel;
    private boolean showDecoration;
    private JComponent closeRequestor;

    public AbstractDialog(Frame rootPane, int w, AbstractDialogPanel contentPanel) {
        super(rootPane);
        this.rootPane = rootPane;
        this.width = SimpleHelpLookAndFeel.scale(w);
        this.dialogPanel = contentPanel;
        contentPanel.setDialogHandler(this);
        this.add(contentPanel.getRootComponent());
        this.setModal(true);
    }

    public void setDialogIconImage(Image image) {
        SafeDialogIcon.setDialogIcon((Dialog)this, image);
    }

    public void showDialog() {
        this.setVisible(true);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.dialogPanel.prepareToShow(this.width);
            this.initialiseDialogSize();
            if (!this.showDecoration) {
                this.setUndecorated(true);
            }
        }
        super.setVisible(visible);
    }

    private void initialiseDialogSize() {
        JPanel rootComponent = this.dialogPanel.getRootComponent();
        SwingUtil.setWidth(rootComponent, this.width);
        Dimension preferredSize = this.dialogPanel.getRootComponent().getPreferredSize();
        this.setSize(preferredSize.width, preferredSize.height + SimpleHelpLookAndFeel.scale(20));
        if (this.rootPane != null) {
            this.setLocationRelativeTo(this.rootPane);
        }
    }

    public void setShowDecoration(boolean showDecoration) {
        this.showDecoration = showDecoration;
    }

    @Override
    public void setOkEnabled(boolean enabled) {
        if (this.dialogPanel instanceof OKCancelDialogPanel) {
            ((OKCancelDialogPanel)this.dialogPanel).setOkEnabled(enabled);
        }
    }

    public void closeDialog() {
        this.setVisible(false);
    }

    @Override
    public void okPressed() {
        if (this.dialogPanel instanceof OKCancelDialogPanel) {
            ((OKCancelDialogPanel)this.dialogPanel).okPressed();
        }
    }

    @Override
    public void cancelPressed() {
        this.closeDialog();
    }

    @Override
    public void closeDialog(JComponent closeRequestor) {
        this.closeRequestor = closeRequestor;
        this.setVisible(false);
    }

    @Override
    public JComponent getCloseRequestor() {
        return this.closeRequestor;
    }
}

