/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.dialog.glassdialog;

import java.awt.Dimension;
import java.awt.Window;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.UIManager;
import utils.swing.cui.types.CUIField;
import utils.swing.cui.types.LabelField;
import utils.swing.cui.types.ResultPair;
import utils.swing.cui.types.fields.TextField;
import utils.swing.dialog.contents.FixedWidthCUIPanel;
import utils.swing.dialog.contents.FixedWidthPanel;
import utils.swing.dialog.glassdialog.AbstractGlassDialog;
import utils.swing.dialog.glassdialog.MessageGlassDialog;
import utils.swing.dialog.glassdialog.PanelGlassDialog;
import utils.swing.dialog.panels.AbstractDialogPanel;
import utils.swing.dialog.panels.OKCancelDialogPanel;

public class SHGlassOptionPane {
    public static AbstractGlassDialog showBorderlessDialog(RootPaneContainer rpc, JComponent content, String title, int w) {
        FixedWidthPanel contentPanel = new FixedWidthPanel(content);
        AbstractDialogPanel dialogPanel = new AbstractDialogPanel();
        dialogPanel.setContent(contentPanel);
        AbstractGlassDialog dialog = new AbstractGlassDialog(rpc, w, dialogPanel);
        dialog.setShowDecoration(false);
        dialog.setVisible(true, false);
        return dialog;
    }

    public static boolean showOkCancelDialog(RootPaneContainer rpc, String message, String title, Icon image, String okButtonText) {
        return SHGlassOptionPane.showOkCancelDialog(rpc, message, title, image, okButtonText, UIManager.getString("OptionPane.cancelButtonText"));
    }

    public static boolean showOkCancelDialog(RootPaneContainer rpc, String message, String title, Icon image, String okButtonText, String cancelText) {
        MessageGlassDialog dialog = MessageGlassDialog.getDecoratedDialog(rpc, message, title, okButtonText, cancelText, image);
        dialog.showDialog();
        return dialog.isOKResult();
    }

    public static void showErrorDialog(RootPaneContainer rpc, String message, String title, Icon image, String okButtonText) {
        SHGlassOptionPane.showMessageDialog(rpc, message, title, image, okButtonText);
    }

    public static void showMessageDialog(RootPaneContainer rootp, String message, String title, Icon icon) {
        SHGlassOptionPane.showMessageDialog(rootp, message, title, icon, UIManager.getString("OptionPane.okButtonText"));
    }

    public static void showMessageDialog(RootPaneContainer rootp, String message, String title, Icon icon, String okText) {
        if (!SHGlassOptionPane.rpcVisible(rootp)) {
            return;
        }
        MessageGlassDialog decoratedDialog = MessageGlassDialog.getDecoratedDialog(rootp, message, title, okText, null, icon);
        decoratedDialog.showDialog();
    }

    public static boolean showOkCancelPanelDialog(RootPaneContainer rpc, JPanel panel, String title, int width, String okButtonText, String cancelButtonText) {
        return SHGlassOptionPane.showOkCancelPanelDialog(rpc, panel, title, width, okButtonText, cancelButtonText, true);
    }

    public static boolean showOkCancelPanelDialog(RootPaneContainer rpc, JPanel panel, String title, int width, String okButtonText, String cancelButtonText, boolean decorated) {
        PanelGlassDialog pgd = new PanelGlassDialog(rpc, title, width, okButtonText, cancelButtonText);
        pgd.setDecorated(decorated);
        pgd.setContentPanel(panel);
        pgd.showDialog();
        return pgd.isOK();
    }

    public static boolean showOkCancelPanelDialog(RootPaneContainer rpc, JComponent panel, String title, String okButtonText, String cancelButtonText) {
        Dimension d = panel.getPreferredSize();
        PanelGlassDialog pgd = new PanelGlassDialog(rpc, title, d.width, okButtonText, cancelButtonText);
        pgd.setContentPanel(panel);
        pgd.showDialog();
        return pgd.isOK();
    }

    public static String showInputDialog(RootPaneContainer rootp, String message, String title, Icon icon, String okstring, String defaultstr) {
        if (!SHGlassOptionPane.rpcVisible(rootp)) {
            return null;
        }
        TextField textField = new TextField(null, null);
        textField.setDefaultValue(defaultstr);
        textField.setRequired(true);
        CUIField[] field = new CUIField[]{new LabelField(message), textField};
        FixedWidthCUIPanel cuiPanel = new FixedWidthCUIPanel();
        cuiPanel.setFields(field);
        OKCancelDialogPanel dialogPanel = new OKCancelDialogPanel(okstring, UIManager.getString("OptionPane.cancelButtonText"));
        dialogPanel.setContent(cuiPanel);
        dialogPanel.setIcon(icon);
        AbstractGlassDialog dialog = new AbstractGlassDialog(rootp, 450, (AbstractDialogPanel)dialogPanel);
        dialog.setTitle(title);
        dialog.setShowDecoration(true);
        dialog.showDialog();
        if (dialogPanel.isOK()) {
            ResultPair[] results = cuiPanel.getResults(null);
            return results[0].getValue();
        }
        return null;
    }

    public static String showInputDialog(RootPaneContainer rootp, String message, String title, String okstring, String defaultstr) {
        return SHGlassOptionPane.showInputDialog(rootp, message, title, null, okstring, defaultstr);
    }

    private static boolean rpcVisible(RootPaneContainer rpc) {
        if (rpc instanceof Window) {
            return ((Window)((Object)rpc)).isVisible();
        }
        return true;
    }

    public static boolean showConfirmDialog(RootPaneContainer rpc, String message, String title, Icon icon, String okText) {
        return SHGlassOptionPane.showOkCancelDialog(rpc, message, title, icon, okText);
    }

    public static boolean showConfirmDialog(RootPaneContainer rpc, JComponent panel, String title, String okText) {
        return SHGlassOptionPane.showOkCancelPanelDialog(rpc, panel, title, okText, UIManager.getString("OptionPane.cancelButtonText"));
    }
}

