/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.dialog.contents;

import java.awt.GridLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import utils.swing.cui.layouts.CUIHorizontalPanel;
import utils.swing.cui.types.CUIField;
import utils.swing.cui.types.ResultPair;
import utils.swing.cui.types.fields.AbstractField;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.dialog.contents.FixedWidthPanel;
import utils.swing.dialog.contents.IsValidListener;
import utils.swing.dialog.panels.DialogHandler;

public class FixedWidthCUIPanel
extends FixedWidthPanel
implements AbstractField.ChangeListener {
    private DialogHandler handler;
    private Insets cuiPanelInsets = new ScaledInsets(5, 5, 5, 5);
    protected CUIHorizontalPanel cuiHorizontalPanel;
    protected CUIField[] fields;
    private IsValidListener listener;

    public FixedWidthCUIPanel() {
        this.setLayout(new GridLayout(1, 1));
    }

    public Insets getPanelInsets() {
        return this.cuiPanelInsets;
    }

    public void setValidListener(IsValidListener listener) {
        this.listener = listener;
        if (this.cuiHorizontalPanel != null) {
            this.cuiHorizontalPanel.setValidListener(listener);
        }
    }

    public void setFields(CUIField[] fields) {
        this.fields = fields;
        if (fields != null) {
            this.cuiHorizontalPanel = new CUIHorizontalPanel(this.cuiPanelInsets, true);
            this.cuiHorizontalPanel.addAll(fields);
            this.cuiHorizontalPanel.setChangeListener(this);
            this.cuiHorizontalPanel.setValidListener(this.listener);
            this.removeAll();
            this.add(this.cuiHorizontalPanel.getRootComponent());
            this.changed(null);
        }
    }

    @Override
    public void setDialogHandler(DialogHandler handler) {
        this.handler = handler;
        this.changed(null);
    }

    @Override
    public void changed(AbstractField changedField) {
        if (this.handler != null) {
            this.handler.setOkEnabled(this.cuiHorizontalPanel.isValid());
        }
    }

    public ResultPair[] getResults(ResourceBundle lang) {
        return this.cuiHorizontalPanel.getFilledOutResults(lang);
    }
}

